/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj.coords;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.util.Assert;

public class DMSLatLonPoint
implements Cloneable {
    private static final float MINUTE = 0.016666668f;
    private static final float SECOND = 2.7777778E-4f;
    public boolean lat_isnegative;
    public int lat_degrees;
    public int lat_minutes;
    public float lat_seconds;
    public boolean lon_isnegative;
    public int lon_degrees;
    public int lon_minutes;
    public float lon_seconds;

    public DMSLatLonPoint() {
    }

    public DMSLatLonPoint(boolean lat_isnegative, int lat_degrees, int lat_minutes, float lat_seconds, boolean lon_isnegative, int lon_degrees, int lon_minutes, float lon_seconds) {
        this.lat_isnegative = lat_isnegative;
        this.lat_degrees = (int)LatLonPoint.normalize_latitude(lat_degrees);
        if (this.lat_degrees < 0) {
            this.lat_degrees = -this.lat_degrees;
        }
        this.lat_minutes = DMSLatLonPoint.normalize_value(lat_minutes);
        this.lat_seconds = DMSLatLonPoint.normalize_value(lat_seconds);
        this.lon_isnegative = lon_isnegative;
        this.lon_degrees = (int)LatLonPoint.wrap_longitude(lon_degrees);
        if (this.lon_degrees < 0) {
            this.lon_degrees = -this.lon_degrees;
        }
        this.lon_minutes = DMSLatLonPoint.normalize_value(lon_minutes);
        this.lon_seconds = DMSLatLonPoint.normalize_value(lon_seconds);
    }

    public DMSLatLonPoint(LatLonPoint llp) {
        DMSLatLonPoint.getDMSLatLonPoint(llp, this);
    }

    static void getDMSLatLonPoint(LatLonPoint llp, DMSLatLonPoint dllp) {
        int min;
        float rem;
        int deg;
        dllp.lat_degrees = 0;
        dllp.lat_minutes = 0;
        dllp.lat_seconds = 0.0f;
        dllp.lat_isnegative = false;
        dllp.lon_degrees = 0;
        dllp.lon_minutes = 0;
        dllp.lon_seconds = 0.0f;
        dllp.lon_isnegative = false;
        float val = llp.getLatitude();
        if (val < 0.0f) {
            dllp.lat_isnegative = true;
            val = -val;
        }
        dllp.lat_degrees = (int)Math.floor(val);
        if (val >= 2.7777778E-4f) {
            deg = (int)val;
            rem = val - (float)deg;
            if (rem >= 0.016666668f) {
                dllp.lat_minutes = min = (int)(rem * 60.0f);
                rem -= (float)min * 0.016666668f;
            }
            if (rem >= 2.7777778E-4f) {
                float sec;
                dllp.lat_seconds = sec = rem * 3600.0f;
                rem -= sec * 2.7777778E-4f;
            }
        } else {
            dllp.lat_isnegative = false;
        }
        val = llp.getLongitude();
        if (val < 0.0f) {
            dllp.lon_isnegative = true;
            val = -val;
        }
        dllp.lon_degrees = (int)Math.floor(val);
        if (val >= 2.7777778E-4f) {
            deg = (int)val;
            rem = val - (float)deg;
            if (rem >= 0.016666668f) {
                dllp.lon_minutes = min = (int)(rem * 60.0f);
                rem -= (float)min * 0.016666668f;
            }
            if (rem >= 2.7777778E-4f) {
                float sec;
                dllp.lon_seconds = sec = rem * 3600.0f;
                rem -= sec * 2.7777778E-4f;
            }
        } else {
            dllp.lon_isnegative = false;
        }
    }

    public LatLonPoint getLatLonPoint() {
        return this.getLatLonPoint(null);
    }

    public LatLonPoint getLatLonPoint(LatLonPoint llp) {
        float lat = this.getDecimalLatitude();
        float lon = this.getDecimalLongitude();
        if (llp == null) {
            return new LatLonPoint(lat, lon);
        }
        llp.setLatLon(lat, lon);
        return llp;
    }

    public float getDecimalLatitude() {
        float val = (float)this.lat_degrees + (float)this.lat_minutes * 0.016666668f + this.lat_seconds * 2.7777778E-4f;
        return this.lat_isnegative ? -val : val;
    }

    public float getDecimalLongitude() {
        float val = (float)this.lon_degrees + (float)this.lon_minutes * 0.016666668f + this.lon_seconds * 2.7777778E-4f;
        return this.lon_isnegative ? -val : val;
    }

    public String toString() {
        return "DMSLatLonPoint[lat_isnegative = " + this.lat_isnegative + ", lat_degrees = " + this.lat_degrees + ", lat_minutes = " + this.lat_minutes + ", lat_seconds = " + this.lat_seconds + ", lon_isnegative = " + this.lon_isnegative + ", lon_degrees = " + this.lon_degrees + ", lon_minutes = " + this.lon_minutes + ", lon_seconds = " + this.lon_seconds + "]";
    }

    public void setDMSLatLon(DMSLatLonPoint llpt) {
        this.lat_isnegative = llpt.lat_isnegative;
        this.lat_degrees = llpt.lat_degrees;
        this.lat_minutes = llpt.lat_minutes;
        this.lat_seconds = llpt.lat_seconds;
        this.lon_isnegative = llpt.lon_isnegative;
        this.lon_degrees = llpt.lon_degrees;
        this.lon_minutes = llpt.lon_minutes;
        this.lon_seconds = llpt.lon_seconds;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            Assert.assertExp(false, "DMSLatLonPoint: internal error!");
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof DMSLatLonPoint) {
            DMSLatLonPoint pt = (DMSLatLonPoint)obj;
            return pt.lat_isnegative == this.lat_isnegative && pt.lat_degrees == this.lat_degrees && pt.lat_minutes == this.lat_degrees && pt.lat_seconds == pt.lat_seconds && pt.lon_isnegative == this.lon_isnegative && pt.lon_degrees == this.lon_degrees && pt.lon_minutes == pt.lon_minutes && pt.lon_seconds == this.lon_seconds;
        }
        return false;
    }

    public static final int normalize_value(int val) {
        if ((val %= 60) < 0) {
            val += 60;
        }
        return val;
    }

    public static final float normalize_value(float val) {
        if ((val %= 60.0f) < 0.0f) {
            val += 60.0f;
        }
        return val;
    }

    public int hashCode() {
        return this.lat_degrees | this.lon_degrees << 8 | this.lat_minutes + (int)this.lat_seconds << 16 | this.lon_minutes + (int)this.lon_seconds << 23;
    }
}

