/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.proj.BasicProjectionLoader;
import com.bbn.openmap.proj.DatumShiftProjection;
import com.bbn.openmap.proj.Ellipsoid;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.ProjectionException;
import com.bbn.openmap.proj.UTMProjection;
import com.bbn.openmap.proj.coords.DatumShiftGCT;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.util.Properties;

public class UTMProjectionLoader
extends BasicProjectionLoader {
    public static final String ZONE_NUMBER = "ZONE_NUMBER";
    public static final String ZONE_LETTER = "ZONE_LETTER";

    public UTMProjectionLoader() {
        super(UTMProjection.class, "UTM Projection", "UTM Projection");
    }

    public Projection create(Properties props) throws ProjectionException {
        try {
            LatLonPoint center = (LatLonPoint)props.get("CENTER");
            float scale = PropUtils.floatFromProperties(props, "SCALE", 1.0E7f);
            int height = PropUtils.intFromProperties(props, "HEIGHT", 100);
            int width = PropUtils.intFromProperties(props, "WIDTH", 100);
            int type = 993387;
            int zone_number = PropUtils.intFromProperties(props, ZONE_NUMBER, 0);
            char zone_letter = ((String)props.get(ZONE_LETTER)).charAt(0);
            boolean isnorthern = zone_letter == 'N';
            Ellipsoid ellps = (Ellipsoid)props.get("DATUM");
            Proj proj = new UTMProjection(center, scale, width, height, type, zone_number, isnorthern, ellps);
            if (ellps != null && ellps != Ellipsoid.WGS_84) {
                proj = new DatumShiftProjection(proj, new DatumShiftGCT(ellps));
            }
            return proj;
        }
        catch (Exception e) {
            if (Debug.debugging("proj")) {
                Debug.output("UTMProjectionLoader: problem creating UTM projection " + e.getMessage());
                e.printStackTrace();
            }
            throw new ProjectionException("UTMProjectionLoader: problem creating UTM projection");
        }
    }
}

