/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.proj.ProjectionStackTrigger;
import com.bbn.openmap.util.Debug;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

public class ProjectionStackSupport
implements Serializable {
    private transient ArrayList triggers;

    public synchronized void add(ProjectionStackTrigger pt) {
        if (this.triggers == null) {
            this.triggers = new ArrayList();
        }
        if (!this.triggers.contains(pt)) {
            this.triggers.add(pt);
        }
    }

    public synchronized void remove(ProjectionStackTrigger pt) {
        if (this.triggers == null) {
            return;
        }
        this.triggers.remove(pt);
    }

    public synchronized ArrayList getTriggers() {
        if (this.triggers == null) {
            return null;
        }
        return (ArrayList)this.triggers.clone();
    }

    public int size() {
        return this.triggers.size();
    }

    public void fireStackStatus(boolean enableBackProjections, boolean enableForwardProjections) {
        ArrayList targets = this.getTriggers();
        if (this.triggers == null) {
            return;
        }
        Iterator iterator = targets.iterator();
        while (iterator.hasNext()) {
            ProjectionStackTrigger target = (ProjectionStackTrigger)iterator.next();
            if (Debug.debugging("projectionstack")) {
                Debug.output("ProjectionStackSupport.fireStackStatus(): target is: " + target);
            }
            target.updateProjectionStackStatus(enableBackProjections, enableForwardProjections);
        }
    }
}

