/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.Environment;
import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.OMComponent;
import com.bbn.openmap.proj.CADRG;
import com.bbn.openmap.proj.CADRGLoader;
import com.bbn.openmap.proj.Gnomonic;
import com.bbn.openmap.proj.GnomonicLoader;
import com.bbn.openmap.proj.LLXY;
import com.bbn.openmap.proj.LLXYLoader;
import com.bbn.openmap.proj.LLXYView;
import com.bbn.openmap.proj.Mercator;
import com.bbn.openmap.proj.MercatorLoader;
import com.bbn.openmap.proj.MercatorView;
import com.bbn.openmap.proj.Orthographic;
import com.bbn.openmap.proj.OrthographicLoader;
import com.bbn.openmap.proj.OrthographicView;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.ProjectionException;
import com.bbn.openmap.proj.ProjectionLoader;
import com.bbn.openmap.util.Debug;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class ProjectionFactory
extends OMComponent {
    public static final String CENTER = "CENTER";
    public static final String SCALE = "SCALE";
    public static final String HEIGHT = "HEIGHT";
    public static final String WIDTH = "WIDTH";
    public static final String DATUM = "DATUM";
    public static final String AvailableProjectionProperty = "AvailableProjections";
    protected PropertyChangeSupport pcs;
    protected static ProjectionFactory instance;
    protected Vector projLoaders = new Vector();

    private ProjectionFactory() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public static ProjectionFactory getInstance() {
        if (instance == null) {
            instance = new ProjectionFactory();
        }
        return instance;
    }

    public static String[] getAvailableProjections() {
        ProjectionFactory factory = ProjectionFactory.getInstance();
        ArrayList projLoaders = new ArrayList(factory.getProjectionLoaders());
        int nProjections = projLoaders.size();
        String[] projNames = new String[nProjections];
        int i = 0;
        Iterator it = projLoaders.iterator();
        while (it.hasNext()) {
            projNames[i++] = ((ProjectionLoader)it.next()).getPrettyName();
        }
        return projNames;
    }

    public static Class getProjClassForName(String name) {
        if (name != null) {
            Iterator it = ProjectionFactory.getInstance().iterator();
            while (it.hasNext()) {
                ProjectionLoader loader = (ProjectionLoader)it.next();
                if (!name.equalsIgnoreCase(loader.getPrettyName())) continue;
                return loader.getProjectionClass();
            }
            try {
                return Class.forName(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public static int getProjType(String projName) {
        int projType = 2;
        if (projName != null) {
            if (projName.equalsIgnoreCase("Mercator")) {
                projType = 2;
            } else if (projName.equalsIgnoreCase("MercatorView")) {
                projType = 22;
            } else if (projName.equalsIgnoreCase("Orthographic")) {
                projType = 7;
            } else if (projName.equalsIgnoreCase("OrthographicView")) {
                projType = 77;
            } else if (projName.equalsIgnoreCase("LLXY")) {
                projType = 6304;
            } else if (projName.equalsIgnoreCase("EPSG-4326")) {
                projType = 6303;
            } else if (projName.equalsIgnoreCase("CADRG")) {
                projType = 42;
            } else if (projName.equalsIgnoreCase("Gnomonic")) {
                projType = 12;
            }
        }
        return projType;
    }

    public static Projection makeProjection(int newProjType, Projection p) {
        LatLonPoint ctr = p.getCenter();
        return ProjectionFactory.makeProjection(newProjType, ctr.getLatitude(), ctr.getLongitude(), p.getScale(), p.getWidth(), p.getHeight());
    }

    public static Projection makeProjection(int projType, float centerLat, float centerLon, float scale, int width, int height) {
        Class projClass = null;
        switch (projType) {
            case 42: {
                projClass = CADRG.class;
                break;
            }
            case 2: {
                projClass = Mercator.class;
                break;
            }
            case 22: {
                projClass = MercatorView.class;
                break;
            }
            case 6304: {
                projClass = LLXY.class;
                break;
            }
            case 6303: {
                projClass = LLXYView.class;
                break;
            }
            case 7: {
                projClass = Orthographic.class;
                break;
            }
            case 77: {
                projClass = OrthographicView.class;
                break;
            }
            case 12: {
                projClass = Gnomonic.class;
                break;
            }
            default: {
                System.err.println("Unknown projection type " + projType + " in ProjectionFactory.create()");
            }
        }
        return ProjectionFactory.makeProjection(projClass, centerLat, centerLon, scale, width, height);
    }

    public static Projection makeProjection(String projClassName, Projection p) {
        LatLonPoint ctr = p.getCenter();
        return ProjectionFactory.makeProjection(projClassName, ctr.getLatitude(), ctr.getLongitude(), p.getScale(), p.getWidth(), p.getHeight());
    }

    public static Projection makeProjection(String projClassName, float centerLat, float centerLon, float scale, int width, int height) {
        if (projClassName == null) {
            throw new ProjectionException("No projection class name specified");
        }
        try {
            return ProjectionFactory.makeProjection(Class.forName(projClassName), centerLat, centerLon, scale, width, height);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ProjectionException("Projection class " + projClassName + " not found");
        }
    }

    public static Projection makeProjection(Class projClass, float centerLat, float centerLon, float scale, int width, int height) {
        ProjectionFactory factory = ProjectionFactory.getInstance();
        ProjectionLoader loader = MercatorLoader.defaultMercator;
        Iterator it = factory.iterator();
        while (it.hasNext()) {
            ProjectionLoader pl = (ProjectionLoader)it.next();
            if (pl.getProjectionClass() != projClass) continue;
            loader = pl;
        }
        return factory.makeProjection(loader, centerLat, centerLon, scale, width, height);
    }

    public static Projection getDefaultProjectionFromEnvironment() {
        return ProjectionFactory.getDefaultProjectionFromEnvironment(0, 0);
    }

    public static Projection getDefaultProjectionFromEnvironment(int width, int height) {
        Projection proj = null;
        int w = width <= 0 ? Environment.getInteger("openmap.Width", 640) : width;
        int h = height <= 0 ? Environment.getInteger("openmap.Height", 480) : height;
        try {
            proj = ProjectionFactory.makeProjection(Environment.get("openmap.Projection"), Environment.getFloat("openmap.Latitude", 0.0f), Environment.getFloat("openmap.Longitude", 0.0f), Environment.getFloat("openmap.Scale", Float.POSITIVE_INFINITY), w, h);
        }
        catch (ProjectionException pe) {
            if (Debug.debugging("proj")) {
                Debug.output("ProjectionFactory.getDefaultProjectionFromEnvironment(): Can't use (openmap.Projection = " + Environment.get("openmap.Projection") + ") property as a projection class, need a class name instead.  Using default of com.bbn.openmap.proj.Mercator.");
            }
            proj = ProjectionFactory.makeProjection(Mercator.class, Environment.getFloat("openmap.Latitude", 0.0f), Environment.getFloat("openmap.Longitude", 0.0f), Environment.getFloat("openmap.Scale", Float.POSITIVE_INFINITY), w, h);
        }
        return proj;
    }

    public Projection makeProjection(ProjectionLoader loader, float centerLat, float centerLon, float scale, int width, int height) {
        return this.makeProjection(loader, centerLat, centerLon, scale, width, height, null);
    }

    public Projection makeProjection(ProjectionLoader loader, float centerLat, float centerLon, float scale, int width, int height, Properties projProps) {
        Projection proj = null;
        if (loader == null) {
            Debug.error("ProjectionFactory.makeProjection() not given a ProjectionLoader to use to create a Projection");
            return proj;
        }
        if (projProps == null) {
            projProps = new Properties();
        }
        projProps.put(CENTER, new LatLonPoint(centerLat, centerLon));
        projProps.put(SCALE, Float.toString(scale));
        projProps.put(WIDTH, Integer.toString(width));
        projProps.put(HEIGHT, Integer.toString(height));
        proj = loader.create(projProps);
        if (proj == null) {
            Debug.error("ProjectionFactory.makeProjection() tried to create a Projection from a " + loader.getPrettyName() + ", " + loader.getProjectionClass().getName() + ", failed.");
        }
        return proj;
    }

    public void addProjectionLoader(ProjectionLoader loader) {
        this.projLoaders.add(loader);
        this.fireLoadersChanged();
    }

    public boolean removeProjectionLoader(ProjectionLoader loader) {
        boolean removed = this.projLoaders.remove(loader);
        if (removed) {
            this.fireLoadersChanged();
        }
        return removed;
    }

    public void clearProjectionLoaders() {
        if (this.projLoaders.size() > 0) {
            this.projLoaders.clear();
            this.fireLoadersChanged();
        }
    }

    public Iterator iterator() {
        return this.projLoaders.iterator();
    }

    public int numProjections() {
        return this.projLoaders.size();
    }

    public Collection getProjectionLoaders() {
        return Collections.unmodifiableCollection(this.projLoaders);
    }

    protected void fireLoadersChanged() {
        this.pcs.firePropertyChange(AvailableProjectionProperty, null, this.projLoaders);
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        if (pcl != null) {
            this.pcs.addPropertyChangeListener(pcl);
            pcl.propertyChange(new PropertyChangeEvent(this, AvailableProjectionProperty, null, this.projLoaders));
        }
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener pcl) {
        if (pcl != null) {
            this.pcs.addPropertyChangeListener(propertyName, pcl);
            pcl.propertyChange(new PropertyChangeEvent(this, AvailableProjectionProperty, null, this.projLoaders));
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(propertyName, pcl);
    }

    public void findAndInit(Object obj) {
        if (obj instanceof ProjectionLoader) {
            this.addProjectionLoader((ProjectionLoader)obj);
        }
    }

    public void findAndUndo(Object obj) {
        if (obj instanceof ProjectionLoader) {
            this.removeProjectionLoader((ProjectionLoader)obj);
        }
    }

    public static ProjectionFactory loadDefaultProjections() {
        return ProjectionFactory.loadDefaultProjections(ProjectionFactory.getInstance());
    }

    public static ProjectionFactory loadDefaultProjections(ProjectionFactory pf) {
        if (pf != null && pf.numProjections() == 0) {
            pf.addProjectionLoader(new MercatorLoader());
            pf.addProjectionLoader(new OrthographicLoader());
            pf.addProjectionLoader(new CADRGLoader());
            pf.addProjectionLoader(new LLXYLoader());
            pf.addProjectionLoader(new GnomonicLoader());
        }
        return pf;
    }
}

