/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.proj.BasicProjectionLoader;
import com.bbn.openmap.proj.Gnomonic;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.ProjectionException;
import com.bbn.openmap.proj.ProjectionLoader;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.util.Properties;

public class GnomonicLoader
extends BasicProjectionLoader
implements ProjectionLoader {
    public GnomonicLoader() {
        super(Gnomonic.class, "Gnomonic", "Gnomonic projection.");
    }

    public Projection create(Properties props) throws ProjectionException {
        try {
            LatLonPoint llp = (LatLonPoint)props.get("CENTER");
            float scale = PropUtils.floatFromProperties(props, "SCALE", 1.0E7f);
            int height = PropUtils.intFromProperties(props, "HEIGHT", 100);
            int width = PropUtils.intFromProperties(props, "WIDTH", 100);
            return new Gnomonic(llp, scale, width, height);
        }
        catch (Exception e) {
            if (Debug.debugging("proj")) {
                Debug.output("GnomonicLoader: problem creating Gnomonic projection " + e.getMessage());
            }
            throw new ProjectionException("GnomonicLoader: problem creating Gnomonic projection");
        }
    }
}

