/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.proj.ProjMath;

public class Clip {
    private Clip() {
    }

    public static final int liang_get_buflen(int nverts) {
        return (nverts << 2) + 3;
    }

    public static final int[] liang_clip(int xleft, int xright, int ytop, int ybottom, int[] x, int[] y, int n, int[] ret_val) {
        int num = 0;
        for (int i = 0; i < n; ++i) {
            double tout1;
            double toutx;
            double tin2;
            double tin1;
            double tiny;
            double yout;
            double yin;
            double xout;
            double xin;
            double dx = x[i + 1] - x[i];
            double dy = y[i + 1] - y[i];
            if (dx > 0.0 || dx == 0.0 && x[i] > xright) {
                xin = xleft;
                xout = xright;
            } else {
                xin = xright;
                xout = xleft;
            }
            if (dy > 0.0 || dy == 0.0 && y[i] > ytop) {
                yin = ybottom;
                yout = ytop;
            } else {
                yin = ytop;
                yout = ybottom;
            }
            double tinx = dx != 0.0 ? (xin - (double)x[i]) / dx : Double.NEGATIVE_INFINITY;
            double d = tiny = dy != 0.0 ? (yin - (double)y[i]) / dy : Double.NEGATIVE_INFINITY;
            if (tinx < tiny) {
                tin1 = tinx;
                tin2 = tiny;
            } else {
                tin1 = tiny;
                tin2 = tinx;
            }
            if (!(tin1 <= 1.0)) continue;
            if (tin1 > 0.0) {
                ret_val[num++] = (int)ProjMath.qint(xin);
                ret_val[num++] = (int)ProjMath.qint(yin);
            }
            if (!(tin2 <= 1.0)) continue;
            if (dx != 0.0) {
                toutx = (xout - (double)x[i]) / dx;
            } else {
                double d2 = toutx = xleft <= x[i] && x[i] <= xright ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
            }
            double touty = dy != 0.0 ? (yout - (double)y[i]) / dy : (ybottom <= y[i] && y[i] <= ytop ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY);
            double d3 = tout1 = toutx < touty ? toutx : touty;
            if (!(tin2 > 0.0) && !(tout1 > 0.0)) continue;
            if (tin2 <= tout1) {
                if (tin2 > 0.0) {
                    if (tinx > tiny) {
                        ret_val[num++] = (int)ProjMath.qint(xin);
                        ret_val[num++] = (int)ProjMath.qint((double)y[i] + tinx * dy);
                    } else {
                        ret_val[num++] = (int)ProjMath.qint((double)x[i] + tiny * dx);
                        ret_val[num++] = (int)ProjMath.qint(yin);
                    }
                }
                if (tout1 < 1.0) {
                    if (toutx < touty) {
                        ret_val[num++] = (int)ProjMath.qint(xout);
                        ret_val[num++] = (int)ProjMath.qint((double)y[i] + toutx * dy);
                        continue;
                    }
                    ret_val[num++] = (int)ProjMath.qint((double)x[i] + touty * dx);
                    ret_val[num++] = (int)ProjMath.qint(yout);
                    continue;
                }
                ret_val[num++] = x[i + 1];
                ret_val[num++] = y[i + 1];
                continue;
            }
            if (tinx > tiny) {
                ret_val[num++] = (int)ProjMath.qint(xin);
                ret_val[num++] = (int)ProjMath.qint(yout);
                continue;
            }
            ret_val[num++] = (int)ProjMath.qint(xout);
            ret_val[num++] = (int)ProjMath.qint(yin);
        }
        if (num != 0) {
            ret_val[num++] = ret_val[0];
            ret_val[num++] = ret_val[1];
            ret_val[ret_val.length - 1] = num;
        } else {
            ret_val[ret_val.length - 1] = num;
        }
        return ret_val;
    }

    private static final int _quick_code(int x, int y, int xleft, int xright, int ytop, int ybottom) {
        int val = 0;
        if (x < xleft) {
            val = 1;
        } else if (x > xright) {
            val = 2;
        }
        if (y < ytop) {
            val |= 8;
        } else if (y > ybottom) {
            val |= 4;
        }
        return val;
    }

    public static final int quickCheckLineClip(int x1, int y1, int x2, int y2, int xleft, int xright, int ytop, int ybottom) {
        int pt2;
        int pt1 = Clip._quick_code(x1, y1, xleft, xright, ytop, ybottom);
        if ((pt1 & (pt2 = Clip._quick_code(x2, y2, xleft, xright, ytop, ybottom))) != 0) {
            return -1;
        }
        if ((pt1 | pt2) == 0) {
            return 1;
        }
        return 0;
    }

    static final class Values {
        static final char LEFT = '\u0001';
        static final char RIGHT = '\u0002';
        static final char BOTTOM = '\u0004';
        static final char TOP = '\b';

        Values() {
        }
    }
}

