/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.plugin.esri;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.Layer;
import com.bbn.openmap.LayerHandler;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.MouseDelegator;
import com.bbn.openmap.dataAccess.shape.DbfTableModel;
import com.bbn.openmap.dataAccess.shape.EsriGraphicList;
import com.bbn.openmap.event.NavMouseMode;
import com.bbn.openmap.event.SelectMouseMode;
import com.bbn.openmap.gui.OMToolSet;
import com.bbn.openmap.gui.ToolPanel;
import com.bbn.openmap.layer.GraticuleLayer;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.plugin.esri.EsriLayer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ExampleApplet
extends JApplet {
    private MapBean _mapBean = new MapBean();
    private Layer[] _layers = null;
    private LayerHandler _layerHandler = null;
    private OMToolSet _omts = null;
    private ToolPanel _toolPanel = new ToolPanel();
    private MouseDelegator _mouseDelegator = null;
    private JButton _cmdAddLayers = null;
    private JButton _cmdShowTable = null;
    private JCheckBox _runningLocally = null;

    public ExampleApplet() {
        this._omts = new OMToolSet();
        this._omts.findAndInit(this._mapBean);
        this._mouseDelegator = new MouseDelegator(this._mapBean);
        NavMouseMode nmm = new NavMouseMode();
        SelectMouseMode smm = new SelectMouseMode();
        this._mouseDelegator.addMouseMode(nmm);
        this._mouseDelegator.addMouseMode(smm);
        this.setupUI();
    }

    private EsriLayer pickEsriLayer() {
        Layer[] layers = this._layerHandler.getLayers();
        Vector<String> vector = new Vector<String>();
        for (int n = 0; n <= layers.length - 1; ++n) {
            String name = layers[n].getName();
            vector.add(name);
        }
        Object[] objects = vector.toArray();
        String selectedValue = (String)JOptionPane.showInputDialog(null, "Choose one", "Input", 1, null, objects, objects[0]);
        for (int n = 0; n <= layers.length - 1; ++n) {
            String name = layers[n].getName();
            if (!name.equalsIgnoreCase(selectedValue)) continue;
            return (EsriLayer)layers[n];
        }
        return null;
    }

    public void setupUI() {
        this._runningLocally = new JCheckBox("Running Locally");
        this.getContentPane().setLayout(new BorderLayout());
        this.setSize(640, 480);
        this._mapBean.setCenter(new LatLonPoint(43.0f, -95.0f));
        this._mapBean.setScale(1.2E8f);
        this._layers = new Layer[1];
        this._toolPanel = new ToolPanel();
        Properties props = new Properties();
        props.put("prettyName", "Graticule");
        props.put("showRuler", "true");
        props.put("show1And5Lines", "true");
        props.put("threshold", "2");
        props.put("10DegreeColor", "FF000000");
        props.put("5DegreeColor", "FF009900");
        props.put("1DegreeColor", "FF003300");
        props.put("equatorColor", "FFFF0000");
        props.put("dateLineColor", "FF000099");
        props.put("specialLineColor", "FF000000");
        props.put("textColor", "FF000000");
        GraticuleLayer graticule = new GraticuleLayer();
        graticule.setProperties(props);
        this._layers[0] = graticule;
        this._layerHandler = new LayerHandler(this._layers);
        this._layerHandler.addLayerListener(this._mapBean);
        this._cmdAddLayers = new JButton("Add Layers");
        this._cmdAddLayers.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    EsriLayer rivers = null;
                    EsriLayer cities = null;
                    EsriLayer states = null;
                    URL dbf = null;
                    URL shx = null;
                    URL shp = null;
                    if (ExampleApplet.this._runningLocally.isSelected()) {
                        dbf = new URL("file://localhost/c:/data/rivers.dbf");
                        shp = new URL("file://localhost/c:/data/rivers.shp");
                        shx = new URL("file://localhost/c:/data/rivers.shx");
                        rivers = new EsriLayer("Southwest", dbf, shp, shx);
                        dbf = new URL("file://localhost/c:/data/cities.dbf");
                        shp = new URL("file://localhost/c:/data/cities.shp");
                        shx = new URL("file://localhost/c:/data/cities.shx");
                        cities = new EsriLayer("Cities", dbf, shp, shx);
                        dbf = new URL("file://localhost/c:/data/states.dbf");
                        shp = new URL("file://localhost/c:/data/states.shp");
                        shx = new URL("file://localhost/c:/data/states.shx");
                        states = new EsriLayer("States", dbf, shp, shx);
                    } else {
                        dbf = new URL(ExampleApplet.this.getCodeBase(), "resources/rivers.dbf");
                        shp = new URL(ExampleApplet.this.getCodeBase(), "resources/rivers.shp");
                        shx = new URL(ExampleApplet.this.getCodeBase(), "resources/rivers.shx");
                        rivers = new EsriLayer("Rivers", dbf, shp, shx);
                        dbf = new URL(ExampleApplet.this.getCodeBase(), "resources/cities.dbf");
                        shp = new URL(ExampleApplet.this.getCodeBase(), "resources/cities.shp");
                        shx = new URL(ExampleApplet.this.getCodeBase(), "resources/cities.shx");
                        cities = new EsriLayer("Cities", dbf, shp, shx);
                        dbf = new URL(ExampleApplet.this.getCodeBase(), "resources/states.dbf");
                        shp = new URL(ExampleApplet.this.getCodeBase(), "resources/states.shp");
                        shx = new URL(ExampleApplet.this.getCodeBase(), "resources/states.shx");
                        states = new EsriLayer("States", dbf, shp, shx);
                    }
                    ExampleApplet.this._layerHandler.addLayer(rivers);
                    ExampleApplet.this._layerHandler.addLayer(cities);
                    ExampleApplet.this._layerHandler.addLayer(states);
                    ExampleApplet.this._cmdAddLayers.setEnabled(false);
                    ExampleApplet.this._cmdShowTable.setEnabled(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this._cmdShowTable = new JButton("View Table");
        this._cmdShowTable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                Layer[] layers = ExampleApplet.this._layerHandler.getMapLayers();
                if (layers.length >= 4) {
                    EsriLayer layer = ExampleApplet.this.pickEsriLayer();
                    ExampleApplet.this.showTable(layer);
                    ExampleApplet.this._cmdAddLayers.setEnabled(false);
                }
            }
        });
        this._toolPanel.add(this._runningLocally);
        this._toolPanel.add((Component)this._cmdAddLayers, 0);
        this._toolPanel.add((Component)this._cmdShowTable, 1);
        this._toolPanel.add(this._omts);
        this.getContentPane().add((Component)this._toolPanel, "North");
        this.getContentPane().add((Component)this._mapBean, "Center");
        this.setVisible(true);
    }

    public void showTable(final EsriLayer layer) {
        JFrame frame = new JFrame("Table");
        DbfTableModel model = layer.getModel();
        JTable table = new JTable(model);
        JScrollPane pane = new JScrollPane(table);
        frame.getContentPane().add((Component)pane, "Center");
        ListSelectionModel lsm = table.getSelectionModel();
        lsm.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm2 = (ListSelectionModel)e.getSource();
                if (!lsm2.isSelectionEmpty()) {
                    int index = lsm2.getMinSelectionIndex();
                    EsriGraphicList list = layer.getEsriGraphicList();
                    OMGraphic graphic = list.getOMGraphicAt(index);
                    graphic.select();
                    list.generate(ExampleApplet.this._mapBean.getProjection());
                    layer.repaint();
                }
            }
        });
        frame.setSize(400, 300);
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        ExampleApplet example = new ExampleApplet();
        JFrame frame = new JFrame();
        frame.getContentPane().add(example);
        frame.setSize(800, 600);
        frame.setVisible(true);
    }
}

