/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.plugin.esri;

import com.bbn.openmap.dataAccess.shape.DbfTableModel;
import com.bbn.openmap.dataAccess.shape.EsriGraphicList;
import com.bbn.openmap.dataAccess.shape.EsriPointList;
import com.bbn.openmap.dataAccess.shape.EsriPolygonList;
import com.bbn.openmap.dataAccess.shape.EsriPolylineList;
import com.bbn.openmap.dataAccess.shape.ShapeConstants;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;

public class EsriLayer
extends OMGraphicHandlerLayer
implements ShapeConstants {
    protected DbfTableModel _model = null;
    protected String dbf;
    protected String shx;
    protected String shp;
    protected DrawingAttributes drawingAttributes = DrawingAttributes.getDefaultClone();

    public EsriLayer() {
    }

    public EsriLayer(String name, int type, int columnCount) throws Exception {
        this.setName(name);
        switch (type) {
            case 1: {
                this.setList(new EsriPointList());
                break;
            }
            case 5: {
                this.setList(new EsriPolygonList());
                break;
            }
            case 3: {
                this.setList(new EsriPolylineList());
                break;
            }
        }
        this._model = new DbfTableModel(columnCount);
    }

    public EsriLayer(String name, String dbf, String shp, String shx, DrawingAttributes da) throws MalformedURLException {
        this(name, PropUtils.getResourceOrFileOrURL(dbf), PropUtils.getResourceOrFileOrURL(shp), PropUtils.getResourceOrFileOrURL(shx), da);
    }

    public EsriLayer(String name, URL dbf, URL shp, URL shx) {
        this(name, dbf, shp, shx, DrawingAttributes.getDefaultClone());
    }

    public EsriLayer(String name, URL dbf, URL shp, URL shx, DrawingAttributes da) {
        this.setName(name);
        this.drawingAttributes = da;
        this.setModel(DbfTableModel.getDbfTableModel(dbf));
        this.setList(EsriGraphicList.getEsriGraphicList(shp, this.drawingAttributes, this.getModel()));
    }

    public void addRecord(OMGraphic graphic, ArrayList record) {
        OMGraphicList _list = this.getList();
        graphic.putAttribute("SHAPE_DBF_INFO_ATTRIBUTE", record);
        if (_list != null) {
            _list.add(graphic);
        }
        if (this._model != null) {
            this._model.addRecord(record);
        }
    }

    public EsriGraphicList getEsriGraphicList() {
        return (EsriGraphicList)this.getList();
    }

    public DbfTableModel getModel() {
        return this._model;
    }

    public int getType() {
        EsriGraphicList egl = this.getEsriGraphicList();
        if (egl != null) {
            return egl.getType();
        }
        return -1;
    }

    public void query(String query) {
    }

    public void setModel(DbfTableModel model) {
        this._model = model;
    }

    public void setProperties(String prefix, Properties properties) {
        super.setProperties(prefix, properties);
        this.drawingAttributes.setProperties(prefix, properties);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.shp = properties.getProperty(prefix + "shp");
        this.shx = properties.getProperty(prefix + "shx");
        this.dbf = properties.getProperty(prefix + "dbf");
        if (this.shp != null) {
            if (this.shx == null || this.shx.equals("")) {
                this.shx = this.shp.substring(0, this.shp.lastIndexOf(46) + 1) + "shx";
            }
            if (this.dbf == null || this.dbf.equals("")) {
                this.dbf = this.shp.substring(0, this.shp.lastIndexOf(46) + 1) + "dbf";
            }
            try {
                this.setModel(DbfTableModel.getDbfTableModel(PropUtils.getResourceOrFileOrURL(this.dbf)));
                this.setList(EsriGraphicList.getEsriGraphicList(PropUtils.getResourceOrFileOrURL(this.shp), this.drawingAttributes, this.getModel()));
            }
            catch (Exception exception) {
                Debug.error("EsriLayer(" + this.getName() + ") exception reading Shape files:\n " + exception.getMessage());
            }
        }
    }

    public Properties getProperties(Properties properties) {
        properties = super.getProperties(properties);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        properties.setProperty(prefix + "dbf", PropUtils.unnull(this.dbf));
        properties.setProperty(prefix + "shx", PropUtils.unnull(this.shx));
        properties.setProperty(prefix + "shp", PropUtils.unnull(this.shp));
        this.drawingAttributes.setPropertyPrefix(this.getPropertyPrefix());
        this.drawingAttributes.getProperties(properties);
        return properties;
    }

    public Properties getPropertyInfo(Properties list) {
        list = super.getPropertyInfo(list);
        list.put("dbf", "Location URL of the dbf file.");
        list.put("dbf.editor", "com.bbn.openmap.util.propertyEditor.FUPropertyEditor");
        list.put("shx", "Location URL of the shx file.");
        list.put("shx.editor", "com.bbn.openmap.util.propertyEditor.FUPropertyEditor");
        list.put("shp", "Location URL of the shp file.");
        list.put("shp.editor", "com.bbn.openmap.util.propertyEditor.FUPropertyEditor");
        this.drawingAttributes.getPropertyInfo(list);
        list.put("initProperties", "shp shx dbf " + this.drawingAttributes.getInitPropertiesOrder());
        return list;
    }
}

