/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.grid;

import com.bbn.openmap.omGraphics.OMColor;
import com.bbn.openmap.omGraphics.grid.ElevationColors;
import com.bbn.openmap.proj.Length;
import java.awt.Color;

public class ColoredShadingColors
implements ElevationColors {
    protected ColorHelper[] colors;
    public Color waterColor = OMColor.clear;
    public final int[] DEFAULT_COLOR_CUTOFFS = new int[]{0, 50, 100, 200, 400, 800, 1200, 1600, 2000, 3000, 4000, 6000, 8000, 10000, 12000, 33000};
    public final int[] DEFAULT_COLORS = new int[]{12578810, -15442106, -14129584, -12812188, -9528958, -7557226, -4274026, -1980261, -5005747, -6320589, -6055885, -5069491, -4610704, -2634356, -2500135, -789530};
    protected int slopeColorAdjustment = 657930;

    public ColoredShadingColors() {
        this.getColors();
    }

    public ColoredShadingColors(ColorHelper[] colors) {
        this.colors = colors;
    }

    public void setSlopeColorAdjustment(int adj) {
        this.slopeColorAdjustment = adj;
    }

    public int getSlopeColorAdjustment() {
        return this.slopeColorAdjustment;
    }

    public ColorHelper[] getColors() {
        if (this.colors == null) {
            this.colors = this.createDefaultColors();
        }
        return this.colors;
    }

    public void setColors(ColorHelper[] clrs) {
        this.colors = clrs;
    }

    public int[] getColortable() {
        ColorHelper[] helpers = this.getColors();
        int[] cs = new int[helpers.length];
        for (int i = 0; i < helpers.length; ++i) {
            cs[i] = helpers[i].value;
        }
        return cs;
    }

    public void setWaterColor(Color water) {
        this.waterColor = water;
    }

    public Color getWaterColor() {
        return this.waterColor;
    }

    public Color getColor(int elevation, Length units, double slope) {
        return new Color(this.getARGB(elevation, units, slope));
    }

    public int getARGB(int elevation, Length units, double slope) {
        if (elevation < 0) {
            return this.waterColor.getRGB();
        }
        float elev = units.toRadians(elevation);
        float numCutoffs = this.colors.length;
        int i = 0;
        while (this.colors != null && (float)i < numCutoffs && this.colors[i] != null && this.colors[i].height < (double)elev) {
            ++i;
        }
        int value = this.colors[i].value;
        if (slope < 0.0) {
            value -= 2 * this.slopeColorAdjustment;
        } else if (slope == 0.0) {
            value -= this.slopeColorAdjustment;
        }
        return value;
    }

    public ColorHelper[] createDefaultColors() {
        int number = this.DEFAULT_COLOR_CUTOFFS.length;
        ColorHelper[] helpers = new ColorHelper[number];
        for (int i = 0; i < number; ++i) {
            helpers[i] = new ColorHelper(Length.FEET.toRadians(this.DEFAULT_COLOR_CUTOFFS[i]), this.DEFAULT_COLORS[i]);
        }
        return helpers;
    }

    public static class ColorHelper {
        public double height = 0.0;
        public int value = 0;

        public ColorHelper(double radianHeight, int val) {
            this.height = radianHeight;
            this.value = val;
        }
    }
}

