/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.geom;

import com.bbn.openmap.omGraphics.OMGeometry;
import com.bbn.openmap.omGraphics.geom.PolygonGeometry;
import com.bbn.openmap.proj.DrawUtil;
import java.io.Serializable;

public abstract class PolylineGeometry
extends PolygonGeometry
implements Serializable,
OMGeometry {
    public float distance(int x, int y) {
        if (this.shape != null) {
            return super.distance(x, y);
        }
        float distance = Float.POSITIVE_INFINITY;
        if (this.getNeedToRegenerate()) {
            return distance;
        }
        int[][] xpts = this.xpoints;
        int[][] ypts = this.ypoints;
        int len = xpts.length;
        for (int i = 0; i < len; ++i) {
            int[] _x = xpts[i];
            int[] _y = ypts[i];
            float temp = DrawUtil.closestPolyDistance(_x, _y, x, y, false);
            if (!(temp < distance)) continue;
            distance = temp;
        }
        return distance;
    }

    public static class Offset
    extends PolygonGeometry.Offset {
        public Offset(float latPoint, float lonPoint, int[] xypoints, int cMode) {
            super(latPoint, lonPoint, xypoints, cMode);
            this.setIsPolygon(false);
        }

        public Offset(float latPoint, float lonPoint, int[] xPoints, int[] yPoints, int cMode) {
            super(latPoint, lonPoint, xPoints, yPoints, cMode);
            this.setIsPolygon(false);
        }
    }

    public static class XY
    extends PolygonGeometry.XY {
        public XY(int[] xypoints) {
            super(xypoints);
            this.setIsPolygon(false);
        }

        public XY(int[] xPoints, int[] yPoints) {
            super(xPoints, yPoints);
            this.setIsPolygon(false);
        }
    }

    public static class LL
    extends PolygonGeometry.LL {
        public LL(float[] llPoints, int units, int lType) {
            this(llPoints, units, lType, -1);
        }

        public LL(float[] llPoints, int units, int lType, int nsegs) {
            super(llPoints, units, lType, nsegs);
            this.setIsPolygon(false);
        }
    }
}

