/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Point;
import java.awt.geom.GeneralPath;
import java.io.Serializable;
import java.util.ArrayList;

public class OMRect
extends OMGraphic
implements Serializable {
    protected int x1 = 0;
    protected int y1 = 0;
    protected float lat1 = 0.0f;
    protected float lon1 = 0.0f;
    protected int x2 = 0;
    protected int y2 = 0;
    protected float lat2 = 0.0f;
    protected float lon2 = 0.0f;
    protected int nsegs = -1;

    public OMRect() {
        super(0, 0, 0);
    }

    public OMRect(float lt1, float ln1, float lt2, float ln2, int lType) {
        this(lt1, ln1, lt2, ln2, lType, -1);
    }

    public OMRect(float lt1, float ln1, float lt2, float ln2, int lType, int nsegs) {
        super(1, lType, 0);
        this.lat1 = lt1;
        this.lon1 = ln1;
        this.lat2 = lt2;
        this.lon2 = ln2;
        this.nsegs = nsegs;
    }

    public OMRect(int px1, int py1, int px2, int py2) {
        super(2, 0, 0);
        this.x1 = px1;
        this.y1 = py1;
        this.x2 = px2;
        this.y2 = py2;
    }

    public OMRect(float lt1, float ln1, int px1, int py1, int px2, int py2) {
        super(3, 0, 0);
        this.lat1 = lt1;
        this.lon1 = ln1;
        this.x1 = px1;
        this.y1 = py1;
        this.x2 = px2;
        this.y2 = py2;
    }

    public void setLocation(float lt1, float ln1, float lt2, float ln2, int lType) {
        this.setRenderType(1);
        this.setLineType(lType);
        this.lat1 = lt1;
        this.lon1 = ln1;
        this.lat2 = lt2;
        this.lon2 = ln2;
        this.setNeedToRegenerate(true);
    }

    public void setLocation(int px1, int py1, int px2, int py2) {
        this.setRenderType(2);
        this.setLineType(0);
        this.x1 = Math.min(px1, px2);
        this.y1 = Math.min(py1, py2);
        this.x2 = Math.max(px1, px2);
        this.y2 = Math.max(py1, py2);
        this.setNeedToRegenerate(true);
    }

    public void setLocation(float lt1, float ln1, int px1, int py1, int px2, int py2) {
        this.setRenderType(3);
        this.setLineType(0);
        this.lat1 = lt1;
        this.lon1 = ln1;
        this.x1 = px1;
        this.y1 = py1;
        this.x2 = px2;
        this.y2 = py2;
        this.setNeedToRegenerate(true);
    }

    public float getNorthLat() {
        return this.lat1;
    }

    public float getWestLon() {
        return this.lon1;
    }

    public float getSouthLat() {
        return this.lat2;
    }

    public float getEastLon() {
        return this.lon2;
    }

    public int getTop() {
        return this.y1;
    }

    public int getLeft() {
        return this.x1;
    }

    public int getBottom() {
        return this.y2;
    }

    public int getRight() {
        return this.x2;
    }

    public void setNumSegs(int nsegs) {
        this.nsegs = nsegs;
    }

    public int getNumSegs() {
        return this.nsegs;
    }

    public boolean generate(Projection proj) {
        this.setShape(null);
        if (proj == null) {
            Debug.message("omgraphic", "OMRect: null projection in generate!");
            return false;
        }
        switch (this.renderType) {
            case 2: {
                this.setShape(OMRect.createBoxShape(Math.min(this.x2, this.x1), Math.min(this.y2, this.y1), Math.abs(this.x2 - this.x1), Math.abs(this.y2 - this.y1)));
                break;
            }
            case 3: {
                if (!proj.isPlotable(this.lat1, this.lon1)) {
                    this.setNeedToRegenerate(true);
                    return false;
                }
                Point p1 = proj.forward(this.lat1, this.lon1);
                this.setShape(OMRect.createBoxShape(Math.min(p1.x + this.x1, p1.x + this.x2), Math.min(p1.y + this.y1, p1.y + this.y2), Math.abs(this.x2 - this.x1), Math.abs(this.y2 - this.y1)));
                break;
            }
            case 1: {
                ArrayList rects = proj.forwardRect(new LatLonPoint(this.lat1, this.lon1), new LatLonPoint(this.lat2, this.lon2), this.lineType, this.nsegs, !OMRect.isClear(this.fillPaint));
                int size = rects.size();
                int i = 0;
                int j = 0;
                while (i < size) {
                    GeneralPath gp = OMRect.createShape((int[])rects.get(i), (int[])rects.get(i + 1), true);
                    if (this.shape == null) {
                        this.setShape(gp);
                    } else {
                        this.shape.append(gp, false);
                    }
                    i += 2;
                    ++j;
                }
                break;
            }
            case 0: {
                System.err.println("OMRect.generate(): invalid RenderType");
                return false;
            }
        }
        this.setNeedToRegenerate(false);
        return true;
    }
}

