/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.OMGeometry;
import com.bbn.openmap.omGraphics.OMGraphicConstants;
import com.bbn.openmap.omGraphics.OMLabeler;
import com.bbn.openmap.omGraphics.OMRasterObject;
import com.bbn.openmap.omGraphics.SinkGraphic;
import com.bbn.openmap.omGraphics.geom.BasicGeometry;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public abstract class OMGraphic
extends BasicGeometry
implements OMGeometry,
OMGraphicConstants,
Cloneable,
Serializable {
    protected transient Stroke stroke = BASIC_STROKE;
    protected Paint linePaint = Color.black;
    protected Paint mattingPaint = Color.black;
    protected Paint displayPaint = this.linePaint;
    protected Paint fillPaint = clear;
    protected TexturePaint textureMask = null;
    protected Paint selectPaint = Color.black;
    protected boolean selected = false;
    protected boolean showEditablePalette = true;
    protected boolean edgeMatchesFill = false;
    protected int renderType = 0;
    protected int declutterType = 0;
    protected boolean matted = false;
    protected transient boolean hasLabel = false;

    public static boolean isClear(Paint paint) {
        if (paint instanceof Color) {
            return (((Color)paint).getRGB() & 0xFF000000) == 0;
        }
        return false;
    }

    protected OMGraphic() {
    }

    protected OMGraphic(int rType, int lType, int dcType) {
        this.setRenderType(rType);
        this.setLineType(lType);
        this.setDeclutterType(dcType);
    }

    public OMGraphic(int rType, int lType, int dcType, Color lc, Color fc, Color sc) {
        this(rType, lType, dcType);
        this.setLinePaint(lc);
        this.setSelectPaint(sc);
        this.setFillPaint(fc);
    }

    public void setRenderType(int value) {
        if (this.renderType == value) {
            return;
        }
        this.setNeedToRegenerate(true);
        this.renderType = value;
    }

    public int getRenderType() {
        return this.renderType;
    }

    public String getDescription(int level) {
        if (level == 0) {
            return this.getDescription();
        }
        return "|--> " + this.getDescription();
    }

    public String getDescription() {
        String cname = this.getClass().getName();
        int lastPeriod = cname.lastIndexOf(46);
        if (lastPeriod != -1) {
            cname = cname.substring(lastPeriod + 1);
        }
        return cname;
    }

    public void setDeclutterType(int value) {
        if (this.declutterType == value) {
            return;
        }
        this.setNeedToRegenerate(true);
        this.declutterType = value;
    }

    public int getDeclutterType() {
        return this.declutterType;
    }

    public void setGraphicsForEdge(Graphics g) {
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setStroke(this.getStroke());
        }
        this.setGraphicsColor(g, this.getDisplayPaint());
    }

    public void setGraphicsForFill(Graphics g) {
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setStroke(BASIC_STROKE);
        }
        this.setGraphicsColor(g, this.getFillPaint());
    }

    public void setGraphicsColor(Graphics g, Paint paint) {
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setPaint(paint);
        } else if (paint instanceof Color) {
            g.setColor((Color)paint);
        }
    }

    public void setLineColor(Color value) {
        this.setLinePaint(value);
    }

    public Color getLineColor() {
        if (this.linePaint instanceof Color) {
            return (Color)this.linePaint;
        }
        return null;
    }

    public void setLinePaint(Paint paint) {
        this.linePaint = paint != null ? paint : Color.black;
        if (!this.selected) {
            this.displayPaint = this.linePaint;
        }
        this.setEdgeMatchesFill();
    }

    public Paint getLinePaint() {
        return this.linePaint;
    }

    public void setSelectColor(Color value) {
        this.setSelectPaint(value);
    }

    public Color getSelectColor() {
        if (this.selectPaint instanceof Color) {
            return (Color)this.selectPaint;
        }
        return null;
    }

    public void setSelectPaint(Paint paint) {
        this.selectPaint = paint != null ? paint : Color.black;
        if (this.selected) {
            this.displayPaint = this.selectPaint;
        }
        this.setEdgeMatchesFill();
    }

    public Paint getSelectPaint() {
        return this.selectPaint;
    }

    public Color getDisplayColor() {
        if (this.displayPaint instanceof Color) {
            return (Color)this.displayPaint;
        }
        return null;
    }

    public Paint getDisplayPaint() {
        return this.displayPaint;
    }

    public void select() {
        this.selected = true;
        this.displayPaint = this.getSelectPaint();
        this.setEdgeMatchesFill();
    }

    public void deselect() {
        this.selected = false;
        this.displayPaint = this.getLinePaint();
        this.setEdgeMatchesFill();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean set) {
        if (set) {
            this.select();
        } else {
            this.deselect();
        }
    }

    public boolean isMatted() {
        return this.matted;
    }

    public void setMatted(boolean set) {
        this.matted = set;
    }

    public void setFillColor(Color value) {
        this.setFillPaint(value);
    }

    public Color getFillColor() {
        if (this.fillPaint instanceof Color) {
            return (Color)this.fillPaint;
        }
        return null;
    }

    public void setFillPaint(Paint paint) {
        if (paint != null) {
            this.fillPaint = paint;
            if (Debug.debugging("omGraphics")) {
                Debug.output("OMGraphic.setFillPaint(): fillPaint= " + this.fillPaint);
            }
        } else {
            this.fillPaint = clear;
            if (Debug.debugging("omGraphics")) {
                Debug.output("OMGraphic.setFillPaint(): fillPaint is clear");
            }
        }
        this.setEdgeMatchesFill();
    }

    public void setTextureMask(TexturePaint texture) {
        this.textureMask = texture;
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public TexturePaint getTextureMask() {
        return this.textureMask;
    }

    protected void setEdgeMatchesFill() {
        Paint paint = this.getDisplayPaint();
        this.edgeMatchesFill = this.fillPaint instanceof Color && paint instanceof Color && !OMGraphic.isClear(this.fillPaint) ? ((Color)this.fillPaint).equals((Color)paint) : false;
    }

    public boolean getEdgeMatchesFill() {
        return this.edgeMatchesFill;
    }

    public void setMattingPaint(Paint mPaint) {
        this.mattingPaint = mPaint;
    }

    public Paint getMattingPaint() {
        return this.mattingPaint;
    }

    public void setStroke(Stroke s) {
        this.stroke = s != null ? s : BASIC_STROKE;
    }

    public Stroke getStroke() {
        if (this.stroke == null) {
            this.stroke = BASIC_STROKE;
        }
        return this.stroke;
    }

    public void setShowEditablePalette(boolean set) {
        this.showEditablePalette = set;
    }

    public boolean getShowEditablePalette() {
        return this.showEditablePalette;
    }

    public float normalizeDistanceForLineWidth(float distance) {
        float lineWidth = 1.0f;
        if (this.stroke instanceof BasicStroke) {
            lineWidth = ((BasicStroke)this.stroke).getLineWidth();
        }
        if (lineWidth > 1.0f && (distance -= lineWidth / 2.0f) < 0.0f) {
            distance = 0.0f;
        }
        return distance;
    }

    public abstract boolean generate(Projection var1);

    public void render(Graphics g) {
        if (this.matted && g instanceof Graphics2D && this.stroke instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)this.stroke;
            ((Graphics2D)g).setStroke(new BasicStroke(bs.getLineWidth() + 2.0f, bs.getEndCap(), bs.getLineJoin()));
            this.setGraphicsColor(g, this.mattingPaint);
            this.draw(g);
        }
        if (this.shouldRenderFill()) {
            this.setGraphicsForFill(g);
            this.fill(g);
            if (this.textureMask != null && this.textureMask != this.fillPaint) {
                this.setGraphicsColor(g, this.textureMask);
                this.fill(g);
            }
        }
        if (this.shouldRenderEdge()) {
            this.setGraphicsForEdge(g);
            this.draw(g);
        }
        this.renderLabel(g);
    }

    public void setShape(GeneralPath gp) {
        OMLabeler labeler;
        super.setShape(gp);
        this.hasLabel = false;
        if (gp != null && (labeler = (OMLabeler)this.getAttribute("Label")) != null) {
            labeler.setLocation(gp);
            this.hasLabel = true;
        }
    }

    protected void setHasLabel(boolean val) {
        this.hasLabel = val;
    }

    public boolean getHasLabel() {
        return this.hasLabel;
    }

    protected void initLabelingDuringGenerate() {
        this.setHasLabel(this.getAttribute("Label") != null);
    }

    public void setLabelLocation(int[] xpoints, int[] ypoints) {
        OMLabeler oml;
        if (this.hasLabel && (oml = (OMLabeler)this.getAttribute("Label")) != null) {
            oml.setLocation(xpoints, ypoints);
        }
    }

    public void setLabelLocation(Point p) {
        OMLabeler oml;
        if (this.hasLabel && (oml = (OMLabeler)this.getAttribute("Label")) != null) {
            oml.setLocation(p);
        }
    }

    public void setLabelLocation(GeneralPath gp) {
        OMLabeler oml;
        if (this.hasLabel && (oml = (OMLabeler)this.getAttribute("Label")) != null) {
            oml.setLocation(gp);
        }
    }

    public void renderLabel(Graphics g) {
        OMLabeler labeler;
        if (this.hasLabel && (labeler = (OMLabeler)this.getAttribute("Label")) != null) {
            labeler.render(g);
        }
    }

    public boolean shouldRenderFill() {
        return !OMGraphic.isClear(this.getFillPaint());
    }

    public boolean shouldRenderEdge() {
        return !OMGraphic.isClear(this.getDisplayPaint()) || !this.edgeMatchesFill;
    }

    public float distance(int x, int y) {
        float lDistance;
        OMLabeler labeler;
        float distance = Float.POSITIVE_INFINITY;
        distance = this.shouldRenderFill() ? super.distance(x, y) : super.distanceToEdge(x, y);
        if (distance != Float.POSITIVE_INFINITY) {
            distance = this.normalizeDistanceForLineWidth(distance);
        }
        if (this.hasLabel && (labeler = (OMLabeler)this.getAttribute("Label")) != null && (lDistance = labeler.distance(x, y)) < distance) {
            distance = lDistance;
        }
        return distance;
    }

    public boolean regenerate(Projection proj) {
        boolean ret = false;
        if (proj != null && !(ret = super.regenerate(proj)) && this instanceof OMRasterObject) {
            ret = this.generate(proj);
        }
        return ret;
    }

    protected boolean hasLineTypeChoice() {
        return true;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return SinkGraphic.getSharedInstance();
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        boolean writeStroke;
        oos.defaultWriteObject();
        boolean bl = writeStroke = this.stroke != BASIC_STROKE && this.stroke != null;
        if (writeStroke) {
            oos.writeBoolean(true);
            if (this.stroke instanceof BasicStroke) {
                BasicStroke s = (BasicStroke)this.stroke;
                oos.writeBoolean(true);
                if (s != null) {
                    oos.writeFloat(s.getLineWidth());
                    oos.writeInt(s.getEndCap());
                    oos.writeInt(s.getLineJoin());
                    oos.writeFloat(s.getMiterLimit());
                    oos.writeObject(s.getDashArray());
                    oos.writeFloat(s.getDashPhase());
                }
            } else if (this.stroke instanceof Serializable) {
                oos.writeBoolean(false);
                oos.writeObject((Serializable)((Object)this.stroke));
            }
        } else {
            oos.writeBoolean(false);
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        boolean streamHasStroke = ois.readBoolean();
        if (streamHasStroke) {
            boolean isBasicStroke = ois.readBoolean();
            if (isBasicStroke) {
                float linewidth = ois.readFloat();
                int endcap = ois.readInt();
                int linejoin = ois.readInt();
                float miterlimit = ois.readFloat();
                float[] dasharray = (float[])ois.readObject();
                float dashphase = ois.readFloat();
                this.stroke = new BasicStroke(linewidth, endcap, linejoin, miterlimit, dasharray, dashphase);
            } else {
                this.stroke = (Stroke)ois.readObject();
            }
        } else {
            this.stroke = BASIC_STROKE;
        }
    }
}

