/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.OMAction;
import com.bbn.openmap.omGraphics.OMGeometry;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.GraphicList;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.GeneralPath;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.util.List;
import java.util.ListIterator;

public class OMGeometryList
extends OMGraphicList
implements GraphicList,
Serializable {
    protected boolean connectParts = false;

    public OMGeometryList() {
        super(10);
    }

    public OMGeometryList(int initialCapacity) {
        super(initialCapacity);
    }

    public OMGeometryList(List list) {
        super(list);
    }

    public void add(OMGeometry g) {
        this.setNeedToRegenerate(true);
        this._add(g);
    }

    public boolean remove(OMGeometry geometry) {
        this.setNeedToRegenerate(true);
        return this._remove(geometry);
    }

    public int indexOf(OMGeometry geometry) {
        return this._indexOf(geometry);
    }

    public void setAt(OMGeometry geometry, int index) {
        this.setNeedToRegenerate(true);
        this._setAt(geometry, index);
    }

    public OMGeometry getAt(int location) {
        return this._getAt(location);
    }

    public OMGeometry getWithAppObject(Object appObj) {
        return this._getWithAppObject(appObj);
    }

    public Object removeAt(int location) {
        Object obj = this._remove(location);
        if (obj != null) {
            this.setNeedToRegenerate(true);
        }
        return obj;
    }

    public void insertAt(OMGeometry geometry, int location) {
        this.setNeedToRegenerate(true);
        this._insert(geometry, location);
    }

    public void setStroke(Stroke s) {
        this.stroke = s != null ? s : new BasicStroke();
    }

    public void setFillPaint(Paint paint) {
        if (paint != null) {
            this.fillPaint = paint;
            if (Debug.debugging("omGraphics")) {
                Debug.output("OMGraphic.setFillPaint(): fillPaint= " + this.fillPaint);
            }
        } else {
            this.fillPaint = clear;
            if (Debug.debugging("omGraphics")) {
                Debug.output("OMGraphic.setFillPaint(): fillPaint is clear");
            }
        }
        this.setEdgeMatchesFill();
    }

    public void setTextureMask(TexturePaint texture) {
        this.textureMask = texture;
    }

    public void setLinePaint(Paint paint) {
        this.linePaint = paint != null ? paint : Color.black;
        if (!this.selected) {
            this.displayPaint = this.linePaint;
        }
        this.setEdgeMatchesFill();
    }

    public void setSelectPaint(Paint paint) {
        this.selectPaint = paint != null ? paint : Color.black;
        if (this.selected) {
            this.displayPaint = this.selectPaint;
        }
        this.setEdgeMatchesFill();
    }

    public void setMattingPaint(Paint paint) {
        this.mattingPaint = paint != null ? paint : Color.black;
    }

    public void setMatted(boolean value) {
        this.matted = value;
    }

    public synchronized void render(Graphics gr) {
        GeneralPath shp = this.getShape();
        if (shp != null) {
            if (this.matted && gr instanceof Graphics2D && this.stroke instanceof BasicStroke) {
                ((Graphics2D)gr).setStroke(new BasicStroke(((BasicStroke)this.stroke).getLineWidth() + 2.0f));
                this.setGraphicsColor(gr, this.mattingPaint);
                this.draw(gr);
            }
            this.setGraphicsForFill(gr);
            ((Graphics2D)gr).fill(shp);
            this.setGraphicsForEdge(gr);
            ((Graphics2D)gr).draw(shp);
        } else {
            List targets = this.getTargets();
            if (this.traverseMode == 1) {
                ListIterator iterator = targets.listIterator(targets.size());
                while (iterator.hasPrevious()) {
                    OMGeometry geometry = (OMGeometry)iterator.previous();
                    if (!geometry.isVisible()) continue;
                    this.renderGeometry(geometry, gr);
                }
            } else {
                ListIterator iterator = targets.listIterator();
                while (iterator.hasNext()) {
                    OMGeometry geometry = (OMGeometry)iterator.next();
                    if (!geometry.isVisible()) continue;
                    this.renderGeometry(geometry, gr);
                }
            }
        }
    }

    protected void renderGeometry(OMGeometry geometry, Graphics gr) {
        if (this.matted && gr instanceof Graphics2D && this.stroke instanceof BasicStroke) {
            ((Graphics2D)gr).setStroke(new BasicStroke(((BasicStroke)this.stroke).getLineWidth() + 2.0f));
            this.setGraphicsColor(gr, this.mattingPaint);
            geometry.draw(gr);
        }
        this.setGraphicsForFill(gr);
        geometry.fill(gr);
        this.setGraphicsForEdge(gr);
        geometry.draw(gr);
    }

    public void renderAllAsSelected(Graphics gr) {
        if (this.shape != null) {
            this.setGraphicsForFill(gr);
            ((Graphics2D)gr).fill(this.shape);
            this.select();
            this.setGraphicsForEdge(gr);
            ((Graphics2D)gr).draw(this.shape);
            this.deselect();
        }
    }

    public synchronized void generate(Projection p, boolean forceProjectAll) {
        this.shape = null;
        if (this.traverseMode == 1) {
            ListIterator iterator = this.graphics.listIterator(this.graphics.size());
            while (iterator.hasPrevious()) {
                this.updateShape((OMGeometry)iterator.previous(), p, forceProjectAll);
            }
        } else {
            ListIterator iterator = this.graphics.listIterator();
            while (iterator.hasNext()) {
                this.updateShape((OMGeometry)iterator.next(), p, forceProjectAll);
            }
        }
        this.setNeedToRegenerate(false);
    }

    protected void updateShape(OMGeometry geometry, Projection p, boolean forceProject) {
        if (forceProject) {
            geometry.generate(p);
        } else {
            geometry.regenerate(p);
        }
        if (geometry.isVisible()) {
            GeneralPath gp = geometry.getShape();
            if (gp == null) {
                return;
            }
            if (this.shape == null) {
                this.shape = gp;
            } else {
                this.shape.append(gp, this.connectParts);
            }
        }
    }

    protected float _distance(int x, int y) {
        float distance = Float.POSITIVE_INFINITY;
        if (this.isVague()) {
            if (this.getNeedToRegenerate() || this.shape == null) {
                return distance;
            }
            distance = this.shape.contains(x, y) ? 0.0f : this.distanceToEdge(x, y);
        } else {
            distance = super._distance(x, y);
        }
        return distance;
    }

    protected synchronized OMGraphicList.OMDist _findClosest(int x, int y, float limit, boolean resetSelect) {
        if (this.shape != null) {
            float currentDistance = this._distance(x, y);
            OMGraphicList.OMDist omd = new OMGraphicList.OMDist();
            if (currentDistance < limit) {
                omd.omg = this;
                omd.d = currentDistance;
            }
            return omd;
        }
        return super._findClosest(x, y, limit, resetSelect);
    }

    public OMGeometry findClosestGeometry(int x, int y, float limit) {
        return this._findClosest((int)x, (int)y, (float)limit).omg;
    }

    public OMGraphic findClosest(int x, int y, float limit) {
        return this.objectToOMGraphic(this._findClosest((int)x, (int)y, (float)limit).omg);
    }

    public OMGraphic selectClosest(int x, int y, float limit) {
        return this.objectToOMGraphic(this._selectClosest(x, y, limit));
    }

    public OMGeometry findClosestGeometry(int x, int y) {
        return this._findClosest((int)x, (int)y, (float)Float.MAX_VALUE).omg;
    }

    public OMGeometry selectClosestGeometry(int x, int y) {
        return this._selectClosest(x, y, Float.MAX_VALUE);
    }

    public OMGeometry selectClosestGeometry(int x, int y, float limit) {
        return this._selectClosest(x, y, limit);
    }

    public OMGeometry getContains(int x, int y) {
        if (this.shape != null && this.isVague() && this.shape.contains(x, y)) {
            return this;
        }
        return this._getContains(x, y);
    }

    public OMGraphic getOMGraphicThatContains(int x, int y) {
        return this.objectToOMGraphic(this.getContains(x, y));
    }

    public void doAction(OMGeometry geometry, OMAction action) {
        this._doAction(geometry, action);
    }

    /*
     * Unable to fully structure code
     */
    public void readGraphics(ObjectInputStream objstream) throws IOException {
        Debug.message("omgraphics", "OMGeometryList: Reading cached geometries");
        try {
            while (true) lbl-1000:
            // 3 sources

            {
                try {
                    while (true) {
                        omg = (OMGeometry)objstream.readObject();
                        this.add(omg);
                    }
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (OptionalDataException ode) {
                    ode.printStackTrace();
                    continue;
                }
                break;
            }
        }
        catch (EOFException var2_5) {
            return;
        }
        ** GOTO lbl-1000
    }

    public void setConnectParts(boolean value) {
        this.connectParts = value;
    }

    public boolean getConnectParts() {
        return this.connectParts;
    }
}

