/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.gui.GridBagToolBar;
import com.bbn.openmap.layer.util.stateMachine.State;
import com.bbn.openmap.omGraphics.EditableOMGraphic;
import com.bbn.openmap.omGraphics.GrabPoint;
import com.bbn.openmap.omGraphics.GraphicAttributes;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.OffsetGrabPoint;
import com.bbn.openmap.omGraphics.editable.GraphicEditState;
import com.bbn.openmap.omGraphics.editable.GraphicSelectedState;
import com.bbn.openmap.omGraphics.editable.GraphicSetOffsetState;
import com.bbn.openmap.omGraphics.editable.GraphicUndefinedState;
import com.bbn.openmap.omGraphics.editable.PointStateMachine;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class EditableOMPoint
extends EditableOMGraphic {
    protected GrabPoint gpc;
    protected OffsetGrabPoint gpo;
    protected OMPoint point;
    public static final String OffsetResetCmd = "OffsetResetCmd";
    public static final int CENTER_POINT_INDEX = 0;
    public static final int OFFSET_POINT_INDEX = 1;
    protected int lastRenderType = -1;
    protected JToolBar pToolBar = null;

    public EditableOMPoint() {
        this.createGraphic(null);
    }

    public EditableOMPoint(GraphicAttributes ga) {
        this.createGraphic(ga);
    }

    public EditableOMPoint(OMPoint omc) {
        this.setGraphic(omc);
    }

    public void init() {
        Debug.message("eomg", "EditableOMPoint.init()");
        this.setCanGrabGraphic(false);
        this.setStateMachine(new PointStateMachine(this));
        this.gPoints = new GrabPoint[2];
    }

    public void setGraphic(OMGraphic graphic) {
        this.init();
        if (graphic instanceof OMPoint) {
            this.point = (OMPoint)graphic;
            this.stateMachine.setSelected();
            this.setGrabPoints(this.point);
        } else {
            this.createGraphic(null);
        }
    }

    public void createGraphic(GraphicAttributes ga) {
        this.init();
        this.stateMachine.setUndefined();
        int renderType = 0;
        if (ga != null) {
            renderType = ga.getRenderType();
        }
        if (Debug.debugging("eomg")) {
            Debug.output("EditableOMPoint.createGraphic(): rendertype = " + renderType);
        }
        switch (renderType) {
            case 1: {
                this.point = new OMPoint(90.0f, -180.0f);
                break;
            }
            case 3: {
                this.point = new OMPoint(90.0f, -180.0f, 0, 0);
                break;
            }
            default: {
                this.point = new OMPoint(-1, -1);
            }
        }
        if (ga != null) {
            ga.setTo(this.point);
        }
        this.assertGrabPoints();
    }

    public OMGraphic getGraphic() {
        return this.point;
    }

    public void setMovingPoint(GrabPoint gp) {
        super.setMovingPoint(gp);
    }

    public GrabPoint getMovingPoint(MouseEvent e) {
        this.movingPoint = null;
        GrabPoint[] gb = this.getGrabPoints();
        int x = e.getX();
        int y = e.getY();
        for (int i = gb.length - 1; i >= 0; --i) {
            if (gb[i] == null || gb[i].distance(x, y) != 0.0f) continue;
            this.setMovingPoint(gb[i]);
            break;
        }
        return this.movingPoint;
    }

    public void attachToMovingGrabPoint(OffsetGrabPoint gp) {
        gp.addGrabPoint(this.gpo);
    }

    public void detachFromMovingGrabPoint(OffsetGrabPoint gp) {
        gp.removeGrabPoint(this.gpo);
    }

    public void assertGrabPoints() {
        int rt = this.getGraphic().getRenderType();
        if (rt != this.lastRenderType) {
            this.clearGrabPoints();
            this.lastRenderType = rt;
        }
        if (this.gpc == null) {
            this.gPoints[0] = this.gpc = new GrabPoint(-1, -1);
        }
        if (this.gpo == null) {
            this.gpo = new OffsetGrabPoint(-1, -1);
            this.gPoints[1] = this.gpo;
            this.gpo.addGrabPoint(this.gpc);
        }
    }

    protected void clearGrabPoints() {
        this.gpc = null;
        this.gpo = null;
        this.gPoints[0] = this.gpc;
        this.gPoints[1] = this.gpo;
    }

    public void setGrabPoints(OMGraphic graphic) {
        Debug.message("eomg", "EditableOMPoint.setGrabPoints(graphic)");
        if (!(graphic instanceof OMPoint)) {
            return;
        }
        this.assertGrabPoints();
        OMPoint point = (OMPoint)graphic;
        boolean ntr = point.getNeedToRegenerate();
        int renderType = point.getRenderType();
        int latoffset = 0;
        int lonoffset = 0;
        boolean doStraight = true;
        if (!ntr) {
            if ((renderType == 1 || renderType == 3) && this.projection != null) {
                float lon = point.getLon();
                float lat = point.getLat();
                LatLonPoint llp = new LatLonPoint(lat, lon);
                Point p = this.projection.forward(llp);
                if (renderType == 1) {
                    doStraight = false;
                    this.gpc.set((int)p.getX(), (int)p.getY());
                } else {
                    latoffset = (int)p.getY();
                    lonoffset = (int)p.getX();
                    this.gpo.set(lonoffset, latoffset);
                }
            }
            if (doStraight) {
                this.gpc.set(lonoffset + point.getX(), latoffset + point.getY());
            }
            if (renderType == 3) {
                this.gpo.updateOffsets();
            }
        } else {
            Debug.message("eomg", "EditableOMPoint.setGrabPoints: graphic needs to be regenerated");
        }
    }

    public void setGrabPoints() {
        boolean settingOffset;
        LatLonPoint llp1;
        int renderType = this.point.getRenderType();
        Debug.message("eomg", "EditableOMPoint.setGrabPoints()");
        if (renderType == 1 && this.projection != null) {
            llp1 = this.projection.inverse(this.gpc.getX(), this.gpc.getY());
            this.point.set(llp1.getLatitude(), llp1.getLongitude());
        }
        boolean bl = settingOffset = this.getStateMachine().getState() instanceof GraphicSetOffsetState && this.movingPoint == this.gpo;
        if (renderType == 3) {
            llp1 = this.projection.inverse(this.gpo.getX(), this.gpo.getY());
            this.point.setLat(llp1.getLatitude());
            this.point.setLon(llp1.getLongitude());
            if (settingOffset || this.movingPoint == this.gpc) {
                this.point.setX(this.gpc.getX() - this.gpo.getX());
                this.point.setY(this.gpc.getY() - this.gpo.getY());
            }
            if (!settingOffset) {
                Debug.message("eomg", "EditableOMPoint: updating offset point");
                this.point.set(this.gpc.getX() - this.gpo.getX(), this.gpc.getY() - this.gpo.getY());
            }
            this.point.setRenderType(3);
        }
        if (renderType == 2) {
            Debug.message("eomg", "EditableOMPoint: updating x/y point");
            if (this.movingPoint == this.gpc) {
                this.point.set(this.gpc.getX(), this.gpc.getY());
            }
        }
        if (this.projection != null) {
            this.regenerate(this.projection);
        }
    }

    public boolean getCanGrabGraphic() {
        return false;
    }

    public void move(MouseEvent e) {
    }

    public boolean generate(Projection proj) {
        Debug.message("eomgdetail", "EditableOMPoint.generate()");
        if (this.point != null) {
            this.point.generate(proj);
        }
        for (int i = 0; i < this.gPoints.length; ++i) {
            GrabPoint gp = this.gPoints[i];
            if (gp == null) continue;
            gp.generate(proj);
        }
        return true;
    }

    public void regenerate(Projection proj) {
        Debug.message("eomg", "EditableOMPoint.regenerate()");
        if (this.point != null) {
            this.point.generate(proj);
        }
        this.setGrabPoints(this.point);
        this.generate(proj);
    }

    public void render(Graphics graphics) {
        Debug.message("eomgdetail", "EditableOMPoint.render()");
        State state = this.getStateMachine().getState();
        if (!(state instanceof GraphicUndefinedState)) {
            if (this.point != null) {
                this.point.setVisible(true);
                this.point.render(graphics);
                this.point.setVisible(false);
            } else {
                Debug.message("eomg", "EditableOMPoint.render: null point.");
            }
            int renderType = this.point.getRenderType();
            if (state instanceof GraphicSelectedState || state instanceof GraphicEditState) {
                for (int i = 0; i < this.gPoints.length; ++i) {
                    GrabPoint gp = this.gPoints[i];
                    if (gp == null || (i != 1 || renderType != 3 || this.movingPoint != this.gpo) && (!(state instanceof GraphicSelectedState) || (i == 1 || renderType == 3) && renderType != 3)) continue;
                    gp.setVisible(true);
                    gp.render(graphics);
                    gp.setVisible(false);
                }
            }
        }
    }

    public Component getGUI(GraphicAttributes graphicAttributes) {
        Debug.message("eomg", "EditableOMPoint.getGUI");
        if (graphicAttributes != null) {
            JPanel panel = graphicAttributes.getColorAndLineGUI();
            panel.add(this.getPointGUI());
            return panel;
        }
        return this.getPointGUI();
    }

    protected JToolBar getPointGUI() {
        if (this.pToolBar == null) {
            this.pToolBar = new GridBagToolBar();
        }
        return this.pToolBar;
    }
}

