/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.Environment;
import com.bbn.openmap.I18n;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.gui.GridBagToolBar;
import com.bbn.openmap.image.BufferedImageHelper;
import com.bbn.openmap.omGraphics.BasicStrokeEditorMenu;
import com.bbn.openmap.omGraphics.GraphicAttributes;
import com.bbn.openmap.omGraphics.OMColor;
import com.bbn.openmap.omGraphics.OMColorChooser;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicConstants;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.geom.NonRegional;
import com.bbn.openmap.tools.icon.IconPartList;
import com.bbn.openmap.tools.icon.OMIconFactory;
import com.bbn.openmap.tools.icon.OpenMapAppPartCollection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class DrawingAttributes
implements ActionListener,
Serializable,
Cloneable,
PropertyConsumer,
PropertyChangeListener {
    public static final String linePaintProperty = "lineColor";
    public static final String fillPaintProperty = "fillColor";
    public static final String selectPaintProperty = "selectColor";
    public static final String mattingPaintProperty = "mattingColor";
    public static final String fillPatternProperty = "fillPattern";
    public static final String lineWidthProperty = "lineWidth";
    public static final String dashPatternProperty = "dashPattern";
    public static final String dashPhaseProperty = "dashPhase";
    public static final String baseScaleProperty = "baseScale";
    public static final String mattedProperty = "matted";
    public static final String PointOvalProperty = "pointOval";
    public static final String PointRadiusProperty = "pointRadius";
    public static final int NONE = -1;
    public static final String defaultLinePaintString = "0";
    public static final String defaultFillPaintString = "-1";
    public static final String defaultSelectPaintStringline = "0";
    public static final String defaultMattingPaintString = "0";
    public static final float defaultLineWidth = 1.0f;
    public static final float defaultDashPhase = 0.0f;
    public static final float defaultDashLength = 5.0f;
    protected Paint linePaint = Color.black;
    protected Paint selectPaint = Color.black;
    protected Paint fillPaint = OMColor.clear;
    protected Paint mattingPaint = OMColor.black;
    protected TexturePaint fillPattern = null;
    protected transient Stroke stroke = new BasicStroke(1.0f);
    protected float baseScale = -1.0f;
    protected boolean matted = false;
    protected String propertyPrefix = null;
    protected String fPattern = null;
    protected boolean pointOval = false;
    protected int pointRadius = 2;
    public static final DrawingAttributes DEFAULT = new DrawingAttributes();
    protected PropertyChangeSupport propertyChangeSupport = null;
    protected I18n i18n = Environment.getI18n();
    public static final String LineColorCommand = "LineColor";
    public static final String FillColorCommand = "FillColor";
    public static final String SelectColorCommand = "SelectColor";
    public static final String MattingColorCommand = "MattingColor";
    public static final String MattedCommand = "MattedCommand";
    private JButton lineColorButton;
    private JButton fillColorButton;
    private JButton selectColorButton;
    private JButton mattingColorButton;
    private JToggleButton mattedCheckBox;
    protected JMenuItem lineColorItem;
    protected JMenuItem fillColorItem;
    protected JMenuItem selectColorItem;
    protected JMenuItem mattingColorItem;
    protected JCheckBoxMenuItem mattedEnabledItem;
    protected static final int icon_width = 20;
    protected static final int icon_height = 20;
    protected boolean enableFillPaintChoice = true;
    public static boolean alwaysSetTextToBlack = false;
    protected transient BasicStrokeEditorMenu bse;
    protected JButton lineButton;
    protected JMenu[] lineMenuAdditions = null;
    private boolean colorChooserLock = false;
    protected JPanel palette = null;
    protected JToolBar toolbar = null;

    public DrawingAttributes() {
        this.setProperties(null, null);
    }

    public DrawingAttributes(Properties props) {
        this.setProperties(null, props);
    }

    public DrawingAttributes(String prefix, Properties props) {
        this.setProperties(prefix, props);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public Stroke cloneBasicStroke() {
        if (this.stroke instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)this.stroke;
            return new BasicStroke(bs.getLineWidth(), bs.getEndCap(), bs.getLineJoin(), bs.getMiterLimit(), bs.getDashArray(), bs.getDashPhase());
        }
        return new BasicStroke(1.0f);
    }

    public void setTo(DrawingAttributes clone) {
        clone.linePaint = this.linePaint;
        clone.selectPaint = this.selectPaint;
        clone.fillPaint = this.fillPaint;
        clone.mattingPaint = this.mattingPaint;
        clone.fillPattern = this.fillPattern;
        clone.setStroke(this.stroke);
        clone.baseScale = this.baseScale;
        clone.matted = this.matted;
        clone.pointOval = this.pointOval;
        clone.pointRadius = this.pointRadius;
        clone.enableFillPaintChoice = this.enableFillPaintChoice;
    }

    public boolean equals(DrawingAttributes da) {
        return da.linePaint == this.linePaint && da.selectPaint == this.selectPaint && da.fillPaint == this.fillPaint && da.mattingPaint == this.mattingPaint && da.fillPattern == this.fillPattern && da.stroke == this.stroke && da.baseScale == this.baseScale && da.matted == this.matted;
    }

    public static DrawingAttributes getDefaultClone() {
        return (DrawingAttributes)DEFAULT.clone();
    }

    public void init(Properties props) {
        this.setProperties(null, props);
    }

    public void init(String prefix, Properties props) {
        this.setProperties(prefix, props);
    }

    public void setStroke(Stroke stroke) {
        Stroke oldStroke = this.stroke;
        this.stroke = stroke;
        if (stroke instanceof BasicStroke && this.bse != null) {
            this.bse.setBasicStroke((BasicStroke)stroke);
        }
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange("stroke", oldStroke, stroke);
        }
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public Stroke getStrokeForScale(float scale) {
        if (this.baseScale != -1.0f && this.stroke instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)this.stroke;
            float lineWidth = bs.getLineWidth();
            float[] dash = bs.getDashArray();
            float scaleFactor = scale / this.baseScale;
            int endCaps = bs.getEndCap();
            int lineJoins = bs.getLineJoin();
            float miterLimit = bs.getMiterLimit();
            lineWidth *= scaleFactor;
            int i = 0;
            while (i < dash.length) {
                int n = i++;
                dash[n] = dash[n] * scaleFactor;
            }
            return new BasicStroke(lineWidth, endCaps, lineJoins, miterLimit, dash, bs.getDashPhase());
        }
        return this.stroke;
    }

    public Paint getFillPaintForScale(float scale) {
        if (this.fillPattern != null) {
            if (this.baseScale != -1.0f) {
                BufferedImage bi = this.fillPattern.getImage();
                float scaleFactor = scale / this.baseScale;
                Image image = bi.getScaledInstance((int)((float)bi.getWidth() * scaleFactor), (int)((float)bi.getHeight() * scaleFactor), 4);
                try {
                    bi = BufferedImageHelper.getBufferedImage(image, 0, 0, -1, -1);
                    return new TexturePaint(bi, new Rectangle(0, 0, bi.getWidth(), bi.getHeight()));
                }
                catch (InterruptedException ie) {
                    Debug.error("DrawingAttributes: Interrupted Exception scaling texture paint");
                }
            }
            return this.fillPattern;
        }
        return this.fillPaint;
    }

    public void setLinePaint(Paint lPaint) {
        if (lPaint == this.linePaint) {
            return;
        }
        Paint oldPaint = this.linePaint;
        this.linePaint = lPaint;
        if (this.lineColorButton != null) {
            this.lineColorButton.setIcon(DrawingAttributes.getIconForPaint(this.linePaint, false));
        }
        if (this.mattedCheckBox != null) {
            this.mattedCheckBox.setIcon(DrawingAttributes.getMattedIcon(this.mattingPaint, this.linePaint));
        }
        this.propertyChangeSupport.firePropertyChange("linePaint", oldPaint, this.linePaint);
    }

    public Paint getLinePaint() {
        return this.linePaint;
    }

    public void setSelectPaint(Paint sPaint) {
        if (sPaint == this.selectPaint) {
            return;
        }
        Paint oldPaint = this.selectPaint;
        this.selectPaint = sPaint;
        if (this.selectColorButton != null) {
            this.selectColorButton.setIcon(DrawingAttributes.getIconForPaint(this.selectPaint, false));
        }
        this.propertyChangeSupport.firePropertyChange("selectPaint", oldPaint, this.selectPaint);
    }

    public Paint getSelectPaint() {
        return this.selectPaint;
    }

    public void setFillPaint(Paint fPaint) {
        if (fPaint == this.fillPaint) {
            return;
        }
        Paint oldPaint = this.fillPaint;
        this.fillPaint = fPaint;
        if (this.fillColorButton != null) {
            this.fillColorButton.setIcon(DrawingAttributes.getIconForPaint(this.fillPaint, true));
        }
        this.propertyChangeSupport.firePropertyChange("fillPaint", oldPaint, this.fillPaint);
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public void setMattingPaint(Paint mPaint) {
        if (mPaint == this.mattingPaint) {
            return;
        }
        Paint oldPaint = this.mattingPaint;
        this.mattingPaint = mPaint;
        if (this.mattingColorButton != null) {
            this.mattingColorButton.setIcon(this.getMattingIconForPaint());
        }
        if (this.mattedCheckBox != null) {
            this.mattedCheckBox.setIcon(DrawingAttributes.getMattedIcon(this.mattingPaint, this.linePaint));
        }
        this.propertyChangeSupport.firePropertyChange("mattingPaint", oldPaint, this.mattingPaint);
    }

    public Paint getMattingPaint() {
        return this.mattingPaint;
    }

    public void setFillPattern(TexturePaint fPattern) {
        TexturePaint oldPattern = fPattern;
        this.fillPattern = fPattern;
        if (this.fillColorButton != null) {
            // empty if block
        }
        this.propertyChangeSupport.firePropertyChange(fillPatternProperty, oldPattern, this.fillPattern);
    }

    public TexturePaint getFillPattern() {
        return this.fillPattern;
    }

    public void setBaseScale(float bScale) {
        this.baseScale = bScale > 0.0f ? bScale : -1.0f;
    }

    public float getBaseScale() {
        return this.baseScale;
    }

    public boolean isMatted() {
        return this.matted;
    }

    public void setMatted(boolean set) {
        boolean oldMatted = this.matted;
        this.matted = set;
        if (this.mattedCheckBox != null) {
            this.mattedCheckBox.setSelected(this.matted);
        }
        this.propertyChangeSupport.firePropertyChange(mattedProperty, oldMatted, this.matted);
    }

    public void setPointRadius(int radius) {
        this.pointRadius = radius;
    }

    public int getPointRadius() {
        return this.pointRadius;
    }

    public void setPointOval(boolean value) {
        this.pointOval = value;
    }

    public boolean isPointOval() {
        return this.pointOval;
    }

    public void setFrom(OMGraphic graphic) {
        this.setFrom(graphic, false);
    }

    public void setFrom(OMGraphic graphic, boolean resetGUI) {
        if (graphic == null) {
            return;
        }
        this.matted = graphic.isMatted();
        this.mattingPaint = graphic.getMattingPaint();
        this.linePaint = graphic.getLinePaint();
        this.selectPaint = graphic.getSelectPaint();
        this.fillPaint = graphic.getFillPaint();
        this.fillPattern = graphic.getTextureMask();
        this.stroke = graphic.getStroke();
        if (graphic instanceof OMPoint) {
            this.pointRadius = ((OMPoint)graphic).getRadius();
            this.pointOval = ((OMPoint)graphic).isOval();
        }
        boolean bl = this.enableFillPaintChoice = !(graphic instanceof NonRegional);
        if (resetGUI) {
            this.resetGUI();
        }
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange("all", true, true);
        }
    }

    public void setTo(OMGraphic graphic) {
        this.setTo(graphic, false);
    }

    public void setTo(OMGraphic graphic, boolean resetGUI) {
        if (graphic == null) {
            return;
        }
        this.setOMGraphicEdgeAttributes(graphic);
        if (this.fillPattern != null && (this.fillPaint == null || OMGraphic.isClear(this.fillPaint))) {
            graphic.setFillPaint(this.fillPattern);
        } else {
            graphic.setFillPaint(this.fillPaint);
            graphic.setTextureMask(this.fillPattern);
        }
        graphic.setMatted(this.matted);
        graphic.setMattingPaint(this.mattingPaint);
        if (graphic instanceof OMPoint) {
            ((OMPoint)graphic).setRadius(this.pointRadius);
            ((OMPoint)graphic).setOval(this.pointOval);
        }
        if (resetGUI) {
            this.enableFillPaintChoice = !(graphic instanceof NonRegional);
            this.resetGUI();
        }
    }

    public void setOMGraphicEdgeAttributes(OMGraphic graphic) {
        graphic.setLinePaint(this.linePaint);
        graphic.setSelectPaint(this.selectPaint);
        if (this.stroke != null) {
            graphic.setStroke(this.stroke);
        } else {
            graphic.setStroke(OMGraphic.BASIC_STROKE);
        }
    }

    public void setOMGraphicAttributesForScale(OMGraphic graphic, float scale) {
        this.setOMGraphicEdgeAttributesForScale(graphic, scale);
        graphic.setFillPaint(this.getFillPaintForScale(scale));
    }

    public void setOMGraphicEdgeAttributesForScale(OMGraphic graphic, float scale) {
        graphic.setLinePaint(this.linePaint);
        graphic.setSelectPaint(this.selectPaint);
        if (this.stroke != null) {
            graphic.setStroke(this.getStrokeForScale(scale));
        } else {
            graphic.setStroke(OMGraphic.BASIC_STROKE);
        }
    }

    protected synchronized boolean getLock() {
        if (!this.colorChooserLock) {
            this.colorChooserLock = true;
            return this.colorChooserLock;
        }
        return false;
    }

    protected synchronized void releaseLock() {
        this.colorChooserLock = false;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        String command = e.getActionCommand();
        if (command == LineColorCommand && this.linePaint instanceof Color) {
            String interString = this.i18n.get(DrawingAttributes.class, "chooseLineColor", "Choose Line Color");
            Color tmpPaint = this.getNewPaint((Component)source, interString, (Color)this.linePaint);
            if (tmpPaint != null) {
                this.setLinePaint(tmpPaint);
                this.lineButton.setIcon(DrawingAttributes.getDrawingAttributesIcon(this, 20, 20, true));
            }
        } else if (command == FillColorCommand && this.fillPaint instanceof Color) {
            String interString = this.i18n.get(DrawingAttributes.class, "chooseFillColor", "Choose Fill Color");
            Color tmpPaint = this.getNewPaint((Component)source, interString, (Color)this.fillPaint);
            if (tmpPaint != null) {
                this.setFillPaint(tmpPaint);
                this.lineButton.setIcon(DrawingAttributes.getDrawingAttributesIcon(this, 20, 20, true));
            }
        } else if (command == SelectColorCommand && this.selectPaint instanceof Color) {
            String interString = this.i18n.get(DrawingAttributes.class, "chooseSelectColor", "Choose Select Color");
            Color tmpPaint = this.getNewPaint((Component)source, interString, (Color)this.selectPaint);
            if (tmpPaint != null) {
                this.setSelectPaint(tmpPaint);
            }
        } else if (command == MattingColorCommand && this.mattingPaint instanceof Color) {
            String interString = this.i18n.get(DrawingAttributes.class, "chooseMattingColor", "Choose Matting Color");
            Color tmpPaint = this.getNewPaint((Component)source, interString, (Color)this.mattingPaint);
            if (tmpPaint != null) {
                this.setMattingPaint(tmpPaint);
                this.lineButton.setIcon(DrawingAttributes.getDrawingAttributesIcon(this, 20, 20, true));
            }
        } else if (command == MattedCommand) {
            this.setMatted(this.mattedEnabledItem.getState());
            this.lineButton.setIcon(DrawingAttributes.getDrawingAttributesIcon(this, 20, 20, true));
        } else if (Debug.debugging("drawingattributes")) {
            Debug.output("DrawingAttributes.actionPerformed: unrecognized command > " + command);
        }
    }

    protected Color getNewPaint(Component source, String title, Color startingColor) {
        Color newPaint = null;
        if (this.getLock()) {
            newPaint = OMColorChooser.showDialog(source, title, startingColor);
            this.releaseLock();
        }
        return newPaint;
    }

    public Component getGUI() {
        if (Debug.debugging("drawingattributes")) {
            Debug.output("DrawingAttributes: creating palette.");
        }
        return this.getColorAndLineGUI();
    }

    protected JPanel getColorAndLineGUI() {
        if (this.palette == null || this.toolbar == null) {
            this.palette = new JPanel();
            if (Debug.debugging("layout")) {
                this.palette.setBorder(BorderFactory.createLineBorder(Color.red));
            }
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            this.palette.setLayout(gridbag);
            this.toolbar = new GridBagToolBar();
            gridbag.setConstraints(this.toolbar, c);
        }
        this.resetGUI();
        this.palette.removeAll();
        this.toolbar.removeAll();
        this.palette.add(this.toolbar);
        this.lineButton = new JButton(DrawingAttributes.getDrawingAttributesIcon(this, 20, 20, true));
        this.lineButton.setToolTipText(this.i18n.get(DrawingAttributes.class, "drawingAttributesButton", 3, "Modify Drawing Parameters"));
        this.lineButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JButton button = DrawingAttributes.this.getLineButton();
                JPopupMenu popup = new JPopupMenu();
                DrawingAttributes.this.setPreStrokeMenuOptions(popup);
                DrawingAttributes.this.setStrokeMenuOptions(popup);
                DrawingAttributes.this.setPostStrokeMenuOptions(popup);
                popup.show(button, button.getWidth(), 0);
            }
        });
        this.toolbar.add(this.lineButton);
        return this.palette;
    }

    protected void setPreStrokeMenuOptions(JPopupMenu popup) {
        popup.add(this.getColorMenu());
        JMenu[] menus = this.getLineMenuAdditions();
        if (menus != null) {
            for (int i = 0; i < menus.length; ++i) {
                JMenu menu = menus[i];
                if (menu == null) continue;
                popup.add(menu);
            }
        }
    }

    protected void setStrokeMenuOptions(JPopupMenu popup) {
        BasicStrokeEditorMenu tmpbse;
        if (this.stroke instanceof BasicStroke && (tmpbse = this.getBasicStrokeEditor()) != null) {
            tmpbse.setGUI(popup);
        }
    }

    protected void setPostStrokeMenuOptions(JPopupMenu popup) {
    }

    protected JButton getLineButton() {
        return this.lineButton;
    }

    public JMenu getColorMenu() {
        JMenu colorMenu = null;
        colorMenu = new JMenu(this.i18n.get(GraphicAttributes.class, "Color", "Color"));
        colorMenu.add(this.lineColorItem);
        colorMenu.add(this.fillColorItem);
        colorMenu.add(this.selectColorItem);
        colorMenu.add(this.mattingColorItem);
        colorMenu.add(new JSeparator());
        colorMenu.add(this.mattedEnabledItem);
        this.fillColorItem.setEnabled(this.enableFillPaintChoice);
        return colorMenu;
    }

    public void setLineMenuAdditions(JMenu[] lma) {
        this.lineMenuAdditions = lma;
    }

    public JMenu[] getLineMenuAdditions() {
        return this.lineMenuAdditions;
    }

    public void resetGUI() {
        BasicStrokeEditorMenu tmpbse;
        String interString;
        if (this.lineColorItem == null) {
            interString = this.i18n.get(DrawingAttributes.class, "lineColorItem", "Change Edge Color");
            this.lineColorItem = new JMenuItem(interString);
            this.lineColorItem.setActionCommand(LineColorCommand);
            this.lineColorItem.addActionListener(this);
            interString = this.i18n.get(DrawingAttributes.class, "lineColorItem", 3, "Change edge color for rendering.");
            this.lineColorItem.setToolTipText(interString);
        }
        if (this.fillColorItem == null) {
            interString = this.i18n.get(DrawingAttributes.class, "fillColorItem", "Change Fill Color");
            this.fillColorItem = new JMenuItem(interString);
            this.fillColorItem.setActionCommand(FillColorCommand);
            this.fillColorItem.addActionListener(this);
            interString = this.i18n.get(DrawingAttributes.class, "fillColorItem", 3, "Change fill color for rendering.");
            this.fillColorItem.setToolTipText(interString);
        }
        if (this.selectColorItem == null) {
            interString = this.i18n.get(DrawingAttributes.class, "selectColorItem", "Change Highlight Edge Color");
            this.selectColorItem = new JMenuItem(interString);
            this.selectColorItem.setActionCommand(SelectColorCommand);
            this.selectColorItem.addActionListener(this);
            interString = this.i18n.get(DrawingAttributes.class, "selectColorItem", 3, "Change highlight edge color rendered during selection.");
            this.selectColorItem.setToolTipText(interString);
        }
        if (this.mattingColorItem == null) {
            interString = this.i18n.get(DrawingAttributes.class, "mattingColorItem", "Change Matted Edge Color");
            this.mattingColorItem = new JMenuItem(interString);
            this.mattingColorItem.setActionCommand(MattingColorCommand);
            this.mattingColorItem.addActionListener(this);
            interString = this.i18n.get(DrawingAttributes.class, "mattingColorItem", 3, "Change the color of the border around the edge.");
            this.mattingColorItem.setToolTipText(interString);
        }
        if (this.mattedCheckBox == null) {
            interString = this.i18n.get(DrawingAttributes.class, "mattedEnableItem", "Enable Matting on Edge");
            this.mattedEnabledItem = new JCheckBoxMenuItem(interString, this.matted);
            this.mattedEnabledItem.setActionCommand(MattedCommand);
            this.mattedEnabledItem.addActionListener(this);
            interString = this.i18n.get(DrawingAttributes.class, "mattedEnableItem", 3, "Enable/Disable matting on edge.");
            this.mattedEnabledItem.setToolTipText(interString);
        }
        if (this.stroke instanceof BasicStroke && (tmpbse = this.getBasicStrokeEditor()) != null) {
            tmpbse.setBasicStroke((BasicStroke)this.stroke);
        }
    }

    public static ImageIcon getPaletteIcon(Paint paint, int width, int height) {
        BufferedImage bufferedImage = new BufferedImage(width, height, 1);
        Graphics2D graphics = (Graphics2D)bufferedImage.getGraphics();
        graphics.setPaint(paint);
        graphics.fillRect(0, 0, width, height);
        return new ImageIcon(bufferedImage);
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    public void setPropertyChangeSupport(PropertyChangeSupport support) {
        this.propertyChangeSupport = support;
    }

    public static Color calculateTextColor(Color color) {
        if (alwaysSetTextToBlack) {
            return Color.black;
        }
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        int alpha = color.getAlpha();
        if (alpha < 128) {
            return Color.black;
        }
        int newred = DrawingAttributes.normalizeOn128(red);
        int newgreen = DrawingAttributes.normalizeOn128(green);
        int newblue = DrawingAttributes.normalizeOn128(blue);
        return new Color(newred, newgreen, newblue);
    }

    public static int normalizeOn128(int value) {
        if (value >= 255) {
            return 0;
        }
        if (value <= 0) {
            return 255;
        }
        if (value <= 128) {
            return 192;
        }
        return 64;
    }

    public void setProperties(Properties props) {
        this.setProperties(this.getPropertyPrefix(), props);
    }

    public BasicStrokeEditorMenu getBasicStrokeEditor() {
        if (this.bse == null && this.stroke instanceof BasicStroke) {
            try {
                this.bse = new BasicStrokeEditorMenu((BasicStroke)this.getStroke());
                this.bse.getPropertyChangeSupport().addPropertyChangeListener(this);
            }
            catch (Exception e) {
                this.bse = null;
            }
        }
        return this.bse;
    }

    public void setProperties(String prefix, Properties props) {
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.setPropertyPrefix(prefix);
        if (props == null) {
            return;
        }
        String realPrefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.linePaint = PropUtils.parseColorFromProperties(props, realPrefix + linePaintProperty, this.linePaint);
        this.selectPaint = PropUtils.parseColorFromProperties(props, realPrefix + selectPaintProperty, this.selectPaint);
        this.mattingPaint = PropUtils.parseColorFromProperties(props, realPrefix + mattingPaintProperty, this.mattingPaint);
        this.fillPaint = PropUtils.parseColorFromProperties(props, realPrefix + fillPaintProperty, this.fillPaint);
        this.matted = PropUtils.booleanFromProperties(props, realPrefix + mattedProperty, this.matted);
        this.pointRadius = PropUtils.intFromProperties(props, realPrefix + PointRadiusProperty, this.pointRadius);
        this.pointOval = PropUtils.booleanFromProperties(props, realPrefix + PointOvalProperty, this.pointOval);
        boolean basicStrokeDefined = false;
        if (this.stroke != null && this.stroke instanceof BasicStroke) {
            basicStrokeDefined = true;
        }
        float lineWidth = PropUtils.floatFromProperties(props, realPrefix + lineWidthProperty, basicStrokeDefined ? ((BasicStroke)this.stroke).getLineWidth() : 1.0f);
        this.baseScale = PropUtils.floatFromProperties(props, realPrefix + baseScaleProperty, this.baseScale);
        String dPattern = props.getProperty(realPrefix + dashPatternProperty);
        if (basicStrokeDefined && dPattern != null && !dPattern.equals("")) {
            float dashPhase;
            String dPhase;
            float[] lineDash;
            try {
                StringTokenizer t = new StringTokenizer(dPattern);
                int arraySize = t.countTokens();
                lineDash = new float[arraySize];
                int dashCount = 0;
                while (t.hasMoreTokens()) {
                    String segment = t.nextToken();
                    lineDash[dashCount++] = Float.parseFloat(segment);
                    if (!Debug.debugging("drawingattributes")) continue;
                    Debug.output("read " + segment);
                }
            }
            catch (NoSuchElementException nsee) {
                Debug.error("DrawingAttributes.init: dash pattern attributes wrong - should be dashPattern=(number pixels on) (number pixels off)");
                lineDash = null;
            }
            catch (NumberFormatException nfe) {
                Debug.error("DrawingAttributes.init: Number format exception for dashPattern");
                lineDash = null;
            }
            catch (NullPointerException npe) {
                Debug.error("DrawingAttributes.init: Caught null pointer exception - probably resulting from non-float number format exception for dashPattern");
                lineDash = null;
            }
            if (lineDash == null) {
                lineDash = basicStrokeDefined ? ((BasicStroke)this.stroke).getDashArray() : new float[]{5.0f, 5.0f};
            }
            int dashCount = 0;
            for (int x = 0; x < lineDash.length; ++x) {
                dashCount = (int)((float)dashCount + lineDash[x]);
            }
            if (dashCount == 0) {
                lineDash = null;
            }
            if ((dPhase = props.getProperty(realPrefix + dashPhaseProperty)) != null && !dPhase.equals("")) {
                try {
                    dashPhase = Float.valueOf(dPhase).floatValue();
                }
                catch (NumberFormatException nfe) {
                    Debug.error("DrawingAttributes.init: Number format exception for dashPhase");
                    dashPhase = 0.0f;
                }
            } else {
                dashPhase = basicStrokeDefined ? ((BasicStroke)this.stroke).getDashPhase() : 0.0f;
            }
            this.setStroke(new BasicStroke(lineWidth, 0, 0, 10.0f, lineDash, dashPhase));
        } else if (basicStrokeDefined) {
            this.setStroke(new BasicStroke(lineWidth));
        }
        this.fPattern = props.getProperty(realPrefix + fillPatternProperty);
        if (this.fPattern != null && !this.fPattern.equals("")) {
            try {
                URL textureImageURL = PropUtils.getResourceOrFileOrURL(this, this.fPattern);
                if (textureImageURL != null) {
                    BufferedImage bi = BufferedImageHelper.getBufferedImage(textureImageURL, 0, 0, -1, -1);
                    this.fillPattern = new TexturePaint(bi, new Rectangle(0, 0, bi.getWidth(), bi.getHeight()));
                }
            }
            catch (MalformedURLException murle) {
                Debug.error("DrawingAttributes.init: bad texture URL - \n     " + realPrefix + fillPatternProperty);
                this.fillPattern = null;
            }
            catch (InterruptedException ie) {
                Debug.error("DrawingAttributes.init: bad problems getting texture URL - \n" + ie);
                this.fillPattern = null;
            }
        }
    }

    public Properties getProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        if (this.linePaint instanceof Color) {
            props.put(prefix + linePaintProperty, PropUtils.getProperty((Color)this.linePaint));
        }
        if (this.fillPaint instanceof Color) {
            props.put(prefix + fillPaintProperty, PropUtils.getProperty((Color)this.fillPaint));
        }
        if (this.selectPaint instanceof Color) {
            props.put(prefix + selectPaintProperty, PropUtils.getProperty((Color)this.selectPaint));
        }
        if (this.mattingPaint instanceof Color) {
            props.put(prefix + mattingPaintProperty, PropUtils.getProperty((Color)this.mattingPaint));
        }
        props.put(prefix + PointRadiusProperty, Integer.toString(this.pointRadius));
        props.put(prefix + PointOvalProperty, new Boolean(this.pointOval).toString());
        props.put(prefix + fillPatternProperty, this.fPattern == null ? "" : this.fPattern);
        Stroke bs = this.getStroke();
        if (bs == null) {
            bs = new BasicStroke();
        }
        if (bs instanceof BasicStroke) {
            props.put(prefix + lineWidthProperty, Float.toString(((BasicStroke)bs).getLineWidth()));
            float[] fa = ((BasicStroke)bs).getDashArray();
            if (fa != null) {
                StringBuffer dp = new StringBuffer();
                for (int i = 0; i < fa.length; ++i) {
                    dp.append(" " + Float.toString(fa[i]));
                }
                props.put(prefix + dashPatternProperty, dp.toString());
                props.put(prefix + dashPhaseProperty, Float.toString(((BasicStroke)bs).getDashPhase()));
            } else {
                props.put(prefix + dashPatternProperty, "");
                props.put(prefix + dashPhaseProperty, "");
            }
        }
        if (this.baseScale != -1.0f) {
            props.put(prefix + baseScaleProperty, Float.toString(this.baseScale));
        }
        props.put(prefix + mattedProperty, new Boolean(this.matted).toString());
        return props;
    }

    public Properties getPropertyInfo(Properties list) {
        if (list == null) {
            list = new Properties();
        }
        String interString = this.i18n.get(DrawingAttributes.class, linePaintProperty, 3, "Edge color for graphics.");
        list.put(linePaintProperty, interString);
        interString = this.i18n.get(DrawingAttributes.class, linePaintProperty, linePaintProperty);
        list.put("lineColor.label", interString);
        list.put("lineColor.editor", "com.bbn.openmap.util.propertyEditor.ColorPropertyEditor");
        interString = this.i18n.get(DrawingAttributes.class, fillPaintProperty, 3, "Fill color for graphics.");
        list.put(fillPaintProperty, interString);
        interString = this.i18n.get(DrawingAttributes.class, fillPaintProperty, fillPaintProperty);
        list.put("fillColor.label", interString);
        list.put("fillColor.editor", "com.bbn.openmap.util.propertyEditor.ColorPropertyEditor");
        interString = this.i18n.get(DrawingAttributes.class, selectPaintProperty, 3, "Selected edge color for graphics.");
        list.put(selectPaintProperty, interString);
        interString = this.i18n.get(DrawingAttributes.class, selectPaintProperty, selectPaintProperty);
        list.put("selectColor.label", interString);
        list.put("selectColor.editor", "com.bbn.openmap.util.propertyEditor.ColorPropertyEditor");
        interString = this.i18n.get(DrawingAttributes.class, mattingPaintProperty, 3, "Matting edge color for graphics.");
        list.put(mattingPaintProperty, interString);
        interString = this.i18n.get(DrawingAttributes.class, mattingPaintProperty, mattingPaintProperty);
        list.put("mattingColor.label", interString);
        list.put("mattingColor.editor", "com.bbn.openmap.util.propertyEditor.ColorPropertyEditor");
        interString = this.i18n.get(DrawingAttributes.class, fillPatternProperty, 3, "Image file to use for fill pattern for graphics (optional).");
        list.put(fillPatternProperty, interString);
        interString = this.i18n.get(DrawingAttributes.class, fillPatternProperty, fillPatternProperty);
        list.put("fillPattern.label", interString);
        list.put("fillPattern.editor", "com.bbn.openmap.util.propertyEditor.FUPropertyEditor");
        interString = this.i18n.get(DrawingAttributes.class, lineWidthProperty, 3, "Line width for edges of graphics");
        list.put(lineWidthProperty, interString);
        interString = this.i18n.get(DrawingAttributes.class, lineWidthProperty, lineWidthProperty);
        list.put("lineWidth.label", interString);
        interString = this.i18n.get(DrawingAttributes.class, dashPatternProperty, 3, "Line dash pattern, represented by space separated numbers (on off on ...)");
        list.put(dashPatternProperty, interString);
        interString = this.i18n.get(DrawingAttributes.class, dashPatternProperty, dashPatternProperty);
        list.put("dashPattern.label", interString);
        interString = this.i18n.get(DrawingAttributes.class, dashPhaseProperty, 3, "Phase for dash pattern (Default is 0)");
        list.put(dashPhaseProperty, interString);
        interString = this.i18n.get(DrawingAttributes.class, dashPhaseProperty, dashPhaseProperty);
        list.put("dashPhase.label", interString);
        interString = this.i18n.get(DrawingAttributes.class, baseScaleProperty, 3, "<HTML><BODY>Scale which should be used as the base scale for the <br>patterns and line width. If set, size of pattern and <br>widths will be adjusted to the map scale</BODY></HTML>");
        list.put(baseScaleProperty, interString);
        interString = this.i18n.get(DrawingAttributes.class, baseScaleProperty, baseScaleProperty);
        list.put("baseScale.label", interString);
        interString = this.i18n.get(DrawingAttributes.class, mattedProperty, 3, "Flag to enable a thin black matting to be drawn around graphics.");
        list.put(mattedProperty, interString);
        interString = this.i18n.get(DrawingAttributes.class, mattedProperty, mattedProperty);
        list.put("matted.label", interString);
        list.put("matted.editor", "com.bbn.openmap.util.propertyEditor.OnOffPropertyEditor");
        interString = this.i18n.get(DrawingAttributes.class, PointRadiusProperty, 3, "Pixel radius of point objects.");
        list.put(PointRadiusProperty, interString);
        interString = this.i18n.get(DrawingAttributes.class, PointRadiusProperty, "Point pixel radius");
        list.put("pointRadius.label", interString);
        interString = this.i18n.get(DrawingAttributes.class, PointOvalProperty, 3, "Set points to be oval or rectangular.");
        list.put(PointOvalProperty, interString);
        interString = this.i18n.get(DrawingAttributes.class, PointOvalProperty, "Points are oval");
        list.put("pointOval.label", interString);
        list.put("pointOval.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        return list;
    }

    public String getInitPropertiesOrder() {
        return " lineColor selectColor fillColor mattingColor fillPattern matted lineWidth dashPattern dashPhase pointRadius pointOval";
    }

    public void setPropertyPrefix(String prefix) {
        this.propertyPrefix = prefix;
    }

    public String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getSource() instanceof BasicStrokeEditorMenu) {
            this.setStroke((BasicStroke)pce.getNewValue());
            this.lineButton.setIcon(DrawingAttributes.getDrawingAttributesIcon(this, 20, 20, true));
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("DrawingAttributes[");
        sb.append("linePaint(" + this.linePaint + "), ");
        sb.append("selectPaint(" + this.selectPaint + "), ");
        sb.append("mattingPaint(" + this.mattingPaint + "), ");
        sb.append("fillPaint(" + this.fillPaint + "), ");
        sb.append("fillPattern(" + this.fillPattern + "), ");
        sb.append("stroke(" + this.stroke + "), ");
        sb.append("baseScale(" + this.baseScale + "), ");
        sb.append("matted(" + new Boolean(this.matted).toString() + ")]");
        return sb.toString();
    }

    public void render(Graphics2D g, Shape shape) {
        this.render(g, shape, false);
    }

    public void render(Graphics2D g, Shape shape, boolean replaceColorWithGradient) {
        if (this.matted && this.stroke instanceof BasicStroke) {
            g.setStroke(new BasicStroke(((BasicStroke)this.stroke).getLineWidth() + 2.0f));
            g.setPaint(this.mattingPaint);
            g.draw(shape);
        }
        if (!OMGraphic.isClear(this.fillPaint)) {
            g.setStroke(OMGraphicConstants.BASIC_STROKE);
            if (replaceColorWithGradient) {
                g.setPaint(DrawingAttributes.getGradientPaintForShape(shape, this.fillPaint));
            } else {
                g.setPaint(this.fillPaint);
            }
            g.fill(shape);
            g.draw(shape);
            if (this.fillPattern != null && this.fillPattern != this.fillPaint) {
                g.setPaint(this.fillPattern);
                g.fill(shape);
            }
        }
        if (this.linePaint != this.fillPaint) {
            g.setStroke(this.getStroke());
            if (replaceColorWithGradient) {
                g.setPaint(DrawingAttributes.getGradientPaintForShape(shape, this.linePaint));
            } else {
                g.setPaint(this.linePaint);
            }
            g.draw(shape);
        }
    }

    public static Paint getGradientPaintForShape(Shape shape, Paint paint) {
        if (paint instanceof Color) {
            Color color = (Color)paint;
            Rectangle rect = shape.getBounds();
            paint = new GradientPaint((float)rect.getWidth() * 0.3f, (float)rect.getHeight() * 0.3f, color.brighter().brighter(), (float)rect.getWidth() * 0.7f, (float)rect.getHeight() * 0.7f, color.darker().darker());
        }
        return paint;
    }

    public ImageIcon getMattingIconForPaint() {
        Paint paint = this.getMattingPaint();
        DrawingAttributes da = new DrawingAttributes();
        da.setLinePaint(paint);
        da.setStroke(new BasicStroke(3.0f));
        DrawingAttributes innerda = new DrawingAttributes();
        innerda.setLinePaint(Color.white);
        innerda.setStroke(new BasicStroke(1.0f));
        OpenMapAppPartCollection collection = OpenMapAppPartCollection.getInstance();
        IconPartList parts = new IconPartList();
        if (paint instanceof Color) {
            Color color = (Color)paint;
            Color opaqueColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), 255);
            DrawingAttributes opaqueDA = new DrawingAttributes();
            opaqueDA.setLinePaint(opaqueColor);
            opaqueDA.setStroke(new BasicStroke(3.0f));
            parts.add(collection.get("LR_TRI", opaqueDA));
            parts.add(collection.get("UL_TRI", da));
            parts.add(collection.get("LR_TRI", innerda));
            parts.add(collection.get("UL_TRI", innerda));
        } else {
            parts.add(collection.get("BIG_BOX", da));
            parts.add(collection.get("BIG_BOX", innerda));
        }
        return OMIconFactory.getIcon(20, 20, parts);
    }

    public static ImageIcon getIconForPaint(Paint paint, boolean fill) {
        if (paint == null) {
            paint = Color.black;
        }
        DrawingAttributes da = new DrawingAttributes();
        da.setLinePaint(paint);
        da.setStroke(new BasicStroke(2.0f));
        if (fill) {
            da.setFillPaint(paint);
        }
        OpenMapAppPartCollection collection = OpenMapAppPartCollection.getInstance();
        IconPartList parts = new IconPartList();
        if (paint instanceof Color || paint == OMColor.clear) {
            Color color = (Color)paint;
            Color opaqueColor = new Color(color.getRed(), color.getGreen(), color.getBlue());
            DrawingAttributes opaqueDA = new DrawingAttributes();
            opaqueDA.setLinePaint(opaqueColor);
            opaqueDA.setStroke(new BasicStroke(2.0f));
            if (fill) {
                opaqueDA.setFillPaint(opaqueColor);
            }
            parts.add(collection.get("LR_TRI", opaqueDA));
            parts.add(collection.get("UL_TRI", da));
        } else {
            parts.add(collection.get("BIG_BOX", da));
        }
        return OMIconFactory.getIcon(20, 20, parts);
    }

    public static ImageIcon getMattedIcon(Paint mattingPaint, Paint linePaint) {
        DrawingAttributes da = new DrawingAttributes();
        da.setMattingPaint(mattingPaint);
        da.setStroke(new BasicStroke(2.0f));
        DrawingAttributes fillda = new DrawingAttributes();
        fillda.setLinePaint(linePaint);
        fillda.setFillPaint(linePaint);
        da.setStroke(new BasicStroke(2.0f));
        OpenMapAppPartCollection collection = OpenMapAppPartCollection.getInstance();
        IconPartList parts = new IconPartList();
        parts.add(collection.get("FILL_BOX", fillda));
        parts.add(collection.get("BIG_BOX", da));
        parts.add(collection.get("SMALL_BOX", da));
        return OMIconFactory.getIcon(20, 20, parts);
    }

    public static ImageIcon getDrawingAttributesIcon(DrawingAttributes attributes, int width, int height, boolean horizontalOrientation) {
        BufferedImage bigImage = new BufferedImage(width, height, 2);
        Graphics2D g = (Graphics2D)bigImage.getGraphics();
        g.setBackground(OMColor.clear);
        if (attributes.enableFillPaintChoice) {
            g.setPaint(attributes.fillPaint);
            g.fillRect(0, 0, width, height);
        }
        if (attributes.matted) {
            BasicStroke mattedStroke = new BasicStroke(((BasicStroke)attributes.stroke).getLineWidth() + 2.0f);
            g.setStroke(mattedStroke);
            g.setPaint(attributes.mattingPaint);
            g.drawLine(0, height / 2, width, height / 2);
        }
        g.setPaint(attributes.linePaint);
        g.setStroke(attributes.stroke);
        if (horizontalOrientation) {
            g.drawLine(3, height / 2, width - 3, height / 2);
        } else {
            g.drawLine(width / 2, 3, width / 2, height - 3);
        }
        return new ImageIcon(bigImage);
    }

    public boolean isEnableFillPaintChoice() {
        return this.enableFillPaintChoice;
    }

    public void setEnableFillPaintChoice(boolean enableFillPaintChoice) {
        this.enableFillPaintChoice = enableFillPaintChoice;
    }
}

