/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.vpf.AreaTable;
import com.bbn.openmap.layer.vpf.CoordFloatString;
import com.bbn.openmap.layer.vpf.CoverageTable;
import com.bbn.openmap.layer.vpf.EdgeTable;
import com.bbn.openmap.layer.vpf.FeatureCacheGraphicList;
import com.bbn.openmap.layer.vpf.FeatureDrawingAttributes;
import com.bbn.openmap.layer.vpf.NodeTable;
import com.bbn.openmap.layer.vpf.PrimitiveTable;
import com.bbn.openmap.layer.vpf.TextTable;
import com.bbn.openmap.layer.vpf.TileDirectory;
import com.bbn.openmap.layer.vpf.VPFFeatureCache;
import com.bbn.openmap.layer.vpf.VPFFeatureGraphicWarehouse;
import com.bbn.openmap.omGraphics.OMColor;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.util.Debug;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class VPFCachedFeatureGraphicWarehouse
extends VPFFeatureGraphicWarehouse {
    protected VPFFeatureCache featureCache = null;

    public VPFCachedFeatureGraphicWarehouse() {
    }

    public VPFCachedFeatureGraphicWarehouse(VPFFeatureCache vfc) {
        this();
        this.setFeatureCache(vfc);
    }

    public void setFeatureCache(VPFFeatureCache vfc) {
        this.featureCache = vfc;
    }

    public VPFFeatureCache getFeatureCache() {
        return this.featureCache;
    }

    public void createArea(CoverageTable covtable, AreaTable areatable, List facevec, LatLonPoint ll1, LatLonPoint ll2, float dpplat, float dpplon, String featureType) {
        ArrayList ipts = new ArrayList();
        int totalSize = 0;
        try {
            totalSize = areatable.computeEdgePoints(facevec, ipts);
        }
        catch (FormatException f) {
            Debug.output("FormatException in computeEdgePoints: " + f);
            return;
        }
        if (totalSize == 0) {
            return;
        }
        OMPoly py = VPFCachedFeatureGraphicWarehouse.createAreaOMPoly(ipts, totalSize, ll1, ll2, dpplat, dpplon, covtable.doAntarcticaWorkaround);
        FeatureDrawingAttributes da = this.getAttributesForFeature(featureType);
        da.setTo(py);
        py.setLinePaint(da.getFillPaint());
        py.setSelectPaint(da.getFillPaint());
        this.addToCachedList(py, featureType, areatable, "Area");
    }

    public void createEdge(CoverageTable c, EdgeTable edgetable, List edgevec, LatLonPoint ll1, LatLonPoint ll2, float dpplat, float dpplon, CoordFloatString coords, String featureType) {
        OMPoly py = VPFCachedFeatureGraphicWarehouse.createEdgeOMPoly(coords, ll1, ll2, dpplat, dpplon);
        FeatureDrawingAttributes da = this.getAttributesForFeature(featureType);
        da.setTo(py);
        py.setFillPaint(OMColor.clear);
        py.setIsPolygon(false);
        this.addToCachedList(py, featureType, edgetable, "Edge");
    }

    public void createText(CoverageTable c, TextTable texttable, List textvec, float latitude, float longitude, String text, String featureType) {
        OMText txt = VPFCachedFeatureGraphicWarehouse.createOMText(text, latitude, longitude);
        this.getAttributesForFeature(featureType).setTo(txt);
        this.addToCachedList(txt, featureType, texttable, "Text");
    }

    public void createNode(CoverageTable c, NodeTable t, List nodeprim, float latitude, float longitude, boolean isEntityNode, String featureType) {
        OMPoint pt = VPFCachedFeatureGraphicWarehouse.createOMPoint(latitude, longitude);
        this.getAttributesForFeature(featureType).setTo(pt);
        this.addToCachedList(pt, featureType, t, isEntityNode ? "EPoint" : "CPoint");
    }

    protected synchronized void addToCachedList(OMGraphic omg, String featureType, PrimitiveTable pt, String type) {
        if (this.featureCache != null) {
            this.featureCache.addToCachedList(omg, featureType, pt, type);
        } else if (type == "Area") {
            this.addArea(omg);
        } else if (type == "Edge") {
            this.addEdge(omg);
        } else if (type == "Text") {
            this.addText(omg);
        } else {
            this.addPoint(omg);
        }
    }

    public boolean needToFetchTileContents(String currentFeature, TileDirectory currentTile) {
        if (this.featureCache != null) {
            return this.featureCache.needToFetchTileContents(currentFeature, currentTile, this.graphics);
        }
        return super.needToFetchTileContents(currentFeature, currentTile);
    }

    public synchronized OMGraphicList getGraphics() {
        if (this.featureCache != null) {
            OMGraphicList ret = new OMGraphicList();
            ret.setTraverseMode(0);
            Iterator it = this.graphics.iterator();
            while (it.hasNext()) {
                OMGraphic omg = (OMGraphic)it.next();
                if (omg instanceof FeatureCacheGraphicList) {
                    FeatureCacheGraphicList fcgl = (FeatureCacheGraphicList)((FeatureCacheGraphicList)omg).clone();
                    fcgl.setDrawingAttributes(this);
                    if (fcgl instanceof FeatureCacheGraphicList.AREA) {
                        this.addArea(fcgl);
                        continue;
                    }
                    if (fcgl instanceof FeatureCacheGraphicList.EDGE) {
                        this.addEdge(fcgl);
                        continue;
                    }
                    if (fcgl instanceof FeatureCacheGraphicList.TEXT) {
                        this.addText(fcgl);
                        continue;
                    }
                    this.addPoint(fcgl);
                    continue;
                }
                this.addPoint(omg);
            }
            return this.getGraphics(ret);
        }
        return super.getGraphics();
    }
}

