/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.layer.vpf.DcwCrossTileID;
import java.util.List;

public interface TilingAdapter {
    public int getTileId(List var1);

    public int getPrimId(List var1);

    public int getTilePrimId(List var1);

    public DcwCrossTileID getPrim(List var1);

    public static class TiledAdapter
    implements TilingAdapter {
        private final int tilecolumn;
        private final int primcolumn;

        public TiledAdapter(int tilecolumn, int primcolumn) {
            this.tilecolumn = tilecolumn;
            this.primcolumn = primcolumn;
        }

        public int getTileId(List l) {
            return ((Number)l.get(this.tilecolumn)).intValue();
        }

        public int getPrimId(List l) {
            return this.getTilePrimId(l);
        }

        public int getTilePrimId(List l) {
            return ((Number)l.get(this.primcolumn)).intValue();
        }

        public DcwCrossTileID getPrim(List l) {
            return new DcwCrossTileID(this.getPrimId(l), this.getTileId(l), this.getTilePrimId(l));
        }
    }

    public static class CrossTileAdapter
    implements TilingAdapter {
        private final int column;

        public CrossTileAdapter(int column) {
            this.column = column;
        }

        public int getTileId(List l) {
            return this.getPrim((List)l).nextTileID;
        }

        public int getPrimId(List l) {
            return this.getPrim((List)l).currentTileKey;
        }

        public int getTilePrimId(List l) {
            return this.getPrim((List)l).nextTileKey;
        }

        public DcwCrossTileID getPrim(List l) {
            return (DcwCrossTileID)l.get(this.column);
        }
    }

    public static class UntiledAdapter
    implements TilingAdapter {
        private final int column;

        public UntiledAdapter(int column) {
            this.column = column;
        }

        public int getTileId(List l) {
            return -1;
        }

        public int getPrimId(List l) {
            return ((Number)l.get(this.column)).intValue();
        }

        public int getTilePrimId(List l) {
            return ((Number)l.get(this.column)).intValue();
        }

        public DcwCrossTileID getPrim(List l) {
            return new DcwCrossTileID(this.getPrimId(l), -1, this.getTilePrimId(l));
        }
    }
}

