/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.shape;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.event.ProjectionListener;
import com.bbn.openmap.layer.shape.MultiShapeLayer;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.tools.roads.LayerView;
import com.bbn.openmap.tools.roads.RoadFinder;
import com.bbn.openmap.tools.roads.RoadServices;
import com.bbn.openmap.tools.roads.Route;
import com.bbn.openmap.util.PropUtils;
import java.awt.Graphics;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MultiRoadLayer
extends MultiShapeLayer
implements RoadServices,
ProjectionListener,
LayerView {
    Logger logger = Logger.getLogger(this.getClass().getName());
    RoadFinder helper;
    List toDraw = new ArrayList();
    boolean drawIntersections = false;
    boolean drawResults = false;
    public static final String DrawIntersectionsProperty = "drawIntersections";
    public static final String DrawResultsProperty = "drawResults";

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        String realPrefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.setDrawIntersections(PropUtils.booleanFromProperties(props, realPrefix + DrawIntersectionsProperty, this.drawIntersections));
        this.setDrawResults(PropUtils.booleanFromProperties(props, realPrefix + DrawResultsProperty, this.drawResults));
        this.setHelper();
    }

    protected void setDrawIntersections(boolean val) {
        this.drawIntersections = val;
    }

    protected void setDrawResults(boolean val) {
        this.drawResults = val;
    }

    protected void setHelper() {
        this.logger.info("draw inter " + this.drawIntersections);
        this.helper = new RoadFinder(this, this.drawIntersections, this.drawResults);
    }

    public List getPathOnRoad(Point start, Point end, List segments) {
        return this.helper.getPathOnRoad(start, end, segments);
    }

    public Route getPathOnRoad(LatLonPoint start, LatLonPoint end) {
        return this.helper.getPathOnRoad(start, end);
    }

    public List displayPathOnRoad(Point start, Point end, Route route, List segments) {
        return this.helper.displayPathOnRoad(start, end, route, segments);
    }

    public RoadServices getRoadServices() {
        return this.helper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void projectionChanged(ProjectionEvent e) {
        super.projectionChanged(e);
        this.logger.info("calling helper - projection changed.");
        MultiRoadLayer multiRoadLayer = this;
        synchronized (multiRoadLayer) {
            if (this.helper == null) {
                this.setHelper();
            }
            this.helper.projectionChanged(e);
        }
    }

    public List getGraphicList() {
        OMGraphicList list = this.getList();
        ArrayList out = new ArrayList();
        HashSet<OMGraphic> seen = new HashSet<OMGraphic>();
        if (list != null) {
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.info("size is " + list.size());
            }
            for (int i = 0; i < list.size(); ++i) {
                OMGraphic graphic = list.getOMGraphicAt(i);
                if (seen.contains(graphic)) continue;
                seen.add(graphic);
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.info(i + " - " + graphic);
                }
                if (graphic instanceof OMGraphicList) {
                    if (this.logger.isLoggable(Level.INFO)) {
                        this.logger.info("size of " + graphic + " is " + ((OMGraphicList)graphic).size());
                    }
                    Iterator iter = ((OMGraphicList)graphic).iterator();
                    while (iter.hasNext()) {
                        Object inner = iter.next();
                        if (inner instanceof OMGraphicList) {
                            if (this.logger.isLoggable(Level.INFO)) {
                                this.logger.info("size of " + inner + " is " + ((OMGraphicList)inner).size());
                            }
                            Iterator iter2 = ((OMGraphicList)inner).iterator();
                            while (iter2.hasNext()) {
                                Object inner2 = iter2.next();
                                if (this.logger.isLoggable(Level.INFO)) {
                                    this.logger.info("1) adding - " + inner2);
                                }
                                out.add(inner2);
                            }
                            continue;
                        }
                        if (this.logger.isLoggable(Level.INFO)) {
                            this.logger.info("2) adding - " + inner);
                        }
                        out.add(inner);
                    }
                    continue;
                }
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.info("3) adding " + graphic);
                }
                out.add(graphic);
            }
        }
        return out;
    }

    public void setExtraGraphics(List toDraw) {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("setting to draw " + toDraw.size() + " new graphics.");
        }
        this.toDraw = toDraw;
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.drawIntersections || this.drawResults) {
            OMGraphicList graphics = new OMGraphicList(this.toDraw);
            graphics.generate(this.getProjection(), true);
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.info("rendering toDraw " + this.toDraw.size() + " items");
            }
            graphics.render(g);
        }
    }
}

