/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.rpf;

import com.bbn.openmap.io.BinaryBufferedFile;
import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.nitf.NitfHeader;
import com.bbn.openmap.layer.rpf.RpfAttributes;
import com.bbn.openmap.layer.rpf.RpfColortable;
import com.bbn.openmap.layer.rpf.RpfFileSections;
import com.bbn.openmap.layer.rpf.RpfFrameEntry;
import com.bbn.openmap.layer.rpf.RpfHeader;
import com.bbn.openmap.layer.rpf.RpfSubframe;
import com.bbn.openmap.layer.rpf.RpfViewAttributes;
import com.bbn.openmap.omGraphics.OMScalingRaster;
import com.bbn.openmap.util.ArgParser;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PaletteHelper;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class RpfFrame {
    boolean valid = false;
    protected NitfHeader nitfHeader;
    protected RpfHeader header;
    protected RpfFileSections fileSections;
    protected RpfAttributes attributes;
    protected RpfFileSections.RpfCoverageSection coverage;
    protected RpfColortable colortable;
    String report;
    byte[][][] compressedSubframe = new byte[6][6][];
    byte[][][] table = new byte[4][4096][4];
    boolean[][] chummed = new boolean[6][6];
    boolean[][] masked = new boolean[6][6];
    boolean Dchum = false;
    int chumVersion;
    int numCharsInDesc;
    int descCount;
    String[] descriptors;
    String[] descriptorDates;
    protected boolean DEBUG_RPFDETAIL = Debug.debugging("rpfdetail");
    protected boolean DEBUG_RPFFRAME = Debug.debugging("rpfframe");

    public RpfFrame(String framePath) {
        this.initFile(framePath);
    }

    public RpfFrame(RpfFrameEntry rfe) {
        this(rfe.framePath);
        if (!this.isValid() && rfe.exists && rfe.rpfdirIndex != -1) {
            String lowerCaseFramePath = rfe.framePath.substring(rfe.rpfdirIndex + 3);
            lowerCaseFramePath = lowerCaseFramePath.toLowerCase();
            String rpfDir = rfe.framePath.substring(0, rfe.rpfdirIndex + 3);
            if (this.DEBUG_RPFFRAME) {
                Debug.output("RpfFrame " + rfe.framePath + " not found, checking " + rpfDir + lowerCaseFramePath);
            }
            if (this.initFile(rpfDir + lowerCaseFramePath)) {
                rfe.framePath = rpfDir + lowerCaseFramePath;
            } else {
                rfe.exists = false;
            }
        }
        this.Dchum = true;
    }

    protected boolean initFile(String framePath) {
        try {
            BinaryBufferedFile binFile = new BinaryBufferedFile(framePath);
            this.read(binFile);
            binFile.close();
        }
        catch (FileNotFoundException e) {
            Debug.error("RpfFrame: file " + framePath + " not found");
            this.valid = false;
        }
        catch (IOException ioe) {
            Debug.error("RpfFrame: File IO Error while handling NITF header:\n" + ioe);
            this.valid = false;
        }
        catch (NullPointerException npe) {
            Debug.error("RpfFrame: File IO Error NPE:\n" + npe);
            npe.printStackTrace();
            this.valid = false;
        }
        return this.valid;
    }

    public boolean isValid() {
        return this.valid;
    }

    protected void setReport(boolean Cib) {
        if (this.attributes != null) {
            StringBuffer s = new StringBuffer();
            s.append("\nRPF Currency Date: " + this.attributes.currencyDate);
            s.append("\nRPF Production Date: " + this.attributes.productionDate);
            s.append("\nSource Significant Date: " + this.attributes.significantDate);
            if (Cib) {
                s.append("\nMap Source: " + this.attributes.dataSource);
            } else {
                s.append("\nMap Designation: " + this.attributes.mapDesignationCode);
                s.append("\nMap Series: " + this.attributes.chartSeriesCode);
                s.append("\nMap Edition: " + this.attributes.edition);
            }
            this.report = s.toString();
        }
    }

    public String getReport(int x, int y, RpfFrameEntry entry, boolean Cib) {
        StringBuffer s = new StringBuffer();
        s.append("Subframe " + (x %= 6) + ", " + (y %= 6) + "\n");
        if (entry != null) {
            s.append("\nFrame Name: ");
            s.append(entry.framePath.substring(entry.filenameIndex));
        } else {
            s.append("\nFrame Name: Unavailable.");
        }
        if (this.report == null) {
            this.setReport(Cib);
        }
        if (this.report != null) {
            s.append(this.report);
        }
        s.append("\nFrom Frame Dir: ");
        String actualFilePath = entry.framePath.substring(0, entry.filenameIndex);
        if (actualFilePath.length() > 20) {
            int start = 0;
            int index = actualFilePath.indexOf("/", 15);
            while (index != -1) {
                s.append(actualFilePath.substring(start, index));
                s.append("/\n    ");
                start = index + 1;
                index = actualFilePath.indexOf("/", start + 15);
            }
            s.append(actualFilePath.substring(start));
        } else {
            s.append(actualFilePath);
        }
        return s.toString().trim();
    }

    public NitfHeader getNitfHeader() {
        return this.nitfHeader;
    }

    public RpfHeader getHeader() {
        return this.header;
    }

    public RpfFileSections getFileSections() {
        return this.fileSections;
    }

    public RpfAttributes getAttributes() {
        return this.attributes;
    }

    public RpfFileSections.RpfCoverageSection getCoverage() {
        return this.coverage;
    }

    public Color[] getColors(BinaryFile binFile, RpfColortable ct) {
        this.fileSections.parseColorSection(binFile, ct);
        return ct.colors;
    }

    public static Color[] getColors(String framePath, RpfColortable ct) {
        BinaryBufferedFile binFile = null;
        try {
            binFile = new BinaryBufferedFile(framePath);
            RpfFileSections rfs = new RpfFileSections();
            RpfHeader head = new RpfHeader();
            head.read(binFile);
            ((BinaryFile)binFile).seek(head.locationSectionLocation);
            rfs.parse(binFile);
            Color[] ret = rfs.parseColorSection(binFile, ct);
            binFile.close();
            return ret;
        }
        catch (FileNotFoundException e) {
            Debug.error("RpfFrame: getColortable(): file " + framePath + " not found");
        }
        catch (IOException ioe) {
            Debug.error("RpfFrame: getColortable(); File IO Error!\n" + ioe);
        }
        return null;
    }

    public RpfColortable getColortable() {
        return this.colortable;
    }

    public boolean read(BinaryFile binFile) {
        LookupTable[] lookupTable = new LookupTable[4];
        int[][] indices = new int[6][6];
        long[][] subframeOffset = new long[6][6];
        if (this.DEBUG_RPFDETAIL) {
            Debug.output("ENTER RPFFRAME.READ");
        }
        try {
            int j;
            long currentPos;
            int i;
            binFile.seek(0L);
            this.nitfHeader = new NitfHeader();
            if (!this.nitfHeader.read(binFile)) {
                binFile.seek(0L);
            }
            this.header = new RpfHeader();
            if (!this.header.readHeader(binFile)) {
                return false;
            }
            if (!this.header.standardDate.startsWith("199") && !this.header.standardDate.startsWith("20")) {
                Debug.output("RpfFrame.read: Invalid date in header: " + this.header.standardDate);
                return false;
            }
            binFile.seek(this.header.locationSectionLocation);
            this.fileSections = new RpfFileSections(binFile);
            RpfFileSections.RpfLocationRecord[] loc = this.fileSections.getLocations(8);
            this.attributes = this.fileSections.parseAttributes(binFile);
            this.coverage = this.fileSections.parseCoverageSection(binFile);
            this.colortable = new RpfColortable();
            this.getColors(binFile, this.colortable);
            if (loc[0] == null) {
                Debug.output("RpfFrame: No compression section!");
                return false;
            }
            binFile.seek(loc[0].componentLocation);
            Compression compression = new Compression(binFile);
            if (this.DEBUG_RPFDETAIL) {
                Debug.output(compression.toString());
            }
            if (loc[2] == null) {
                Debug.output("Warning: Can't find compr. lookup subsection in FrameFile:");
                Debug.output("   Using alternate computation");
                binFile.seek(loc[0].componentLocation + 10L);
            } else {
                if (this.DEBUG_RPFDETAIL) {
                    Debug.output("Comp lkup subsect: loc[2].componentLocation(264?): " + loc[2].componentLocation);
                }
                binFile.seek(loc[2].componentLocation);
            }
            long lookupOffsetTableOffset = binFile.readInteger();
            short lookupTableOffsetRecLen = binFile.readShort();
            if (this.DEBUG_RPFDETAIL) {
                Debug.output("lookupOffsetTableOffset(6): " + lookupOffsetTableOffset);
                Debug.output("lookupTableOffsetRecLen(14): " + lookupTableOffsetRecLen);
            }
            for (i = 0; i < 4; ++i) {
                lookupTable[i] = new LookupTable(binFile);
                if (this.DEBUG_RPFDETAIL) {
                    Debug.output("Compression lookup table offset record " + i);
                    Debug.output(lookupTable[i].toString());
                }
                if (lookupTable[i].records == 4096L && lookupTable[i].values == 4 && lookupTable[i].bitLength == 8) continue;
                Debug.output("RpfFrame: Bad VQ info in compression record");
                return false;
            }
            for (i = 0; i < 4; ++i) {
                binFile.seek(loc[2].componentLocation + lookupTable[i].offset);
                if (this.DEBUG_RPFDETAIL) {
                    currentPos = binFile.getFilePointer();
                    Debug.output("Read compr. lookup table (4x4096) at position: " + currentPos);
                }
                for (j = 0; j < 4096; ++j) {
                    this.table[i][j] = binFile.readBytes(4, false);
                }
            }
            if (this.Dchum && this.chumVersion > 1) {
                if (loc[6] == null) {
                    Debug.output("RpfFrame: Can't find ATTRIBUTE_SUBHEADER section!");
                    return false;
                }
                if (this.DEBUG_RPFDETAIL) {
                    Debug.output("ATTRIBUTE SUBHEADER location: " + loc[6].componentLocation);
                }
                binFile.seek(loc[6].componentLocation);
                int numAttributeOffsetRecs = binFile.readShort();
                if (this.DEBUG_RPFDETAIL) {
                    Debug.output("numAttributeOffsetRecs: " + numAttributeOffsetRecs);
                }
                if (loc[7] == null) {
                    Debug.output("RpfFrame: Can't find ATTRIBUTE_SECTION in Frame file");
                    return false;
                }
                if (this.DEBUG_RPFDETAIL) {
                    Debug.output("ATTRIBUTE SECTION location: " + loc[7].componentLocation);
                }
                binFile.seek(loc[7].componentLocation);
                this.descCount = 0;
                for (i = 0; i < numAttributeOffsetRecs; ++i) {
                    long fsave;
                    short attributeId = binFile.readShort();
                    int attributeParamId = binFile.read();
                    binFile.read();
                    long attributeRecOffset = binFile.readInteger();
                    if (attributeId == 24 && attributeParamId == 4) {
                        fsave = binFile.getFilePointer();
                        binFile.seek(loc[7].componentLocation + attributeRecOffset);
                        int numSubframesChummed = binFile.readShort();
                        if (this.DEBUG_RPFDETAIL) {
                            Debug.output("n_attrib_chummedSubframe: " + numSubframesChummed);
                        }
                        for (j = 0; j < numSubframesChummed; ++j) {
                            short chummedSubframe = binFile.readShort();
                            if (this.DEBUG_RPFDETAIL) {
                                Debug.output("chummedSubframe: " + chummedSubframe);
                            }
                            this.chummed[chummedSubframe / 6][chummedSubframe % 6] = true;
                        }
                        binFile.seek(fsave);
                    }
                    if (attributeId == 24 && attributeParamId == 3) {
                        fsave = binFile.getFilePointer();
                        binFile.seek(loc[7].componentLocation + attributeRecOffset);
                        this.descriptorDates[this.descCount] = binFile.readFixedLengthString(8);
                        if (this.DEBUG_RPFDETAIL) {
                            Debug.output("descriptorDate: " + this.descriptorDates[this.descCount]);
                        }
                        binFile.seek(fsave);
                    }
                    if (attributeId != 24 || attributeParamId != 6) continue;
                    fsave = binFile.getFilePointer();
                    binFile.seek(loc[7].componentLocation + attributeRecOffset);
                    this.numCharsInDesc = binFile.readShort();
                    if (this.DEBUG_RPFDETAIL) {
                        Debug.output("Prepare to fread descriptors[descCount]");
                        Debug.output("RpfFrame.read: descCount: " + this.descCount);
                    }
                    this.descriptors[this.descCount] = binFile.readFixedLengthString(this.numCharsInDesc);
                    if (this.DEBUG_RPFDETAIL) {
                        Debug.output("descriptors[descCount]: " + this.descriptors[this.descCount]);
                    }
                    ++this.descCount;
                    binFile.seek(fsave);
                }
            }
            if (this.DEBUG_RPFDETAIL) {
                Debug.output("Image descr. subheader location: loc[1].componentLocation(68576?): " + loc[1].componentLocation);
            }
            binFile.seek(loc[1].componentLocation);
            Image image = new Image(binFile);
            long subframeMaskTableOffset = binFile.readInteger();
            if (this.DEBUG_RPFDETAIL) {
                Debug.output(image.toString());
                Debug.output("subframeMaskTableOffset: " + subframeMaskTableOffset);
            }
            if (subframeMaskTableOffset == 0L) {
                Debug.error("RpfFrame.read(): subframeMaskTableOffset==0.");
                return false;
            }
            boolean allSubframes = subframeMaskTableOffset == -1L;
            if (Debug.debugging("rpfframe")) {
                Debug.output("allSubframes: " + allSubframes);
            }
            if (!allSubframes) {
                if (loc[5] == null) {
                    Debug.error("RpfFrame.read(): Can't find MASK_SUBSECTION section in Frame file");
                    return false;
                }
                if (this.DEBUG_RPFDETAIL) {
                    Debug.output("MASK SUBSECTION location: " + loc[5].componentLocation);
                }
                binFile.seek(loc[5].componentLocation + subframeMaskTableOffset);
                for (i = 0; i < 6; ++i) {
                    for (j = 0; j < 6; ++j) {
                        subframeOffset[i][j] = binFile.readInteger();
                        if (subframeOffset[i][j] == -1L) {
                            this.masked[i][j] = true;
                        }
                        if (!this.DEBUG_RPFDETAIL) continue;
                        Debug.output("i:" + i + ", j:" + j + ", masked[i][j]: " + this.masked[i][j]);
                    }
                }
            }
            if (image.vertSubframes != 6 || image.horizSubframes != 6) {
                Debug.output("Not 6x6 subframes per frame: must be masked.");
            }
            if (loc[4] == null) {
                Debug.error("RpfFrame.read(): Can't find IMAGE_DISPLAY_PARAM_SUBHEADER section!");
                return false;
            }
            if (this.DEBUG_RPFDETAIL) {
                Debug.output("IMAGE Display params subheader location: " + loc[4].componentLocation);
            }
            binFile.seek(loc[4].componentLocation);
            if (loc[3] == null) {
                Debug.output("WARNING: Can't find Image spatial data subsection in FrameFile:");
                Debug.output("   Using alternate computation");
                binFile.seek(loc[4].componentLocation + 14L);
            } else {
                currentPos = binFile.getFilePointer();
                if (this.DEBUG_RPFDETAIL) {
                    Debug.output("Current frame file position(68595?): " + currentPos);
                    Debug.output("Image spatial data subsect: loc[3](68609?): " + loc[3].componentLocation);
                }
                binFile.seek(loc[3].componentLocation);
            }
            for (i = 0; i < 6; ++i) {
                for (j = 0; j < 6; ++j) {
                    indices[i][j] = i * 6 + j;
                    if (!this.masked[i][j]) {
                        this.compressedSubframe[i][j] = binFile.readBytes(6144, false);
                        if (!this.DEBUG_RPFDETAIL) continue;
                        Debug.output(" i:" + i + ", j:" + j + ", read image data. rc(6144):" + this.compressedSubframe[i][j].length);
                        continue;
                    }
                    this.compressedSubframe[i][j] = new byte[6144];
                }
            }
        }
        catch (IOException e) {
            Debug.error("RpfFrame: read(): File IO Error!\n" + e);
            return false;
        }
        catch (FormatException f) {
            Debug.error("RpfFrame: read(): File IO Format error!" + f);
            return false;
        }
        if (this.DEBUG_RPFDETAIL) {
            Debug.output("LEAVE RPFFRAME.READ");
        }
        this.valid = true;
        return this.valid;
    }

    public RpfSubframe decompressSubframe(int x, int y, RpfSubframe subframe, RpfColortable colortable, RpfViewAttributes viewAttributes) {
        boolean isDirectColorModel;
        boolean bl = isDirectColorModel = viewAttributes.colorModel == 0;
        if (subframe == null) {
            subframe = new RpfSubframe();
        }
        if (viewAttributes != null) {
            subframe.setColorModel(viewAttributes.colorModel);
        }
        if (colortable == null) {
            colortable = this.colortable;
        }
        if (!isDirectColorModel) {
            if (this.DEBUG_RPFDETAIL) {
                Debug.output("RpfFrame: decompress to byte[]");
            }
            byte[] pixels = this.decompressSubframe(x, y);
            OMScalingRaster image = subframe.image;
            image.setBits(pixels);
            image.setColors(colortable.colors);
        } else {
            int[] pixels = this.decompressSubframe(x, y, colortable);
            OMScalingRaster image = subframe.image;
            image.setPixels(pixels);
        }
        return subframe;
    }

    public byte[] decompressSubframe(int x, int y) {
        int readptr = 0;
        byte[] compressedSubframe = this.compressedSubframe[y %= 6][x %= 6];
        if (compressedSubframe == null || this.masked[y][x]) {
            return null;
        }
        byte[] pixels = new byte[65536];
        for (int i = 0; i < 256; i += 4) {
            for (int j = 0; j < 256; j += 8) {
                int firstByte = compressedSubframe[readptr++] & 0xFF;
                int secondByte = compressedSubframe[readptr++] & 0xFF;
                int thirdByte = compressedSubframe[readptr++] & 0xFF;
                int val1 = firstByte << 4 | secondByte >> 4;
                int val2 = (secondByte & 0xF) << 8 | thirdByte;
                for (int t = 0; t < 4; ++t) {
                    for (int e = 0; e < 4; ++e) {
                        int tableVal1 = this.table[t][val1][e] & 0xFF;
                        int tableVal2 = this.table[t][val2][e] & 0xFF;
                        if (tableVal1 >= 216) {
                            tableVal1 = 215;
                        }
                        if (tableVal2 >= 216) {
                            tableVal2 = 215;
                        }
                        int pixindex = (i + t) * 256 + j + e;
                        pixels[pixindex] = (byte)tableVal1;
                        pixels[pixindex + 4] = (byte)tableVal2;
                    }
                }
            }
        }
        return pixels;
    }

    public int[] decompressSubframe(int x, int y, RpfColortable colortable) {
        int readptr = 0;
        byte[] compressedSubframe = this.compressedSubframe[y %= 6][x %= 6];
        if (colortable == null) {
            colortable = this.colortable;
        }
        if (compressedSubframe == null || this.masked[y][x]) {
            return null;
        }
        int[] pixels = new int[65536];
        for (int i = 0; i < 256; i += 4) {
            for (int j = 0; j < 256; j += 8) {
                int firstByte = compressedSubframe[readptr++] & 0xFF;
                int secondByte = compressedSubframe[readptr++] & 0xFF;
                int thirdByte = compressedSubframe[readptr++] & 0xFF;
                int val1 = firstByte << 4 | secondByte >> 4;
                int val2 = (secondByte & 0xF) << 8 | thirdByte;
                for (int t = 0; t < 4; ++t) {
                    for (int e = 0; e < 4; ++e) {
                        int tableVal1 = this.table[t][val1][e] & 0xFF;
                        int tableVal2 = this.table[t][val2][e] & 0xFF;
                        if (tableVal1 >= 216) {
                            tableVal1 = 215;
                        }
                        if (tableVal2 >= 216) {
                            tableVal2 = 215;
                        }
                        int pixindex = (i + t) * 256 + j + e;
                        pixels[pixindex] = colortable.colors[tableVal1].getRGB();
                        pixels[pixindex + 4] = colortable.colors[tableVal2].getRGB();
                    }
                }
            }
        }
        return pixels;
    }

    public static void main(String[] argv) {
        Debug.init();
        ArgParser ap = new ArgParser("RpfFrame");
        ap.add("attributes", "Only write out the attributes for this frame.");
        ap.add("view", "Only bring up a window with the frame image.");
        ap.add("frame", "Path to the frame to view. \"-frame\" only needed if other arguments are used.", 1);
        if (!ap.parse(argv)) {
            ap.printUsage();
            System.exit(0);
        }
        boolean viewAttributes = false;
        String[] arg = ap.getArgValues("attributes");
        if (arg != null) {
            viewAttributes = true;
            Debug.put("rpfframe");
            Debug.put("rpfdetail");
        }
        boolean viewFrame = false;
        arg = ap.getArgValues("view");
        if (arg != null) {
            viewFrame = true;
        }
        if ((arg = ap.getArgValues("frame")) != null) {
            RpfFrame rpfFrame = new RpfFrame(arg[0]);
            if (viewFrame) {
                rpfFrame.view();
            }
        } else {
            if (!viewAttributes) {
                Debug.put("rpfframe");
                Debug.put("rpfdetail");
            }
            RpfFrame rpfFrame = new RpfFrame(argv[0]);
            rpfFrame.view();
        }
    }

    public void view() {
        int height = 256;
        int width = 256;
        BufferedImage bigImage = new BufferedImage(width * 6, height * 6, 1);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Graphics2D g = ge.createGraphics(bigImage);
        Toolkit tk = Toolkit.getDefaultToolkit();
        for (int x = 0; x < 6; ++x) {
            for (int y = 0; y < 6; ++y) {
                int[] pixels = this.decompressSubframe(x, y, this.colortable);
                java.awt.Image bitmap = tk.createImage(new MemoryImageSource(width, height, pixels, 0, width));
                g.drawImage(bitmap, x * 256, y * 256, null);
            }
        }
        JLabel picture = new JLabel(new ImageIcon(bigImage));
        JFrame frame = PaletteHelper.getPaletteWindow(picture, "RPF Frame", null);
        frame.setSize(new Dimension(500, 500));
        frame.setVisible(true);
    }

    public static class Image {
        int spectralGroups;
        int subframeTables;
        int spectralTables;
        int spectralLines;
        int horizSubframes;
        int vertSubframes;
        long outputColumns;
        long outputRows;

        public Image(BinaryFile binFile) {
            try {
                this.spectralGroups = binFile.readShort();
                this.subframeTables = binFile.readShort();
                this.spectralTables = binFile.readShort();
                this.spectralLines = binFile.readShort();
                this.horizSubframes = binFile.readShort();
                this.vertSubframes = binFile.readShort();
                this.outputColumns = binFile.readInteger();
                this.outputRows = binFile.readInteger();
            }
            catch (IOException e) {
                Debug.error("Compression: File IO Error!\n" + e);
            }
            catch (FormatException f) {
                Debug.error("Compression: File IO Format error!\n" + f);
            }
        }

        public String toString() {
            StringBuffer s = new StringBuffer();
            s.append("Image.spectralGroups: " + this.spectralGroups + "\n");
            s.append("Image.subframeTables: " + this.subframeTables + "\n");
            s.append("Image.spectralTables: " + this.spectralTables + "\n");
            s.append("Image.spectralLines: " + this.spectralLines + "\n");
            s.append("Image.horizSubframes: " + this.horizSubframes + "\n");
            s.append("Image.vertSubframes: " + this.vertSubframes + "\n");
            s.append("Image.outputColumns: " + this.outputColumns + "\n");
            s.append("Image.outputRows: " + this.outputRows + "\n");
            return s.toString();
        }
    }

    public static class LookupTable {
        int id;
        long records;
        int values;
        int bitLength;
        long offset;

        public LookupTable(BinaryFile binFile) {
            try {
                this.id = binFile.readShort();
                this.records = binFile.readInteger();
                this.values = binFile.readShort();
                this.bitLength = binFile.readShort();
                this.offset = binFile.readInteger();
            }
            catch (IOException e) {
                Debug.error("Compression: File IO Error!\n" + e);
            }
            catch (FormatException f) {
                Debug.error("Compression: File IO Format error!\n" + f);
            }
        }

        public String toString() {
            StringBuffer s = new StringBuffer();
            s.append("LookupTable.id: " + this.id + "\n");
            s.append("LookupTable.records: " + this.records + "\n");
            s.append("LookupTable.values: " + this.values + "\n");
            s.append("LookupTable.bitLength: " + this.bitLength + "\n");
            s.append("LookupTable.offset: " + this.offset + "\n");
            return s.toString();
        }
    }

    public static class Compression {
        public int algorithm;
        public int numOffsetRecs;
        public int numParmOffRecs;

        public Compression(BinaryFile binFile) {
            try {
                this.algorithm = binFile.readShort();
                this.numOffsetRecs = binFile.readShort();
                this.numParmOffRecs = binFile.readShort();
            }
            catch (IOException e) {
                Debug.error("Compression: File IO Error!\n" + e);
            }
            catch (FormatException f) {
                Debug.error("Compression: File IO Format error!\n" + f);
            }
        }

        public String toString() {
            StringBuffer s = new StringBuffer();
            s.append("Compression.algorithm: " + this.algorithm + "\n");
            s.append("Compression.numOffsetRecs: " + this.numOffsetRecs + "\n");
            s.append("Compression.numParmOffRecs: " + this.numParmOffRecs + "\n");
            return s.toString();
        }
    }
}

