/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.plotLayer;

import com.bbn.openmap.Environment;
import com.bbn.openmap.event.MapMouseListener;
import com.bbn.openmap.event.SelectMouseMode;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.plotLayer.GLOBESite;
import com.bbn.openmap.layer.plotLayer.GLOBETempData;
import com.bbn.openmap.layer.plotLayer.ScatterGraph;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PaletteHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JPanel;

public class PlotLayer
extends OMGraphicHandlerLayer
implements MapMouseListener {
    private ScatterGraph graph = null;
    private boolean show_plot_ = false;
    private OMGraphic selectedGraphic;
    private Vector selectedGraphics = null;
    private String datasource = "AT.gst_small.txt";
    private GLOBETempData temperature_data = null;
    private JPanel pal = null;
    protected int plotX = 100;
    protected int plotY = 100;
    protected int plotWidth = 320;
    protected int plotHeight = 200;
    private int prevX;
    private int prevY;
    private boolean grabbed_plot_graphics_ = false;

    public PlotLayer() {
        this.getDataSource();
        this.graph = new ScatterGraph(678, 790, null, this.temperature_data.overall_min_year_, this.temperature_data.overall_max_year_, this.temperature_data.overall_min_temp_, this.temperature_data.overall_max_temp_);
        this.setList(this.plotDataSources());
    }

    public synchronized OMGraphicList prepare() {
        this.graph.resize(this.plotX, this.plotY, this.plotWidth, this.plotHeight);
        return super.prepare();
    }

    private GLOBETempData getDataSource() {
        if (this.temperature_data != null) {
            return this.temperature_data;
        }
        Vector dirs = Environment.getClasspathDirs();
        FileInputStream is = null;
        int nDirs = dirs.size();
        if (nDirs > 0) {
            for (int i = 0; i < nDirs; ++i) {
                String dir = (String)dirs.elementAt(i);
                File datafile = new File(dir, this.datasource);
                if (!datafile.isFile()) continue;
                try {
                    is = new FileInputStream(datafile);
                    break;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (is == null) {
                System.err.println("Unable to load datafile \"" + this.datasource + "\" from CLASSPATH");
            }
        } else {
            System.err.println("No directories in CLASSPATH!");
            System.err.println("Unable to load datafile \"" + this.datasource + "\" from CLASSPATH");
        }
        if (is == null) {
            return null;
        }
        try {
            this.temperature_data = new GLOBETempData();
            this.temperature_data.loadData(is);
        }
        catch (IOException e) {
            System.err.println(e);
        }
        return this.temperature_data;
    }

    private OMGraphicList plotDataSources() {
        Debug.message("basic", "PlotLayer.plotDataSources()");
        int num_graphics = 0;
        OMGraphicList graphics = new OMGraphicList();
        graphics.setTraverseMode(0);
        graphics.clear();
        Enumeration site_enum = this.temperature_data.getAllSites();
        while (site_enum.hasMoreElements()) {
            GLOBESite site = (GLOBESite)site_enum.nextElement();
            graphics.addOMGraphic(site.getGraphic());
            ++num_graphics;
        }
        Debug.message("basic", "Plotlayer found " + num_graphics + " distinct sites");
        return graphics;
    }

    private OMGraphic generatePlot() {
        if (this.graph != null) {
            this.graph.setDataPoints(this.selectedGraphics);
            this.graph.plotData();
            return this.graph.getPlotGraphics();
        }
        return null;
    }

    private void showPlot() {
        this.show_plot_ = true;
        OMGraphic plot = this.generatePlot();
        OMGraphicList list = this.getList();
        if (plot != null) {
            list.addOMGraphic(plot);
        }
        list.generate(this.getProjection(), false);
        this.repaint();
    }

    private void hidePlot() {
        this.show_plot_ = false;
        if (this.graph != null) {
            OMGraphicList plot = this.graph.getPlotGraphics();
            OMGraphicList list = this.getList();
            if (list != null && plot != null) {
                list.remove(plot);
            }
        }
        this.repaint();
    }

    private void addSelectionToPlotList() {
        if (this.selectedGraphic != null) {
            Object app_obj;
            this.selectedGraphic.setLinePaint(Color.blue);
            if (this.selectedGraphics == null) {
                this.selectedGraphics = new Vector();
            }
            if ((app_obj = this.selectedGraphic.getAppObject()) instanceof GLOBESite) {
                GLOBESite site = (GLOBESite)app_obj;
                if (!this.selectedGraphics.contains(app_obj)) {
                    Debug.message("basic", "Adding to plot list...");
                    this.selectedGraphics.addElement(site);
                    this.selectedGraphic.setFillPaint(Color.yellow);
                } else {
                    Debug.message("basic", "Removing from plot list...");
                    this.selectedGraphics.removeElement(site);
                    this.selectedGraphic.setFillPaint(Color.red);
                    this.selectedGraphic.setLinePaint(Color.red);
                }
            }
        } else {
            Debug.message("basic", "Nothing to add to plot list!");
        }
    }

    public MapMouseListener getMapMouseListener() {
        return this;
    }

    public Component getGUI() {
        if (this.pal == null) {
            ActionListener al = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int index = Integer.parseInt(e.getActionCommand(), 10);
                    switch (index) {
                        case 0: {
                            if (PlotLayer.this.show_plot_) {
                                PlotLayer.this.hidePlot();
                                break;
                            }
                            PlotLayer.this.showPlot();
                            break;
                        }
                        default: {
                            throw new RuntimeException("argh!");
                        }
                    }
                }
            };
            this.pal = PaletteHelper.createCheckbox("Plot Control", new String[]{"Show Temperature Plot"}, new boolean[]{this.show_plot_}, al);
        }
        return this.pal;
    }

    public String[] getMouseModeServiceList() {
        return new String[]{SelectMouseMode.modeID};
    }

    public boolean mousePressed(MouseEvent e) {
        if (this.show_plot_ && this.graph != null) {
            int x = e.getX();
            int y = e.getY();
            if (x >= this.plotX && x <= this.plotX + this.plotWidth && y >= this.plotY && y <= this.plotY + this.plotWidth) {
                this.grabbed_plot_graphics_ = true;
                this.prevX = x;
                this.prevY = y;
            }
        }
        return false;
    }

    public boolean mouseReleased(MouseEvent e) {
        this.grabbed_plot_graphics_ = false;
        return false;
    }

    public boolean mouseClicked(MouseEvent e) {
        if (this.selectedGraphic != null && !this.show_plot_) {
            switch (e.getClickCount()) {
                case 1: {
                    this.addSelectionToPlotList();
                    this.generatePlot();
                    this.repaint();
                    break;
                }
                case 2: {
                    this.repaint();
                    break;
                }
            }
            return true;
        }
        return false;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public boolean mouseDragged(MouseEvent e) {
        if (this.grabbed_plot_graphics_) {
            int x = e.getX();
            int y = e.getY();
            int dx = x - this.prevX;
            int dy = y - this.prevY;
            this.plotX += dx;
            this.plotY += dy;
            this.prevX = x;
            this.prevY = y;
            this.graph.resize(this.plotX, this.plotY, this.plotWidth, this.plotHeight);
            OMGraphicList plotGraphics = this.graph.getPlotGraphics();
            plotGraphics.generate(this.getProjection(), true);
            this.repaint();
        }
        return false;
    }

    public boolean mouseMoved(MouseEvent e) {
        if (this.show_plot_ && this.graph != null) {
            OMGraphic newSelectedGraphic = this.graph.selectPoint(e.getX(), e.getY(), 4.0f);
            if (newSelectedGraphic != null) {
                String infostring = (String)newSelectedGraphic.getAppObject();
                if (infostring != null) {
                    this.fireRequestInfoLine(infostring);
                }
            } else {
                this.fireRequestInfoLine("");
            }
        } else {
            OMGraphic newSelectedGraphic = this.getList().selectClosest(e.getX(), e.getY(), 4.0f);
            if (newSelectedGraphic != null && (this.selectedGraphic == null || newSelectedGraphic != this.selectedGraphic)) {
                Debug.message("basic", "Making selection...");
                this.selectedGraphic = newSelectedGraphic;
                this.selectedGraphic.regenerate(this.getProjection());
                GLOBESite site = (GLOBESite)newSelectedGraphic.getAppObject();
                if (site != null) {
                    this.fireRequestInfoLine(site.getInfo());
                }
                this.repaint();
            } else if (this.selectedGraphic != null && newSelectedGraphic == null) {
                Debug.message("basic", "Clearing selection...");
                this.selectedGraphic.regenerate(this.getProjection());
                this.fireRequestInfoLine("");
                this.selectedGraphic = null;
                this.repaint();
            }
        }
        return true;
    }

    public void mouseMoved() {
        this.getList().deselectAll();
        this.repaint();
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
    }
}

