/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.link;

import com.bbn.openmap.layer.link.Link;
import com.bbn.openmap.layer.link.LinkActionConstants;
import com.bbn.openmap.layer.link.LinkProperties;
import com.bbn.openmap.layer.link.LinkPropertiesConstants;
import com.bbn.openmap.layer.link.LinkUtil;
import com.bbn.openmap.util.Debug;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;

public class LinkActionRequest
implements LinkActionConstants,
LinkPropertiesConstants {
    protected int x = 0;
    protected int y = 0;
    protected float lat = 0.0f;
    protected float lon = 0.0f;
    protected int clickCount = 0;
    protected int modifiers = 0;
    protected char key;
    protected int descriptor = 0;
    protected String id = null;
    protected LinkProperties properties = null;
    String linkStatus = "\r";
    protected static float version = 0.6f;

    public LinkActionRequest(Link link) throws IOException {
        this.linkStatus = this.read(link);
    }

    public LinkActionRequest(Link link, int descriptor, String sectionEnder) throws IOException {
        link.start("<AR>");
        link.dos.writeFloat(version);
        descriptor = LinkUtil.setMask(descriptor, 1024);
        link.dos.writeInt(descriptor);
        link.end(sectionEnder);
    }

    public String getType() {
        return "<AR>";
    }

    public String getLinkStatus() {
        return this.linkStatus;
    }

    public static void write(int descriptor, MouseEvent me, float latPoint, float lonPoint, LinkProperties props, Link link) throws IOException {
        if (props.getProperty("gid") != null) {
            descriptor = LinkUtil.setMask(descriptor, 512);
        }
        link.start("<AR>");
        link.dos.writeFloat(version);
        link.dos.writeInt(descriptor);
        link.dos.writeInt(me.getX());
        link.dos.writeInt(me.getY());
        link.dos.writeInt(me.getClickCount());
        link.dos.writeInt(me.getModifiers());
        link.dos.writeFloat(latPoint);
        link.dos.writeFloat(lonPoint);
        props.write(link);
        link.end("\r");
    }

    public static void write(int descriptor, KeyEvent ke, LinkProperties props, Link link) throws IOException {
        link.start("<AR>");
        link.dos.writeFloat(version);
        link.dos.writeInt(descriptor);
        link.dos.writeChar(ke.getKeyChar());
        link.dos.writeInt(ke.getModifiers());
        props.write(link);
        link.end("\r");
    }

    public String read(Link link) throws IOException {
        float ver = link.dis.readFloat();
        if (ver != version) {
            if ((double)ver == 0.1) {
                throw new IOException("LinkActionRequest: Versions do not match! DANGER!");
            }
            Debug.message("link", "LinkActionRequest: Versions do not match");
        }
        this.descriptor = link.dis.readInt();
        if (this.isClientNotification()) {
            this.descriptor = LinkUtil.unsetMask(this.descriptor, 1024);
            return link.readDelimiter(false);
        }
        if (this.isKeyEvent()) {
            this.key = link.dis.readChar();
            this.modifiers = link.dis.readInt();
        } else {
            this.x = link.dis.readInt();
            this.y = link.dis.readInt();
            this.clickCount = link.dis.readInt();
            this.modifiers = link.dis.readInt();
            this.lat = link.dis.readFloat();
            this.lon = link.dis.readFloat();
        }
        this.properties = new LinkProperties(link);
        if (LinkUtil.isMask(this.descriptor, 512)) {
            this.id = this.properties.getProperty("gid");
        }
        return link.readDelimiter(false);
    }

    public float getLat() {
        return this.lat;
    }

    public float getLon() {
        return this.lon;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public char getKey() {
        return this.key;
    }

    public int getDescriptor() {
        return this.descriptor;
    }

    public String getGraphicID() {
        return this.id;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public LinkProperties getProperties() {
        return this.properties;
    }

    protected boolean isClientNotification() {
        return (this.descriptor & 0x400) != 0;
    }

    protected boolean isKeyEvent() {
        return (this.descriptor & 0x100) != 0 || (this.descriptor & 0x80) != 0;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("LinkActionRequest:\n");
        if (this.isKeyEvent()) {
            s.append(" Key Event\n");
            s.append(" Key: " + this.key + "\n");
        } else {
            s.append(" Mouse Event\n");
            s.append(" X: " + this.x + "\n");
            s.append(" Y: " + this.y + "\n");
            s.append(" Lat: " + this.lat + "\n");
            s.append(" Lon: " + this.lon + "\n");
        }
        s.append(" Modifiers: " + this.modifiers + "\n");
        return s.toString();
    }
}

