/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.policy.ListResetPCPolicy;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMLine;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.proj.GreatCircle;
import com.bbn.openmap.proj.Length;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class ScaleDisplayLayer
extends OMGraphicHandlerLayer {
    protected Color lineColor = null;
    protected Color textColor = null;
    protected String defaultLineColorString = "FFFFFF";
    protected String defaultTextColorString = "FFFFFF";
    protected String defaultUnitOfMeasureString = "km";
    protected int defaultLocationXoffset = -10;
    protected int defaultLocationYoffset = -10;
    protected int defaultWidth = 150;
    protected int defaultHeight = 10;
    public static final String LineColorProperty = "lineColor";
    public static final String TextColorProperty = "textColor";
    public static final String UnitOfMeasureProperty = "unitOfMeasure";
    public static final String LocationXOffsetProperty = "locationXoffset";
    public static final String LocationYOffsetProperty = "locationYoffset";
    public static final String WidthProperty = "width";
    public static final String HeightProperty = "height";
    protected String unitOfMeasure = null;
    protected Length uom = Length.get(this.defaultUnitOfMeasureString);
    protected String uomAbbr = this.uom.getAbbr();
    protected int locationXoffset = this.defaultLocationXoffset;
    protected int locationYoffset = this.defaultLocationYoffset;
    protected int width = this.defaultWidth;
    protected int height = this.defaultHeight;
    Box palette;
    JRadioButton meterRadioButton;
    JRadioButton kmRadioButton;
    JRadioButton nmRadioButton;
    JRadioButton mileRadioButton;
    ButtonGroup uomButtonGroup;
    private JPanel jPanel3;
    private JPanel jPanel2;
    private JPanel jPanel1;

    public ScaleDisplayLayer() {
        this.setProjectionChangePolicy(new ListResetPCPolicy(this));
    }

    public void setProperties(String prefix, Properties properties) {
        super.setProperties(prefix, properties);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.lineColor = PropUtils.parseColorFromProperties(properties, prefix + LineColorProperty, this.defaultLineColorString);
        this.textColor = PropUtils.parseColorFromProperties(properties, prefix + TextColorProperty, this.defaultTextColorString);
        String unitOfMeasure = properties.getProperty(prefix + UnitOfMeasureProperty);
        this.setUnitOfMeasure(unitOfMeasure);
        this.locationXoffset = PropUtils.intFromProperties(properties, prefix + LocationXOffsetProperty, this.defaultLocationXoffset);
        this.locationYoffset = PropUtils.intFromProperties(properties, prefix + LocationYOffsetProperty, this.defaultLocationYoffset);
        this.width = PropUtils.intFromProperties(properties, prefix + WidthProperty, this.defaultWidth);
        this.height = PropUtils.intFromProperties(properties, prefix + HeightProperty, this.defaultHeight);
    }

    public synchronized OMGraphicList prepare() {
        int left_x = 0;
        int right_x = 0;
        int lower_y = 0;
        int upper_y = 0;
        Projection projection = this.getProjection();
        OMGraphicList graphics = new OMGraphicList();
        int w = projection.getWidth();
        int h = projection.getHeight();
        if (this.locationXoffset < 0) {
            left_x = w + this.locationXoffset - this.width;
            right_x = w + this.locationXoffset;
        } else if (this.locationXoffset >= 0) {
            left_x = this.locationXoffset;
            right_x = this.locationXoffset + this.width;
        }
        if (this.locationYoffset < 0) {
            upper_y = h + this.locationYoffset - this.height;
            lower_y = h + this.locationYoffset;
        } else if (this.locationYoffset >= 0) {
            upper_y = this.locationYoffset;
            lower_y = this.locationYoffset + this.height;
        }
        graphics.clear();
        OMLine line = new OMLine(left_x, lower_y, right_x, lower_y);
        line.setLinePaint(this.lineColor);
        graphics.add(line);
        line = new OMLine(left_x, lower_y, left_x, upper_y);
        line.setLinePaint(this.lineColor);
        graphics.add(line);
        line = new OMLine(right_x, lower_y, right_x, upper_y);
        line.setLinePaint(this.lineColor);
        graphics.add(line);
        LatLonPoint loc1 = projection.inverse(left_x, lower_y);
        LatLonPoint loc2 = projection.inverse(right_x, lower_y);
        float dist = GreatCircle.spherical_distance(loc1.radlat_, loc1.radlon_, loc2.radlat_, loc2.radlon_);
        dist = this.uom.fromRadians(dist);
        if (dist > 1.0f) {
            dist = (int)dist;
        }
        String outtext = dist + " " + this.uomAbbr;
        OMText text = new OMText((left_x + right_x) / 2, lower_y - 3, "" + outtext, 1);
        text.setLinePaint(this.textColor);
        graphics.add(text);
        graphics.generate(projection);
        return graphics;
    }

    public String getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public void setUnitOfMeasure(String unitOfMeasure) {
        if (unitOfMeasure == null) {
            unitOfMeasure = Length.KM.toString();
        }
        this.unitOfMeasure = unitOfMeasure;
        Length[] choices = Length.getAvailable();
        this.uom = null;
        for (int i = 0; i < choices.length; ++i) {
            if (!unitOfMeasure.equalsIgnoreCase(choices[i].toString()) && !unitOfMeasure.equalsIgnoreCase(choices[i].getAbbr())) continue;
            this.uom = choices[i];
            break;
        }
        if (this.uom == null) {
            this.uom = Length.KM;
        }
        this.uomAbbr = this.uom.getAbbr();
    }

    public Component getGUI() {
        if (this.palette == null) {
            if (Debug.debugging("graticule")) {
                Debug.output("GraticuleLayer: creating Graticule Palette.");
            }
            this.palette = Box.createVerticalBox();
            this.uomButtonGroup = new ButtonGroup();
            this.jPanel1 = new JPanel();
            this.jPanel2 = new JPanel();
            this.jPanel3 = new JPanel();
            this.kmRadioButton = new JRadioButton();
            this.meterRadioButton = new JRadioButton();
            this.nmRadioButton = new JRadioButton();
            this.mileRadioButton = new JRadioButton();
            this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 1));
            this.jPanel2.setBorder(new TitledBorder("Unit Of Measure"));
            this.kmRadioButton.setText("KM");
            this.kmRadioButton.setToolTipText("Kilometers");
            this.uomButtonGroup.add(this.kmRadioButton);
            this.jPanel3.add(this.kmRadioButton);
            this.meterRadioButton.setText("M");
            this.meterRadioButton.setToolTipText("Meters");
            this.uomButtonGroup.add(this.meterRadioButton);
            this.jPanel3.add(this.meterRadioButton);
            this.nmRadioButton.setText("NM");
            this.nmRadioButton.setToolTipText("Nautical Miles");
            this.uomButtonGroup.add(this.nmRadioButton);
            this.jPanel3.add(this.nmRadioButton);
            this.mileRadioButton.setText("Mile");
            this.mileRadioButton.setToolTipText("Statute Miles");
            this.uomButtonGroup.add(this.mileRadioButton);
            this.jPanel3.add(this.mileRadioButton);
            this.jPanel2.add(this.jPanel3);
            this.jPanel1.add(this.jPanel2);
            this.palette.add(this.jPanel1);
            ActionListener al = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String ac = e.getActionCommand();
                    if (ac.equalsIgnoreCase(ScaleDisplayLayer.UnitOfMeasureProperty)) {
                        JRadioButton jrb = (JRadioButton)e.getSource();
                        ScaleDisplayLayer.this.setUnitOfMeasure(jrb.getText());
                        ScaleDisplayLayer.this.doPrepare();
                    } else {
                        Debug.error("Unknown action command \"" + ac + "\" in GraticuleLayer.actionPerformed().");
                    }
                }
            };
            this.kmRadioButton.addActionListener(al);
            this.kmRadioButton.setActionCommand(UnitOfMeasureProperty);
            this.meterRadioButton.addActionListener(al);
            this.meterRadioButton.setActionCommand(UnitOfMeasureProperty);
            this.nmRadioButton.addActionListener(al);
            this.nmRadioButton.setActionCommand(UnitOfMeasureProperty);
            this.mileRadioButton.addActionListener(al);
            this.mileRadioButton.setActionCommand(UnitOfMeasureProperty);
        }
        if (this.unitOfMeasure.equalsIgnoreCase("km")) {
            this.kmRadioButton.setSelected(true);
        } else if (this.unitOfMeasure.equalsIgnoreCase("m")) {
            this.meterRadioButton.setSelected(true);
        } else if (this.unitOfMeasure.equalsIgnoreCase("nm")) {
            this.nmRadioButton.setSelected(true);
        } else if (this.unitOfMeasure.equalsIgnoreCase("mile")) {
            this.mileRadioButton.setSelected(true);
        }
        return this.palette;
    }
}

