/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.image.wms;

import com.bbn.openmap.Layer;
import com.bbn.openmap.LayerHandler;
import com.bbn.openmap.image.wms.WMSException;
import com.bbn.openmap.image.wms.WmsRequestHandler;
import com.bbn.openmap.util.Debug;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;

public class DynamicWmsRequestHandler
extends WmsRequestHandler {
    final LayerHandler mapLayerHandler;
    private final String staticLayersNames;

    public DynamicWmsRequestHandler(String scheme, String hostName, int port, String path, Properties props, LayerHandler mapLayerHandler) throws IOException, WMSException {
        super(scheme, hostName, port, path, props);
        this.mapLayerHandler = mapLayerHandler;
        this.staticLayersNames = props.getProperty("openmap.layers");
    }

    public void updateLayers() {
        Debug.message("imageserver", "OGCMRH: updateLayers updating...");
        if (this.layers == null) {
            this.layers = new Layer[0];
            Debug.message("imageserver", "OGCMRH: updateLayers layers==null, so create new layer.");
        }
        if (this.getLayerHandler() == null) {
            Debug.message("imageserver", "OGCMRH: updateLayers: LayerHandler is null.");
            return;
        }
        Layer[] newLayers = this.getLayerHandler().getLayers();
        if (this.layers.length < newLayers.length) {
            Debug.message("ms", "OGCserver: updateLayers: NEW LAYERS COMES.");
            ArrayList<Layer> tmpLayers = new ArrayList<Layer>();
            for (int j = 0; j < this.layers.length; ++j) {
                tmpLayers.add(this.layers[j]);
            }
            for (int i = 0; i < newLayers.length; ++i) {
                boolean layerAlreadyAdded = false;
                for (int j = 0; j < this.layers.length; ++j) {
                    String layerName = this.layers[j].getName();
                    String newLayerName = newLayers[i].getName();
                    if (!layerName.trim().equalsIgnoreCase(newLayerName.trim())) continue;
                    layerAlreadyAdded = true;
                }
                if (layerAlreadyAdded) continue;
                tmpLayers.add(newLayers[i]);
            }
            Layer[] newArrLayers = tmpLayers.toArray(new Layer[0]);
            this.layers = newArrLayers;
            for (int j = 0; j < this.layers.length; ++j) {
                this.layers[j].setPropertyPrefix(this.layers[j].getName());
            }
        } else {
            Debug.message("ms", "OGCserver: updateLayers: UPDATE LAYERS COMES.");
            for (int i = 0; i < newLayers.length; ++i) {
                for (int j = 0; j < this.layers.length; ++j) {
                    if (!this.layers[j].getName().trim().equalsIgnoreCase(newLayers[i].getName().trim())) continue;
                    String[] oldLayers = this.staticLayersNames.split(" ");
                    boolean found = false;
                    for (int k = 0; k < oldLayers.length; ++k) {
                        if (!oldLayers[k].equals(newLayers[i].getName().trim())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    this.layers[j] = newLayers[i];
                    this.layers[j].setPropertyPrefix(this.layers[j].getName());
                }
            }
        }
        this.createWmsLayers();
    }

    public LayerHandler getLayerHandler() {
        return this.mapLayerHandler;
    }
}

