/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.image;

import com.bbn.openmap.PropertyHandler;
import com.bbn.openmap.image.MapRequestFormatException;
import com.bbn.openmap.image.MapRequestHandler;
import com.bbn.openmap.layer.util.http.HttpConnection;
import com.bbn.openmap.layer.util.http.HttpRequestEvent;
import com.bbn.openmap.layer.util.http.HttpRequestListener;
import com.bbn.openmap.layer.util.http.HttpServer;
import com.bbn.openmap.util.ArgParser;
import com.bbn.openmap.util.Debug;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Properties;

public class SimpleHttpImageServer
implements HttpRequestListener {
    protected HttpServer httpd;
    protected MapRequestHandler iServer;
    public static final String ErrorMessage = "OpenMap SimpleHttpImageServer:  Image request not understood.  Please send request in this format:\n\nhttp://server_address/openmap?REQUEST=MAP&SCALE=XXXXXXX&LAT=y&LON=x&...\n\nArguments:\nLAT=latitude\nLON=longitude\nSCALE=1:scale\nPROJTYPE=projection ID\nHEIGHT=pixel height\nWIDTH=pixel width\n\nArguments may be in any order after the '?'";
    public static final char queryChar = '?';

    public SimpleHttpImageServer(Properties props) throws IOException {
        this(0, false, props);
    }

    public SimpleHttpImageServer(int port, boolean asDeamon, Properties props) throws IOException {
        this.httpd = new HttpServer(port, asDeamon);
        this.httpd.addHttpRequestListener(this);
        this.iServer = new MapRequestHandler(props);
    }

    public MapRequestHandler getMapRequestHandler() {
        return this.iServer;
    }

    public void setMapRequestHandler(MapRequestHandler mrh) {
        this.iServer = mrh;
    }

    public void httpRequest(HttpRequestEvent e) throws IOException {
        String request = e.getRequest();
        if (Debug.debugging("shis")) {
            Debug.output("SHIS: Handling request - \"" + request + "\"");
        }
        if (request.charAt(0) == '/') {
            request = request.substring(0, request.length());
        }
        int index = 0;
        index = request.indexOf(63);
        if (index != -1) {
            request = request.substring(index + 1, request.length());
            Debug.message("shis", "SHIS: GET Request received");
        } else {
            Debug.message("shis", "SHIS: Probably a POST Request received");
        }
        try {
            this.iServer.handleRequest(request, e.getOutputStream());
        }
        catch (IOException ioe) {
            Debug.error("SHIS: caught IOException - \n" + ioe.getMessage());
        }
        catch (MapRequestFormatException exception) {
            String message = "OpenMap SimpleHttpImageServer encountered an problem with your request:\n\n" + exception.getMessage() + "\n\n" + ErrorMessage;
            HttpConnection.writeHttpResponse(e.getOutputStream(), "text/plain", message);
        }
    }

    public static void main(String[] args) {
        Debug.init();
        try {
            SimpleHttpImageServer shis;
            String[] portarg;
            String[] proparg;
            ArgParser ap = new ArgParser("SimpleHttpImageServer");
            ap.add("properties", "A URL to use to set the properties for the ImageServer.", 1);
            ap.add("port", "The port to listen for new map image requests on. (Default 0)", 1);
            ap.add("verbose", "Print action messages.");
            ap.add("test", "Create a test default image.");
            if (!ap.parse(args)) {
                ap.printUsage();
                System.exit(0);
            }
            PropertyHandler propHandler = (proparg = ap.getArgValues("properties")) != null ? new PropertyHandler(proparg[0]) : new PropertyHandler();
            String[] varg = ap.getArgValues("verbose");
            if (varg != null) {
                Debug.put("shis");
                Debug.put("imageserver");
            }
            if ((portarg = ap.getArgValues("port")) != null) {
                int port = Integer.parseInt(portarg[0]);
                shis = new SimpleHttpImageServer(port, false, propHandler.getProperties());
            } else {
                shis = new SimpleHttpImageServer(propHandler.getProperties());
            }
            Debug.output("OpenMap SimpleHttpImageServer: listening on port: " + shis.httpd.getPort() + (proparg == null ? "" : " with properties in " + proparg[0]));
            String[] testarg = ap.getArgValues("test");
            if (testarg != null) {
                FileOutputStream out = new FileOutputStream("test.jpg");
                shis.httpRequest(new HttpRequestEvent(shis, "/openmap?REQUEST=map", out));
            }
        }
        catch (MalformedURLException murle) {
            System.err.println("Bad URL path to properties file.");
            murle.printStackTrace();
        }
        catch (IOException ioe) {
            System.err.println("Unable to start http server:");
            ioe.printStackTrace();
        }
    }
}

