/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.image;

import com.bbn.openmap.image.ColorReducer;
import com.bbn.openmap.image.ImageFormatter;
import com.bbn.openmap.image.ImageIOFormatter;
import com.bbn.openmap.util.Debug;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class PNG8ImageFormatter
extends ImageIOFormatter {
    public PNG8ImageFormatter() {
        this.setFormatName("png");
    }

    public byte[] formatImage(BufferedImage bi) {
        BufferedImage reducedImage = ColorReducer.reduce32(bi, 256);
        try {
            ByteArrayOutputStream byo = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)reducedImage, this.getFormatName(), byo);
            return byo.toByteArray();
        }
        catch (IOException e) {
            Debug.error("ImageIOFormatter caught IOException formatting image!");
            return new byte[0];
        }
    }

    public Graphics getGraphics(int width, int height) {
        return this.getGraphics(width, height, 2);
    }

    public ImageFormatter makeClone() {
        return new PNG8ImageFormatter();
    }

    public String getContentType() {
        return "image/png; mode=8bit";
    }

    public String getFormatLabel() {
        return "PNG8";
    }
}

