/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.image;

import com.bbn.openmap.Layer;
import com.bbn.openmap.image.ImageFormatter;
import com.bbn.openmap.image.ImageServer;
import com.bbn.openmap.image.ImageServerConstants;
import com.bbn.openmap.image.ImageServerUtils;
import com.bbn.openmap.image.MapRequestFormatException;
import com.bbn.openmap.layer.util.http.HttpConnection;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.ProjectionFactory;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import com.bbn.openmap.util.PropertyStringFormatException;
import java.awt.Paint;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.Properties;
import java.util.Vector;

public class MapRequestHandler
extends ImageServer
implements ImageServerConstants {
    public static final String valueSeparator = ",";
    public static final String hexSeparator = "%";
    public static final String defaultLayersProperty = "openmap.startUpLayers";
    public static final String DefaultLayersProperty = "defaultLayers";
    public static final String UseVisibilityProperty = "useLayerVisibility";
    protected String defaultLayers;
    protected Projection defaultProjection;
    protected boolean useVisibility = false;

    public MapRequestHandler(Properties props) throws IOException {
        this(null, props);
    }

    public MapRequestHandler(String prefix, Properties props) throws IOException {
        this.setProperties(prefix, props);
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.defaultProjection = this.initProjection(props);
        this.defaultLayers = props.getProperty(prefix + DefaultLayersProperty);
        if (this.defaultLayers == null) {
            this.defaultLayers = props.getProperty(defaultLayersProperty);
        }
        this.setUseVisibility(PropUtils.booleanFromProperties(props, prefix + UseVisibilityProperty, this.getUseVisibility()));
    }

    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        props.put(UseVisibilityProperty, "Flag to use layer visibility settings to determine default layers");
        return props;
    }

    public void setUseVisibility(boolean value) {
        this.useVisibility = value;
    }

    public boolean getUseVisibility() {
        return this.useVisibility;
    }

    protected Projection initProjection(Properties props) {
        this.loadProjections(props);
        Projection proj = ProjectionFactory.getDefaultProjectionFromEnvironment();
        if (Debug.debugging("imageserver")) {
            Debug.output("MRH starting with default projection = " + proj);
        }
        return proj;
    }

    protected void loadProjections(Properties props) {
        ProjectionFactory.loadDefaultProjections();
    }

    public void setDefaultProjection(Projection proj) {
        this.defaultProjection = proj;
    }

    public Projection getDefaultProjection() {
        return this.defaultProjection;
    }

    public void setDefaultLayers(String dLayers) {
        this.defaultLayers = dLayers;
    }

    public String getDefaultLayers() {
        return this.defaultLayers;
    }

    public String getAllLayerNames() {
        Layer[] layers = this.getLayers();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < layers.length; ++i) {
            sb.append((i > 0 ? " " : "") + layers[i].getPropertyPrefix());
        }
        return sb.toString();
    }

    protected Properties convertRequestToProps(String request) throws MapRequestFormatException {
        try {
            request = URLDecoder.decode(request, "UTF-8");
            Properties requestProperties = PropUtils.parsePropertyList(request);
            if (Debug.debugging("imageserver")) {
                Debug.output("MRH: parsed request " + requestProperties);
            }
            return requestProperties;
        }
        catch (PropertyStringFormatException psfe) {
            throw new MapRequestFormatException(psfe.getMessage());
        }
        catch (Exception e) {
            throw new MapRequestFormatException(e.getMessage());
        }
    }

    public byte[] handleRequest(String request) throws IOException, MapRequestFormatException {
        Properties requestProperties = this.convertRequestToProps(request);
        String requestType = requestProperties.getProperty("REQUEST");
        if (requestType != null) {
            if (requestType.equalsIgnoreCase("map")) {
                Debug.message("imageserver", "MRH: Map request...");
                return this.handleMapRequest(requestProperties);
            }
            throw new MapRequestFormatException("Request type not handled: " + requestType);
        }
        throw new MapRequestFormatException("Request not understood: " + request);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleRequest(String request, OutputStream out) throws IOException, MapRequestFormatException {
        Properties requestProperties = this.convertRequestToProps(request);
        String requestType = requestProperties.getProperty("REQUEST");
        if (requestType == null) throw new MapRequestFormatException("Request not understood: " + request);
        if (requestType.equalsIgnoreCase("map")) {
            Debug.message("imageserver", "MRH: Map request...");
            this.handleMapRequest(requestProperties, out);
            return;
        } else if (requestType.equalsIgnoreCase("capabilities")) {
            Debug.message("imageserver", "MRH: Capabilities request...");
            this.handleCapabilitiesRequest(requestProperties, out);
            return;
        } else if (requestType.equalsIgnoreCase("PAN")) {
            Debug.message("imageserver", "MRH: Pan request...");
            this.handlePanRequest(requestProperties, out);
            return;
        } else {
            if (!requestType.equalsIgnoreCase("RECENTER")) throw new MapRequestFormatException("Request type not handled: " + requestType);
            Debug.message("imageserver", "MRH: Recenter request...");
            this.handleRecenterRequest(requestProperties, out);
        }
    }

    public byte[] handleMapRequest(Properties requestProperties) throws IOException, MapRequestFormatException {
        byte[] image;
        String strLayers;
        Proj projection = ImageServerUtils.createOMProjection(requestProperties, this.defaultProjection);
        Paint bgPaint = ImageServerUtils.getBackground(requestProperties, this.getBackground());
        boolean formatFound = false;
        String format = requestProperties.getProperty("FORMAT");
        if (format != null) {
            formatFound = this.setFormatter(format.toUpperCase());
            formatFound = true;
            Debug.message("imageserver", "Format requested " + format);
        }
        if (Debug.debugging("imageserver") && (format == null || !formatFound)) {
            Debug.output("MRH: no formatter defined, using default");
        }
        if ((strLayers = requestProperties.getProperty("LAYERS")) != null) {
            Vector layers = PropUtils.parseMarkers(strLayers, valueSeparator);
            if (Debug.debugging("imageserver")) {
                Debug.output("MRH.handleMapRequest: requested layers >> " + layers);
            }
            image = this.createImage((Projection)projection, -1, -1, layers, bgPaint);
        } else if (this.getUseVisibility()) {
            if (Debug.debugging("imageserver")) {
                Debug.output("MRH.handleMapRequest: Using visibility to determine layers");
            }
            image = this.createImage((Projection)projection, -1, -1, this.calculateVisibleLayerMask(), bgPaint);
        } else {
            Vector layers = PropUtils.parseMarkers(this.defaultLayers, " ");
            if (Debug.debugging("imageserver")) {
                Debug.output("MRH.handleMapRequest: requested layers >> " + layers + " out of " + this.getAllLayerNames());
            }
            image = this.createImage((Projection)projection, -1, -1, layers, bgPaint);
        }
        return image;
    }

    public void handleMapRequest(Properties requestProperties, OutputStream out) throws IOException, MapRequestFormatException {
        String contentType;
        byte[] image = this.handleMapRequest(requestProperties);
        if (Debug.debugging("imageserver")) {
            Debug.output("MRH: have completed image, size " + image.length);
        }
        if ((contentType = this.getFormatterContentType(this.getFormatter())) == null) {
            contentType = "text/plain";
        }
        Debug.message("imageserver", "MRH: have type = " + contentType);
        HttpConnection.writeHttpResponse(out, contentType, image);
    }

    public void handlePanRequest(Properties requestProperties, OutputStream out) throws IOException, MapRequestFormatException {
        Proj projection = ImageServerUtils.createOMProjection(requestProperties, this.defaultProjection);
        String contentType = "text/plain";
        try {
            float panAzmth = Float.parseFloat(requestProperties.getProperty("AZIMUTH"));
            projection.pan(panAzmth);
        }
        catch (Exception exc) {
            Debug.output("MSH: Invalid Azimuth");
        }
        String response = (double)Math.round((double)projection.getCenter().getLatitude() * 100.0) / 100.0 + ":" + (double)Math.round((double)projection.getCenter().getLongitude() * 100.0) / 100.0;
        HttpConnection.writeHttpResponse(out, contentType, response);
    }

    public void handleRecenterRequest(Properties requestProperties, OutputStream out) throws IOException, MapRequestFormatException {
        Proj projection = ImageServerUtils.createOMProjection(requestProperties, this.defaultProjection);
        String contentType = "text/plain";
        try {
            int x = Integer.parseInt(requestProperties.getProperty("X"));
            int y = Integer.parseInt(requestProperties.getProperty("Y"));
            projection.setCenter(projection.inverse(x, y));
        }
        catch (Exception exc) {
            Debug.output("MSH: Invalid Azimuth");
        }
        String response = (double)Math.round((double)projection.getCenter().getLatitude() * 100.0) / 100.0 + ":" + (double)Math.round((double)projection.getCenter().getLongitude() * 100.0) / 100.0;
        HttpConnection.writeHttpResponse(out, contentType, response);
    }

    public String getFormatterContentType(ImageFormatter formatter) {
        String ret = null;
        String label = formatter.getFormatLabel();
        String[] knownContentTypes = HttpConnection.getAllContentTypes();
        for (int i = 0; i < knownContentTypes.length; ++i) {
            if (knownContentTypes[i].indexOf(label.toLowerCase()) == -1) continue;
            ret = knownContentTypes[i];
            break;
        }
        return ret;
    }

    public void handleCapabilitiesRequest(Properties requestProperties, OutputStream out) throws IOException, MapRequestFormatException {
        if (Debug.debugging("imageserver")) {
            Debug.output("MRH.handleCapabilitiesRequest: unimplemented");
        }
        throw new MapRequestFormatException("Capabilities request currently not handled");
    }
}

