/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.image;

import com.bbn.openmap.image.BufferedImageHelper;
import com.bbn.openmap.util.Debug;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;

public class JPEGHelper {
    private JPEGHelper() {
    }

    public static byte[] encodeJPEG(BufferedImage image, float quality) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (Debug.debugging("jpeghelper")) {
            Debug.output("Got output stream..." + out);
        }
        JPEGEncodeParam param = JPEGCodec.getDefaultJPEGEncodeParam((BufferedImage)image);
        param.setQuality(quality, true);
        if (Debug.debugging("jpeghelper")) {
            Debug.output("Got encode params...");
        }
        JPEGImageEncoder enc = JPEGCodec.createJPEGEncoder((OutputStream)out, (JPEGEncodeParam)param);
        if (Debug.debugging("jpeghelper")) {
            Debug.output("Got jpeg encoder...");
        }
        enc.encode(image);
        if (Debug.debugging("jpeghelper")) {
            Debug.output("encoded?");
        }
        return out.toByteArray();
    }

    public static byte[] encodeJPEG(int w, int h, int[] pixels, float quality) throws IOException {
        BufferedImage bi = new BufferedImage(w, h, 1);
        bi.setRGB(0, 0, w, h, pixels, 0, w);
        pixels = null;
        return JPEGHelper.encodeJPEG(bi, quality);
    }

    public static void main(String[] args) throws Exception {
        String urlsource;
        int lastslash;
        if (args.length == 0) {
            System.out.println("java jpeg url [width height]");
            System.exit(-1);
        }
        Debug.init();
        int uw = -1;
        int uh = -1;
        if (args.length > 1) {
            uw = Integer.parseInt(args[1]);
            uh = Integer.parseInt(args[2]);
        }
        lastslash = (lastslash = (urlsource = args[0]).lastIndexOf(47)) == -1 ? 0 : ++lastslash;
        int lastdot = urlsource.lastIndexOf(46);
        if (lastdot == -1) {
            lastdot = 0;
        }
        String filebase = urlsource.substring(lastslash, lastdot);
        Debug.output("url=" + urlsource + " filebase=" + filebase);
        BufferedImage bi = BufferedImageHelper.getBufferedImage(new URL(urlsource), 0, 0, uw, uh);
        if (bi == null) {
            Debug.error("JPEGHelper: Image load failed");
        } else {
            PrintStream html = new PrintStream(new FileOutputStream(new File(filebase + ".html")));
            html.println("Source url = " + urlsource + " <br>");
            html.println(" width = " + uw + " height=" + uh + " pixels=" + uw * uh + " <hr>");
            for (int i = 0; i < 20; ++i) {
                File f = new File(filebase + (i < 10 ? "0" : "") + i + ".jpg");
                float quality = 0.0499f * (float)i;
                byte[] data = JPEGHelper.encodeJPEG(bi, quality);
                FileOutputStream writef = new FileOutputStream(f);
                ((OutputStream)writef).write(data);
                ((OutputStream)writef).close();
                html.println("Image Quality Factor: " + quality + " <br>");
                html.println("Image Size (bytes) : " + data.length + " <br>");
                html.println("<img src=\"" + f.getName() + "\"> <hr>");
            }
            html.close();
        }
        System.exit(-1);
    }
}

