/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.image;

import com.bbn.openmap.util.Debug;
import java.awt.image.PixelGrabber;

public class ImageHelper {
    public static int[] grabPixels(PixelGrabber pg) {
        try {
            pg.startGrabbing();
            boolean grabbed = pg.grabPixels();
            if (!grabbed) {
                Debug.error("ImageHelper.grabPixels(): Error in loading image");
                return null;
            }
            int framebitCount = 0;
            while (true) {
                int status = pg.getStatus();
                if (Debug.debugging("image")) {
                    Debug.output("ImageHelper.grabPixels(): status = " + status);
                }
                if ((status & 0x20) != 0) break;
                if ((status & 0x10) != 0) {
                    if (framebitCount >= 20) break;
                    ++framebitCount;
                    break;
                }
                if ((status & 0x40) != 0) {
                    Debug.error("ImageHelper.grabPixels(): Error in loading image");
                    return null;
                }
                Thread.sleep(100L);
            }
            return (int[])pg.getPixels();
        }
        catch (InterruptedException ie) {
            return null;
        }
    }
}

