/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui.time;

import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.gui.time.RealTimeHandler;
import com.bbn.openmap.gui.time.TimeConstants;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;

public class TimerToggleButton
extends JToggleButton
implements PropertyChangeListener,
PropertyConsumer,
ActionListener,
TimeConstants {
    protected ImageIcon running;
    protected ImageIcon stopped;
    protected ImageIcon inactive;
    protected String DefaultRunningIconURL = "timergreen.png";
    protected String DefaultStoppedIconURL = "timerred.png";
    protected String DefaultInactiveIconURL = "timeroff.png";
    protected String runningIconURL = this.DefaultRunningIconURL;
    protected String stoppedIconURL = this.DefaultStoppedIconURL;
    protected String inactiveIconURL = this.DefaultInactiveIconURL;
    protected RealTimeHandler timeHandler;
    public static final String RunningIconProperty = "runningIcon";
    public static final String StoppedIconProperty = "stoppedIcon";
    public static final String InactiveIconProperty = "inactiveIcon";
    public static final String LabelProperty = "label";
    protected String propPrefix = null;

    public TimerToggleButton(RealTimeHandler rth) {
        this.addActionListener(this);
        this.setTimeHandler(rth);
        this.initIcons();
    }

    public void setTimeHandler(RealTimeHandler rth) {
        this.timeHandler = rth;
    }

    public RealTimeHandler getTimeHandler() {
        return this.timeHandler;
    }

    public void initIcons() {
        try {
            URL url = PropUtils.getResourceOrFileOrURL(this, this.runningIconURL);
            this.running = new ImageIcon(url);
            this.setPressedIcon(this.running);
            url = PropUtils.getResourceOrFileOrURL(this, this.stoppedIconURL);
            this.stopped = new ImageIcon(url);
            url = PropUtils.getResourceOrFileOrURL(this, this.inactiveIconURL);
            this.inactive = new ImageIcon(url);
            this.updateIcon("TIMER_INACTIVE");
        }
        catch (MalformedURLException murle) {
            Debug.error("TimerToggleButton: initIcons() bad icon.");
        }
        catch (NullPointerException npe) {
            Debug.error("TimerToggleButton: initIcons() bad icon.");
            npe.printStackTrace();
        }
    }

    protected void updateIcon(String status) {
        if (status == "TIMER_FORWARD") {
            this.setSelected(true);
            this.setIcon(this.running);
        } else {
            this.setSelected(false);
            if (status == "TIMER_STOPPED") {
                this.setIcon(this.stopped);
            } else {
                this.setIcon(this.inactive);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent pce) {
        String propName = pce.getPropertyName();
        Object obj = pce.getNewValue();
        if (propName == "TIMER_RUNNING_STATUS") {
            if (obj == "TIMER_STOPPED") {
                this.updateIcon("TIMER_STOPPED");
            } else if (obj == "TIMER_INACTIVE") {
                this.updateIcon("TIMER_INACTIVE");
            } else if (obj == "TIMER_FORWARD") {
                this.updateIcon("TIMER_FORWARD");
            }
        }
    }

    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this) {
            if (this.isSelected()) {
                this.timeHandler.startClock();
            } else {
                this.timeHandler.stopClock();
            }
        }
    }

    public void setProperties(Properties props) {
        this.setProperties(null, props);
    }

    public void setProperties(String prefix, Properties props) {
        this.setPropertyPrefix(prefix);
    }

    public Properties getProperties(Properties props) {
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        return props;
    }

    public String getPropertyPrefix() {
        return this.propPrefix;
    }

    public void setPropertyPrefix(String prefix) {
        this.propPrefix = prefix;
    }
}

