/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.graphicLoader.netmap;

import com.bbn.openmap.graphicLoader.netmap.Line;
import com.bbn.openmap.graphicLoader.netmap.Node;
import java.util.Enumeration;
import java.util.Hashtable;

public class LineCache {
    private Hashtable lineTable = null;

    public LineCache() {
        this.lineTable = new Hashtable();
    }

    public LineCache(int initialCapacity) {
        this.lineTable = new Hashtable(initialCapacity);
    }

    public void flush() {
        Enumeration list = this.elements();
        while (list.hasMoreElements()) {
            this.delete((Line)list.nextElement());
        }
    }

    public Enumeration elements() {
        return this.lineTable.elements();
    }

    public Line add(String label, int index, int shape, int color, Node node1, Node node2) {
        this.del(index);
        Line line = new Line(label, index, shape, color, node1, node2);
        this.lineTable.put(label, line);
        return line;
    }

    public void move(Node atNode) {
        Line[] lines = this.get(atNode);
        if (lines == null) {
            return;
        }
        for (int i = 0; i < lines.length; ++i) {
            lines[i].setPos(atNode);
        }
    }

    public void move(Node atNode1, Node atNode2) {
        this.move(atNode1);
        this.move(atNode2);
    }

    public Line[] get(Node atNode) {
        int count = 0;
        Line[] lines = null;
        Enumeration list = this.lineTable.elements();
        if (list == null) {
            return null;
        }
        while (list.hasMoreElements()) {
            Line line = (Line)list.nextElement();
            if (line.getNode1() != atNode && line.getNode2() != atNode) continue;
            if (count == 0) {
                lines = new Line[1];
            } else {
                Line[] newLines = new Line[lines.length + 1];
                System.arraycopy(lines, 0, newLines, 0, lines.length);
                lines = newLines;
            }
            lines[count++] = line;
        }
        return lines;
    }

    public Line get(Node atNode1, Node atNode2) {
        Enumeration list = this.lineTable.elements();
        if (list == null) {
            return null;
        }
        while (list.hasMoreElements()) {
            Line line = (Line)list.nextElement();
            if (line.getNode1() != atNode1 && line.getNode2() != atNode1 || line.getNode1() != atNode2 && line.getNode2() != atNode2) continue;
            return line;
        }
        return null;
    }

    public Line get(String label) {
        return (Line)this.lineTable.get(label);
    }

    public Line get(int index) {
        Enumeration list = this.lineTable.elements();
        if (list == null) {
            return null;
        }
        while (list.hasMoreElements()) {
            Line line = (Line)list.nextElement();
            if (line.getIndex() != index) continue;
            return line;
        }
        return null;
    }

    public void del(Node atNode) {
        Line[] lines = this.get(atNode);
        if (lines == null) {
            return;
        }
        for (int i = 0; i < lines.length; ++i) {
            this.delete(lines[i]);
        }
    }

    public void del(Line[] lines) {
        for (int i = 0; i < lines.length; ++i) {
            this.delete(lines[i]);
        }
    }

    public void del(Node atNode1, Node atNode2) {
        this.delete(this.get(atNode1, atNode2));
    }

    public void del(int index) {
        this.delete(this.get(index));
    }

    public void del(String label) {
        this.delete(this.get(label));
    }

    private void delete(Line line) {
        if (line == null) {
            return;
        }
        this.lineTable.remove(line.getLabel());
    }
}

