/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.examples.beanbox;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.event.MapMouseListener;
import com.bbn.openmap.event.SelectMouseMode;
import com.bbn.openmap.examples.beanbox.SimpleBeanContainer;
import com.bbn.openmap.examples.beanbox.SimpleBeanLayer;
import com.bbn.openmap.examples.beanbox.SimpleBeanObject;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMRasterObject;
import com.bbn.openmap.tools.beanbox.BeanBox;
import com.bbn.openmap.tools.beanbox.BeanContainer;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.beans.BeanInfo;
import java.util.Vector;

public class SimpleBeanBox
extends BeanBox
implements MapMouseListener {
    private SimpleBeanLayer layer;
    private static SimpleBeanBox thisBeanBox = null;

    public SimpleBeanBox(SimpleBeanLayer l) {
        this.layer = l;
        thisBeanBox = this;
    }

    public static SimpleBeanBox getBeanBox() {
        return thisBeanBox;
    }

    public String[] getMouseModeServiceList() {
        return new String[]{SelectMouseMode.modeID};
    }

    public boolean mousePressed(MouseEvent evt) {
        return true;
    }

    public boolean mouseReleased(MouseEvent evt) {
        return true;
    }

    public boolean mouseClicked(MouseEvent evt) {
        return true;
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public boolean mouseDragged(MouseEvent evt) {
        return true;
    }

    public boolean mouseMoved(MouseEvent evt) {
        return true;
    }

    public void mouseMoved() {
    }

    public void addBean(Object bean) {
        if (!(bean instanceof SimpleBeanObject)) {
            throw new IllegalArgumentException("not instanceof SimpleBeanObject");
        }
        this.layer.addObject((SimpleBeanObject)bean);
    }

    public void removeBean(Object bean) {
        if (!(bean instanceof SimpleBeanObject)) {
            throw new IllegalArgumentException("not instanceof SimpleBeanObject");
        }
        this.layer.removeObject(((SimpleBeanObject)bean).getId());
    }

    public boolean containsBean(Object bean) {
        if (!(bean instanceof SimpleBeanObject)) {
            throw new IllegalArgumentException("not instanceof SimpleBeanObject " + bean);
        }
        return this.layer.getObject(((SimpleBeanObject)bean).getId()) != null;
    }

    public void setBeanProperties(Object bean, BeanInfo beanInfo, Point location) {
        if (!(bean instanceof SimpleBeanObject)) {
            throw new IllegalArgumentException("not instanceof SimpleBeanObject " + bean);
        }
        SimpleBeanObject obj = (SimpleBeanObject)bean;
        Image img = beanInfo.getIcon(2);
        obj.setGraphicImage(img);
        LatLonPoint llp = this.layer.getProjection().inverse(location.x, location.y);
        obj.setLatitude(llp.getLatitude());
        obj.setLongitude(llp.getLongitude());
    }

    Vector getAllContainers() {
        Vector containers = new Vector();
        Vector list = this.layer.getObjects();
        if (list == null || list.size() == 0) {
            return containers;
        }
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            if (!(obj instanceof BeanContainer)) continue;
            containers.add(obj);
        }
        return containers;
    }

    public BeanContainer findEnclosingContainer(Object bean) {
        if (!(bean instanceof SimpleBeanObject)) {
            throw new IllegalArgumentException("not instanceof SimpleBeanObject " + bean);
        }
        SimpleBeanObject obj = (SimpleBeanObject)bean;
        float objLat = obj.getLatitude();
        float objLon = obj.getLongitude();
        LatLonPoint llp = new LatLonPoint(objLat, objLon);
        return this.findEnclosingContainer(llp);
    }

    public SimpleBeanContainer findEnclosingContainer(LatLonPoint llp) {
        Vector containers = this.getAllContainers();
        for (int i = 0; i < containers.size(); ++i) {
            SimpleBeanContainer container = (SimpleBeanContainer)containers.get(i);
            if (!this.encloses(container, llp)) continue;
            return container;
        }
        return null;
    }

    boolean encloses(SimpleBeanContainer container, LatLonPoint llp) {
        float topLat = container.getTopLatitude();
        float leftLon = container.getLeftLongitude();
        float botLat = container.getBottomLatitude();
        float rightLon = container.getRightLongitude();
        float lat = llp.getLatitude();
        float lon = llp.getLongitude();
        if (lon > rightLon || lon < leftLon) {
            return false;
        }
        return !(lat > topLat) && !(lat < botLat);
    }

    BeanContainer findContainerBean(Point pointOnMap) {
        if (this.layer != null && this.layer.getProjection() != null) {
            LatLonPoint llp = this.layer.getProjection().inverse(pointOnMap.x, pointOnMap.y);
            return this.findEnclosingContainer(llp);
        }
        return null;
    }

    SimpleBeanObject findNonContainerBean(Point pointOnMap) {
        Vector list = this.layer.getObjects();
        double minSep = Double.MAX_VALUE;
        SimpleBeanObject closest = null;
        for (int i = 0; i < list.size(); ++i) {
            Point p2;
            double sep;
            Object o = list.get(i);
            SimpleBeanObject obj = (SimpleBeanObject)o;
            if (obj instanceof SimpleBeanContainer || !((sep = this.almostEquals(pointOnMap, p2 = this.layer.getProjection().forward(new LatLonPoint(obj.getLatitude(), obj.getLongitude())), 20.0)) < minSep)) continue;
            minSep = sep;
            closest = obj;
        }
        return closest;
    }

    public Object getBeanAtLocation(Point pointOnMap) {
        SimpleBeanObject obj = this.findNonContainerBean(pointOnMap);
        if (obj != null) {
            return obj;
        }
        BeanContainer container = this.findContainerBean(pointOnMap);
        if (container != null) {
            return container;
        }
        return null;
    }

    double almostEquals(Point p1, Point p2, double tol) {
        int sepX = p1.x - p2.x;
        int sepY = p1.y - p2.y;
        double sep = Math.sqrt(sepX * sepX + sepY * sepY);
        if (sep <= tol) {
            return sep;
        }
        return Double.MAX_VALUE;
    }

    public void relocateBean(Object bean, BeanInfo beanInfo, Point newLocation) {
        if (!(bean instanceof SimpleBeanObject)) {
            throw new IllegalArgumentException("not instanceof SimpleBeanObject " + bean);
        }
        SimpleBeanObject obj = (SimpleBeanObject)bean;
        LatLonPoint llp = this.layer.getProjection().inverse(newLocation.x, newLocation.y);
        this.relocateSimpleBeanObject(obj, llp);
        this.layer.updateGraphics();
    }

    void relocateSimpleBeanObject(SimpleBeanObject obj, LatLonPoint newllp) {
        SimpleBeanContainer oldContainer = null;
        if (!(obj instanceof SimpleBeanContainer)) {
            oldContainer = (SimpleBeanContainer)this.findEnclosingContainer(obj);
        }
        if (oldContainer != null) {
            oldContainer.remove(obj);
        }
        obj.setLatitude(newllp.getLatitude());
        obj.setLongitude(newllp.getLongitude());
        if (obj instanceof SimpleBeanContainer) {
            ((SimpleBeanContainer)obj).validate();
        }
        SimpleBeanContainer newContainer = null;
        if (!(obj instanceof SimpleBeanContainer)) {
            newContainer = (SimpleBeanContainer)this.findEnclosingContainer(obj);
        }
        if (newContainer != null) {
            newContainer.add(obj);
        }
    }

    public void beanChanged(Object bean, String changedPropertyName) {
        if (!(bean instanceof SimpleBeanObject)) {
            throw new IllegalArgumentException("not instanceof SimpleBeanObject " + bean);
        }
        SimpleBeanObject obj = (SimpleBeanObject)bean;
        this.layer.updateObject(obj);
    }

    protected Image getDragImage(Object bean) {
        if (!(bean instanceof SimpleBeanObject)) {
            throw new IllegalArgumentException("not instanceof SimpleBeanObject " + bean);
        }
        SimpleBeanObject obj = (SimpleBeanObject)bean;
        OMGraphic graphic = this.layer.getGraphic(obj.getId());
        if (graphic instanceof OMRasterObject) {
            return ((OMRasterObject)graphic).getImage();
        }
        return super.getDragImage(bean);
    }
}

