/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.event;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.event.NavMouseMode2;
import com.bbn.openmap.gui.OverviewMapHandler;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class DefaultOverviewMouseMode
extends NavMouseMode2 {
    OverviewMapHandler overviewMapHandler;

    public DefaultOverviewMouseMode(OverviewMapHandler omh) {
        super(true);
        this.overviewMapHandler = omh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseReleased(MouseEvent e) {
        if (Debug.debugging("mousemode")) {
            System.out.println(this.getID() + "|DefaultOverviewMouseMode.mouseReleased()");
        }
        Object obj = e.getSource();
        if (!this.mouseSupport.fireMapMouseReleased(e)) {
            if (!(obj instanceof MapBean) || !this.autoZoom || this.point1 == null) {
                return;
            }
            MapBean map = (MapBean)obj;
            Projection projection = map.getProjection();
            DefaultOverviewMouseMode defaultOverviewMouseMode = this;
            synchronized (defaultOverviewMouseMode) {
                int deltaPix;
                float deltaDegrees;
                this.point2 = e.getPoint();
                int dx = Math.abs(this.point2.x - this.point1.x);
                int dy = Math.abs(this.point2.y - this.point1.y);
                if (dx < 5 || dy < 5) {
                    this.paintRectangle(map, this.point1, this.point2);
                    if (dx < 5 && dy < 5) {
                        LatLonPoint llp = projection.inverse(e.getPoint());
                        this.overviewMapHandler.getControlledMapListeners().setCenter(llp);
                    }
                    return;
                }
                LatLonPoint ll1 = projection.inverse(this.point1);
                LatLonPoint ll2 = projection.inverse(this.point2);
                dx = Math.abs(this.point2.x - this.point1.x);
                if (dx < (dy = Math.abs(this.point2.y - this.point1.y))) {
                    float dlat = Math.abs(ll1.getLatitude() - ll2.getLatitude());
                    deltaDegrees = dlat * 2.0f;
                    deltaPix = this.overviewMapHandler.getSourceMap().getProjection().getHeight();
                } else {
                    float lon2;
                    float lon1;
                    if (this.point1.x > this.point2.x) {
                        float lat1 = ll1.getLatitude();
                        lon1 = ll1.getLongitude();
                        ll1.setLatLon(ll2);
                        ll2.setLatLon(lat1, lon1);
                    }
                    float dlon = (lon1 = ll1.getLongitude()) > (lon2 = ll2.getLongitude()) ? 180.0f - lon1 + (180.0f + lon2) : lon2 - lon1;
                    deltaDegrees = dlon * 2.0f;
                    deltaPix = this.overviewMapHandler.getSourceMap().getProjection().getWidth();
                }
                float pixPerDegree = ((Proj)projection).getPlanetPixelCircumference() / 360.0f;
                float newScale = pixPerDegree / ((float)deltaPix / deltaDegrees);
                LatLonPoint center = projection.inverse(this.point1.x, this.point1.y);
                this.overviewMapHandler.getControlledMapListeners().setScale(newScale);
                this.overviewMapHandler.getControlledMapListeners().setCenter(center);
            }
            this.point1 = null;
            this.point2 = null;
        }
    }

    protected Point getRatioPoint(MapBean map, Point pt1, Point pt2) {
        Projection proj = this.overviewMapHandler.getSourceMap().getProjection();
        float mapRatio = (float)proj.getHeight() / (float)proj.getWidth();
        float boxHeight = pt1.y - pt2.y;
        float boxWidth = pt1.x - pt2.x;
        float boxRatio = Math.abs(boxHeight / boxWidth);
        int isNegative = -1;
        if (boxRatio > mapRatio) {
            if (boxHeight < 0.0f) {
                isNegative = 1;
            }
            boxHeight = Math.abs(mapRatio * boxWidth);
            pt2.y = pt1.y + isNegative * (int)boxHeight;
        } else if (boxRatio < mapRatio) {
            if (boxWidth < 0.0f) {
                isNegative = 1;
            }
            boxWidth = Math.abs(boxHeight / mapRatio);
            pt2.x = pt1.x + isNegative * (int)boxWidth;
        }
        return pt2;
    }
}

