/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.event;

import com.bbn.openmap.MapBean;
import com.bbn.openmap.OMComponent;
import com.bbn.openmap.event.MapMouseListener;
import com.bbn.openmap.event.MapMouseMode;
import com.bbn.openmap.event.MapMouseSupport;
import com.bbn.openmap.event.ZoomEvent;
import com.bbn.openmap.util.PropUtils;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class AbstractMouseMode
extends OMComponent
implements MapMouseMode,
Serializable {
    protected String ID = null;
    protected MapMouseSupport mouseSupport;
    protected Cursor cursor = Cursor.getDefaultCursor();
    protected transient Icon guiIcon = null;
    protected transient boolean visible = true;
    protected String prettyName;
    protected String iconName;
    protected boolean zoomWhenMouseWheelUp = true;
    public static final boolean ZOOM_IN = true;
    public static final boolean ZOOM_OUT = false;
    public static final String IDProperty = "id";
    public static final String PrettyNameProperty = "prettyName";
    public static final String CursorIDProperty = "cursorID";
    public static final String IconProperty = "icon";
    public static final String MouseWheelZoomProperty = "mouseWheelUp";

    public AbstractMouseMode() {
        this("Unnamed Mode", true);
    }

    public AbstractMouseMode(String name, boolean shouldConsumeEvents) {
        this.mouseSupport = new MapMouseSupport(this, shouldConsumeEvents);
        this.ID = name;
        this.setIconName(name + ".gif");
    }

    protected Class getClassToUseForIconRetrieval() {
        return this.getClass();
    }

    public void setIconName(String iName) {
        this.iconName = iName;
        URL url = null;
        try {
            url = PropUtils.getResourceOrFileOrURL(iName);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (url == null) {
            url = this.getClassToUseForIconRetrieval().getResource(this.iconName);
        }
        if (url != null) {
            this.guiIcon = new ImageIcon(url);
        }
    }

    public String getIconName() {
        return this.iconName;
    }

    public String getID() {
        return this.ID;
    }

    public void setID(String id) {
        this.ID = id;
    }

    public void setPrettyName(String pn) {
        this.prettyName = pn;
    }

    public String getPrettyName() {
        if (this.prettyName == null) {
            return this.i18n.get(this.getClass(), PrettyNameProperty, this.ID);
        }
        return this.prettyName;
    }

    public Cursor getModeCursor() {
        return this.cursor;
    }

    public void setModeCursor(Cursor curs) {
        this.cursor = curs;
    }

    public void setModeCursor(String cursorID) {
        if (cursorID != null) {
            try {
                int cid = Cursor.class.getField(cursorID).getInt(null);
                this.setModeCursor(Cursor.getPredefinedCursor(cid));
            }
            catch (NoSuchFieldException nsfe) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public Icon getGUIIcon() {
        return this.guiIcon;
    }

    public void setGUIIcon(Icon icon) {
        this.guiIcon = icon;
    }

    public void setConsumeEvents(boolean value) {
        this.mouseSupport.setConsumeEvents(value);
    }

    public boolean isConsumeEvents() {
        return this.mouseSupport.isConsumeEvents();
    }

    public boolean isZoomWhenMouseWheelUp() {
        return this.zoomWhenMouseWheelUp;
    }

    public void setZoomWhenMouseWheelUp(boolean zoomWhenMouseWheelUp) {
        this.zoomWhenMouseWheelUp = zoomWhenMouseWheelUp;
    }

    public void addMapMouseListener(MapMouseListener l) {
        this.mouseSupport.addMapMouseListener(l);
    }

    public void removeMapMouseListener(MapMouseListener l) {
        this.mouseSupport.removeMapMouseListener(l);
    }

    public void removeAllMapMouseListeners() {
        this.mouseSupport.removeAllMapMouseListeners();
    }

    public void mouseClicked(MouseEvent e) {
        this.mouseSupport.fireMapMouseClicked(e);
    }

    public void mousePressed(MouseEvent e) {
        e.getComponent().requestFocus();
        this.mouseSupport.fireMapMousePressed(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.mouseSupport.fireMapMouseReleased(e);
    }

    public void mouseEntered(MouseEvent e) {
        this.mouseSupport.fireMapMouseEntered(e);
    }

    public void mouseExited(MouseEvent e) {
        this.mouseSupport.fireMapMouseExited(e);
    }

    public void mouseDragged(MouseEvent e) {
        this.mouseSupport.fireMapMouseDragged(e);
    }

    public void mouseMoved(MouseEvent e) {
        this.mouseSupport.fireMapMouseMoved(e);
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        int rot = e.getWheelRotation();
        if (e.getSource() instanceof MapBean) {
            MapBean mb = (MapBean)e.getSource();
            if (rot > 0) {
                mb.zoom(new ZoomEvent(mb, 301, 1.1f));
            } else {
                mb.zoom(new ZoomEvent(mb, 301, 0.9f));
            }
        }
    }

    public void setActive(boolean active) {
    }

    public void setMouseSupport(MapMouseSupport support) {
        this.mouseSupport = support;
    }

    public MapMouseSupport getMouseSupport() {
        return this.mouseSupport;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean value) {
        this.visible = value;
    }

    public boolean actAsProxyFor(MapMouseMode mmm) {
        return this.actAsProxyFor(mmm, 0);
    }

    public boolean actAsProxyFor(MapMouseMode mmm, int pdm) {
        return this.mouseSupport.setProxyFor(mmm, pdm);
    }

    public boolean isProxyFor(MapMouseMode mmm) {
        return this.mouseSupport.isProxyFor(mmm);
    }

    public void releaseProxy() {
        this.mouseSupport.releaseProxy();
    }

    public void setProxyDistributionMask(int mask) {
        this.mouseSupport.setProxyDistributionMask(mask);
    }

    public int getProxyDistributionMask() {
        return this.mouseSupport.getProxyDistributionMask();
    }

    public void setProperties(String prefix, Properties props) {
        String idString;
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        String prettyNameString = props.getProperty(prefix + PrettyNameProperty);
        if (prettyNameString != null) {
            this.setPrettyName(prettyNameString);
        }
        if ((idString = props.getProperty(prefix + IDProperty)) != null) {
            this.setID(idString);
        }
        this.setModeCursor(props.getProperty(prefix + CursorIDProperty));
        String iconString = props.getProperty(prefix + IconProperty);
        if (iconString != null) {
            this.setIconName(iconString);
        }
        this.zoomWhenMouseWheelUp = PropUtils.booleanFromProperties(props, prefix + MouseWheelZoomProperty, this.zoomWhenMouseWheelUp);
        String zwmwu = props.getProperty(prefix + MouseWheelZoomProperty);
        if (zwmwu != null) {
            try {
                boolean zSetting = this.getClass().getField(zwmwu).getBoolean(null);
                this.setZoomWhenMouseWheelUp(zSetting);
            }
            catch (NoSuchFieldException nsfe) {
            }
            catch (IllegalAccessException iae) {
                // empty catch block
            }
        }
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        if (this.prettyName != null) {
            props.put(prefix + PrettyNameProperty, this.prettyName);
        }
        props.put(prefix + IDProperty, this.getID());
        int cursorType = this.getModeCursor().getType();
        Field[] cFields = Cursor.class.getFields();
        for (int i = 0; i < cFields.length; ++i) {
            Field f = cFields[i];
            String name = f.getName();
            if (!name.endsWith("_CURSOR")) continue;
            try {
                int testType = f.getInt(null);
                if (testType != cursorType) continue;
                props.put(prefix + CursorIDProperty, name);
                break;
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        if (this.zoomWhenMouseWheelUp) {
            props.put(prefix + MouseWheelZoomProperty, "ZOOM_IN");
        } else {
            props.put(prefix + MouseWheelZoomProperty, "ZOOM_OUT");
        }
        props.put(prefix + IconProperty, PropUtils.unnull(this.getIconName()));
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        Class<?> thisClass = this.getClass();
        String internString = this.i18n.get(thisClass, PrettyNameProperty, 3, "Presentable name for Mouse Mode.");
        props.put("addToBeanContext", internString);
        internString = this.i18n.get(thisClass, PrettyNameProperty, "Name");
        props.put("prettyName.label", internString);
        internString = this.i18n.get(thisClass, IDProperty, 3, "Internal ID for Mouse Mode, used by Layers.");
        props.put("addToBeanContext", internString);
        internString = this.i18n.get(thisClass, IDProperty, "ID");
        props.put("id.label", internString);
        PropUtils.setI18NPropertyInfo(this.i18n, props, thisClass, IconProperty, "Icon", "Icon to use for mouse mode.", null);
        PropUtils.setI18NPropertyInfo(this.i18n, props, thisClass, MouseWheelZoomProperty, "Mouse Wheel Zoom", "Action to take when the mouse wheel is rolled up.", "com.bbn.openmap.util.propertyEditor.ComboBoxPropertyEditor");
        props.put("mouseWheelUp.options", "zoomin  zoomout");
        props.put("mouseWheelUp.zoomin", "ZOOM_IN");
        props.put("mouseWheelUp.zoomout", "ZOOM_OUT");
        PropUtils.setI18NPropertyInfo(this.i18n, props, thisClass, CursorIDProperty, "Cursor", "Cursor to use for this mouse mode.", "com.bbn.openmap.util.propertyEditor.ComboBoxPropertyEditor");
        StringBuffer cOptions = new StringBuffer();
        Field[] cFields = Cursor.class.getFields();
        for (int i = 0; i < cFields.length; ++i) {
            Field f = cFields[i];
            String name = f.getName();
            if (!name.endsWith("_CURSOR")) continue;
            String cName = f.getName();
            props.put("cursorID." + cName, cName);
            cOptions.append(" " + cName);
        }
        props.put("cursorID.options", cOptions.toString().trim());
        return props;
    }

    public void listenerPaint(Graphics g) {
    }

    public static class MouseWheelZoomEditor {
    }
}

