/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.iso8211;

import com.bbn.openmap.dataAccess.iso8211.DDFConstants;
import com.bbn.openmap.dataAccess.iso8211.DDFField;
import com.bbn.openmap.dataAccess.iso8211.DDFFieldDefinition;
import com.bbn.openmap.dataAccess.iso8211.DDFRecord;
import com.bbn.openmap.io.BinaryBufferedFile;
import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.util.Debug;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;

public class DDFModule
implements DDFConstants {
    protected BinaryFile fpDDF;
    protected String fileName;
    protected long nFirstRecordOffset;
    protected byte _interchangeLevel;
    protected byte _inlineCodeExtensionIndicator;
    protected byte _versionNumber;
    protected byte _appIndicator;
    protected int _fieldControlLength;
    protected String _extendedCharSet;
    protected int _recLength;
    protected byte _leaderIden;
    protected int _fieldAreaStart;
    protected int _sizeFieldLength;
    protected int _sizeFieldPos;
    protected int _sizeFieldTag;
    protected Vector paoFieldDefns;
    protected DDFRecord poRecord;

    public DDFModule() {
        this.paoFieldDefns = null;
        this.poRecord = null;
        this.fpDDF = null;
    }

    public DDFModule(String ddfName) throws IOException {
        this.open(ddfName);
    }

    public void close() {
        if (this.fpDDF != null) {
            try {
                this.fpDDF.close();
            }
            catch (IOException ioe) {
                Debug.error("DDFModule IOException when closing DDFModule file");
            }
            this.fpDDF = null;
        }
    }

    public void destroy() {
        this.close();
        this.poRecord = null;
        this.paoFieldDefns = null;
    }

    public BinaryFile open(String pszFilename) throws IOException {
        int i;
        this.fileName = pszFilename;
        this.fpDDF = new BinaryBufferedFile(pszFilename);
        byte[] achLeader = new byte[24];
        if (this.fpDDF.read(achLeader) != 24) {
            this.destroy();
            if (Debug.debugging("iso8211")) {
                Debug.output("DDFModule: Leader is short on DDF file " + pszFilename);
            }
            return null;
        }
        boolean bValid = true;
        for (i = 0; i < 24; ++i) {
            if (achLeader[i] >= 32 && achLeader[i] <= 126) continue;
            bValid = false;
        }
        if (achLeader[5] != 49 && achLeader[5] != 50 && achLeader[5] != 51) {
            bValid = false;
        }
        if (achLeader[6] != 76) {
            bValid = false;
        }
        if (achLeader[8] != 49 && achLeader[8] != 32) {
            bValid = false;
        }
        if (bValid) {
            this._recLength = Integer.parseInt(new String(achLeader, 0, 5));
            this._interchangeLevel = achLeader[5];
            this._leaderIden = achLeader[6];
            this._inlineCodeExtensionIndicator = achLeader[7];
            this._versionNumber = achLeader[8];
            this._appIndicator = achLeader[9];
            this._fieldControlLength = Integer.parseInt(new String(achLeader, 10, 2));
            this._fieldAreaStart = Integer.parseInt(new String(achLeader, 12, 5));
            this._extendedCharSet = new String((char)achLeader[17] + "" + (char)achLeader[18] + "" + (char)achLeader[19]);
            this._sizeFieldLength = Integer.parseInt(new String(achLeader, 20, 1));
            this._sizeFieldPos = Integer.parseInt(new String(achLeader, 21, 1));
            this._sizeFieldTag = Integer.parseInt(new String(achLeader, 23, 1));
            if (this._recLength < 12 || this._fieldControlLength == 0 || this._fieldAreaStart < 24 || this._sizeFieldLength == 0 || this._sizeFieldPos == 0 || this._sizeFieldTag == 0) {
                bValid = false;
            }
            if (Debug.debugging("iso8211")) {
                Debug.output("bValid = " + bValid + ", from " + new String(achLeader));
                Debug.output(this.toString());
            }
        }
        if (!bValid) {
            this.destroy();
            if (Debug.debugging("iso8211")) {
                Debug.error("DDFModule: File " + pszFilename + " does not appear to have a valid ISO 8211 header.");
            }
            return null;
        }
        if (Debug.debugging("iso8211")) {
            Debug.output("DDFModule:  header parsed successfully");
        }
        byte[] pachRecord = new byte[this._recLength];
        System.arraycopy(achLeader, 0, pachRecord, 0, achLeader.length);
        int numNewRead = pachRecord.length - achLeader.length;
        if (this.fpDDF.read(pachRecord, achLeader.length, numNewRead) != numNewRead) {
            if (Debug.debugging("iso8211")) {
                Debug.error("DDFModule: Header record is short on DDF file " + pszFilename);
            }
            return null;
        }
        int nFieldEntryWidth = this._sizeFieldLength + this._sizeFieldPos + this._sizeFieldTag;
        int nFieldDefnCount = 0;
        for (i = 24; i < this._recLength && pachRecord[i] != 30; i += nFieldEntryWidth) {
            ++nFieldDefnCount;
        }
        this.paoFieldDefns = new Vector();
        for (i = 0; i < nFieldDefnCount; ++i) {
            if (Debug.debugging("iso8211")) {
                Debug.output("DDFModule.open: Reading field " + i);
            }
            byte[] szTag = new byte[128];
            int nEntryOffset = 24 + i * nFieldEntryWidth;
            System.arraycopy(pachRecord, nEntryOffset, szTag, 0, this._sizeFieldTag);
            int nFieldLength = Integer.parseInt(new String(pachRecord, nEntryOffset += this._sizeFieldTag, this._sizeFieldLength));
            int nFieldPos = Integer.parseInt(new String(pachRecord, nEntryOffset += this._sizeFieldLength, this._sizeFieldPos));
            byte[] subPachRecord = new byte[nFieldLength];
            System.arraycopy(pachRecord, this._fieldAreaStart + nFieldPos, subPachRecord, 0, nFieldLength);
            this.paoFieldDefns.add(new DDFFieldDefinition(this, new String(szTag, 0, this._sizeFieldTag), subPachRecord));
        }
        achLeader = null;
        pachRecord = null;
        this.nFirstRecordOffset = this.fpDDF.getFilePointer();
        return this.fpDDF;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("DDFModule:\n");
        buf.append("    _recLength = " + this._recLength + "\n");
        buf.append("    _interchangeLevel = " + this._interchangeLevel + "\n");
        buf.append("    _leaderIden = " + (char)this._leaderIden + "\n");
        buf.append("    _inlineCodeExtensionIndicator = " + this._inlineCodeExtensionIndicator + "\n");
        buf.append("    _versionNumber = " + this._versionNumber + "\n");
        buf.append("    _appIndicator = " + this._appIndicator + "\n");
        buf.append("    _extendedCharSet = " + this._extendedCharSet + "\n");
        buf.append("    _fieldControlLength = " + this._fieldControlLength + "\n");
        buf.append("    _fieldAreaStart = " + this._fieldAreaStart + "\n");
        buf.append("    _sizeFieldLength = " + this._sizeFieldLength + "\n");
        buf.append("    _sizeFieldPos = " + this._sizeFieldPos + "\n");
        buf.append("    _sizeFieldTag = " + this._sizeFieldTag + "\n");
        return buf.toString();
    }

    public String dump() {
        DDFRecord poRecord;
        StringBuffer buf = new StringBuffer(this.toString());
        int iRecord = 0;
        while ((poRecord = this.readRecord()) != null) {
            buf.append("  Record " + iRecord++ + "(" + poRecord.getDataSize() + " bytes)\n");
            Iterator it = poRecord.iterator();
            while (it.hasNext()) {
                buf.append(((DDFField)it.next()).toString());
            }
        }
        return buf.toString();
    }

    public DDFFieldDefinition findFieldDefn(String pszFieldName) {
        Iterator it = this.paoFieldDefns.iterator();
        while (it.hasNext()) {
            DDFFieldDefinition ddffd = (DDFFieldDefinition)it.next();
            String pszThisName = ddffd.getName();
            if (Debug.debugging("iso8211detail")) {
                Debug.output("DDFModule.findFieldDefn(" + pszFieldName + ":" + pszFieldName.length() + ") checking against [" + pszThisName + ":" + pszThisName.length() + "]");
            }
            if (!pszFieldName.equalsIgnoreCase(pszThisName)) continue;
            return ddffd;
        }
        return null;
    }

    public DDFRecord readRecord() {
        if (this.poRecord == null) {
            this.poRecord = new DDFRecord(this);
        }
        if (this.poRecord.read()) {
            return this.poRecord;
        }
        return null;
    }

    public int read(byte[] toData, int offset, int length) {
        if (this.fpDDF == null) {
            this.reopen();
        }
        if (this.fpDDF != null) {
            try {
                return this.fpDDF.read(toData, offset, length);
            }
            catch (IOException ioe) {
                Debug.error("DDFModule.read(): IOException caught");
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                Debug.error("DDFModule.read(): " + aioobe.getMessage() + " reading from " + offset + " to " + length + " into " + (toData == null ? "null byte[]" : "byte[" + toData.length + "]"));
                aioobe.printStackTrace();
            }
        }
        return 0;
    }

    public int read() {
        if (this.fpDDF == null) {
            this.reopen();
        }
        if (this.fpDDF != null) {
            try {
                return this.fpDDF.read();
            }
            catch (IOException ioe) {
                Debug.error("DDFModule.read(): IOException caught");
            }
        }
        return 0;
    }

    public void seek(long pos) throws IOException {
        if (this.fpDDF == null) {
            this.reopen();
        }
        if (this.fpDDF == null) {
            throw new IOException("DDFModule doesn't have a pointer to a file");
        }
        this.fpDDF.seek(pos);
    }

    public DDFFieldDefinition getField(int i) {
        if (i >= 0 || i < this.paoFieldDefns.size()) {
            return (DDFFieldDefinition)this.paoFieldDefns.elementAt(i);
        }
        return null;
    }

    public void rewind(long nOffset) throws IOException {
        if (nOffset == -1L) {
            nOffset = this.nFirstRecordOffset;
        }
        if (this.fpDDF != null) {
            this.fpDDF.seek(nOffset);
            if (nOffset == this.nFirstRecordOffset && this.poRecord != null) {
                this.poRecord.clear();
            }
        }
    }

    public void reopen() {
        try {
            if (this.fpDDF == null) {
                this.fpDDF = new BinaryBufferedFile(this.fileName);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

