/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.image;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.dataAccess.image.ErrImageTile;
import com.bbn.openmap.dataAccess.image.ErrWorldFile;
import com.bbn.openmap.dataAccess.image.ImageReader;
import com.bbn.openmap.dataAccess.image.ImageTile;
import com.bbn.openmap.dataAccess.image.WorldFile;
import com.bbn.openmap.image.BufferedImageHelper;
import com.bbn.openmap.omGraphics.OMRaster;
import com.bbn.openmap.proj.CADRG;
import com.bbn.openmap.util.PropUtils;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.stream.FileCacheImageInputStream;

public class WorldFileImageReader
implements ImageReader {
    public static Logger logger = Logger.getLogger("com.bbn.openmap.dataAccess.image.WorldFileImageReader");
    protected WorldFile worldFile;
    protected URL fileURL;

    public WorldFileImageReader(URL fileURL) throws MalformedURLException, IOException {
        this.fileURL = fileURL;
        this.worldFile = WorldFile.get(fileURL);
    }

    public BufferedImage getBufferedImage() {
        try {
            BufferedImage bi = WorldFileImageReader.getJAIImage(this.fileURL);
            if (bi == null && this.worldFile != null) {
                bi = WorldFileImageReader.getImageIOImage(this.fileURL);
            }
            return bi;
        }
        catch (IOException ioe) {
            logger.info("problem reading " + this.fileURL + ", IOException");
            ioe.printStackTrace();
            return null;
        }
    }

    public static BufferedImage getImageIOImage(URL fileURL) throws IOException {
        FileCacheImageInputStream fciis = new FileCacheImageInputStream(fileURL.openStream(), null);
        BufferedImage fileImage = ImageIO.read(fciis);
        return fileImage;
    }

    public static BufferedImage getJAIImage(URL fileURL) throws IOException {
        return BufferedImageHelper.getJAIBufferedImage("url", fileURL);
    }

    public ImageTile getImageTile(ImageTile.Cache cache) {
        block7: {
            try {
                if (this.worldFile instanceof ErrWorldFile) {
                    return new ErrImageTile(((ErrWorldFile)this.worldFile).getProblemMessage());
                }
                if (this.worldFile != null) {
                    BufferedImage bi = this.getBufferedImage();
                    if (bi != null) {
                        double ulat = this.worldFile.getY();
                        double llon = this.worldFile.getX();
                        double llat = ulat + this.worldFile.getYDim() * (double)bi.getHeight();
                        double rlon = llon + this.worldFile.getXDim() * (double)bi.getWidth();
                        if (logger.isLoggable(Level.FINE)) {
                            logger.info("Image should be at: " + ulat + ", " + llon + " - to - " + llat + ", " + rlon);
                        }
                        return new ImageTile((float)ulat, (float)llon, (float)llat, (float)rlon, this, cache);
                    }
                } else {
                    logger.info("World file for " + this.fileURL + " can't be found.");
                }
            }
            catch (NullPointerException npe) {
                if (!logger.isLoggable(Level.FINE)) break block7;
                logger.fine("Problem creating image (NullPointerException) from " + this.fileURL);
                npe.printStackTrace();
            }
        }
        return null;
    }

    public ImageTile getImageTile() {
        return this.getImageTile(null);
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("WorldFileImageReader:  Need a path/filename");
            System.exit(0);
        }
        logger.info("WorldFileImageReader: " + args[0]);
        String filePath = null;
        if (args.length > 0) {
            filePath = args[0];
        }
        if (filePath != null) {
            try {
                URL fileURL = PropUtils.getResourceOrFileOrURL(filePath);
                if (fileURL != null) {
                    WorldFileImageReader wfir = new WorldFileImageReader(fileURL);
                    BufferedImage bi = wfir.getBufferedImage();
                    CADRG crg = new CADRG(new LatLonPoint(0.0f, 0.0f), 1500000.0f, 600, 600);
                    final OMRaster omsr = new OMRaster(0, 0, (Image)bi);
                    omsr.generate(crg);
                    Frame window = new Frame(filePath){

                        public void paint(Graphics g) {
                            if (omsr != null) {
                                omsr.render(g);
                            }
                        }
                    };
                    window.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent e) {
                            System.exit(0);
                        }
                    });
                    window.setSize(omsr.getWidth(), omsr.getHeight());
                    window.setVisible(true);
                    window.repaint();
                }
            }
            catch (MalformedURLException murle) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

