/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.dted;

import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.dataAccess.dted.DTEDNameTranslator;
import com.bbn.openmap.dataAccess.dted.StandardDTEDNameTranslator;
import com.bbn.openmap.util.ComponentFactory;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.util.Properties;

public class DTEDDirectoryHandler
implements PropertyConsumer {
    public static final String PathProperty = "path";
    public static final String TranslatorClassProperty = "translator";
    protected String prefix;
    protected DTEDNameTranslator translator = new StandardDTEDNameTranslator();

    public DTEDDirectoryHandler() {
    }

    public DTEDDirectoryHandler(String dtedDirectory) {
        this.setDirectoryPath(dtedDirectory);
    }

    public void setTranslator(DTEDNameTranslator dnt) {
        this.translator = dnt;
    }

    public DTEDNameTranslator getTranslator() {
        return this.translator;
    }

    public void setDirectoryPath(String path) {
        if (this.translator != null) {
            this.translator.setDTEDDir(path);
        }
    }

    public String getDirectoryPath() {
        if (this.translator != null) {
            return this.translator.getDTEDDir();
        }
        return null;
    }

    public void setProperties(String prefix, Properties props) {
        this.setPropertyPrefix(prefix);
        String scopedPrefix = PropUtils.getScopedPropertyPrefix(prefix);
        String path = props.getProperty(scopedPrefix + PathProperty);
        String translatorClassName = props.getProperty(scopedPrefix + TranslatorClassProperty);
        if (translatorClassName != null) {
            Object obj = ComponentFactory.create(translatorClassName, prefix, props);
            if (obj != null && obj instanceof DTEDNameTranslator) {
                this.translator = (DTEDNameTranslator)obj;
            }
        } else if (this.translator == null) {
            this.translator = new StandardDTEDNameTranslator();
        }
        if (Debug.debugging("dtedfile")) {
            Debug.output("DTEDDirectoryHandler|" + prefix + ": " + this.translator.getClass().getName() + " using " + path);
        }
        this.setDirectoryPath(path);
    }

    public void setProperties(Properties props) {
        this.setProperties(null, props);
    }

    public Properties getProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + PathProperty, PropUtils.unnull(this.getDirectoryPath()));
        if (this.translator != null) {
            props.put(prefix + PathProperty, this.translator.getClass().getName());
            if (this.translator instanceof PropertyConsumer) {
                ((PropertyConsumer)((Object)this.translator)).getProperties(props);
            }
        }
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        props.put(PathProperty, "Path to DTED direcotory");
        props.put(TranslatorClassProperty, "Class name of DTEDNameTranslator to use for directory");
        if (this.translator instanceof PropertyConsumer) {
            ((PropertyConsumer)((Object)this.translator)).getPropertyInfo(props);
        }
        return props;
    }

    public void setPropertyPrefix(String propertyPrefix) {
        this.prefix = propertyPrefix;
    }

    public String getPropertyPrefix() {
        return this.prefix;
    }
}

