/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap;

import com.bbn.openmap.MoreMath;
import com.bbn.openmap.proj.GreatCircle;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.util.Assert;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class LatLonPoint
implements Cloneable,
Serializable {
    public static final float NORTH_POLE = 90.0f;
    public static final float SOUTH_POLE = -90.0f;
    public static final float DATELINE = 180.0f;
    public static final float LON_RANGE = 360.0f;
    protected float lat_ = 0.0f;
    protected float lon_ = 0.0f;
    public static final float EQUIVALENT_TOLERANCE = 1.0E-5f;
    public transient float radlat_ = 0.0f;
    public transient float radlon_ = 0.0f;

    public LatLonPoint() {
    }

    public LatLonPoint(float lat, float lon) {
        this.setLatLon(lat, lon);
    }

    public LatLonPoint(float lat, float lon, boolean isRadian) {
        this.setLatLon(lat, lon, isRadian);
    }

    public LatLonPoint(LatLonPoint pt) {
        this.lat_ = pt.lat_;
        this.lon_ = pt.lon_;
        this.radlat_ = pt.radlat_;
        this.radlon_ = pt.radlon_;
    }

    public LatLonPoint(double lat, double lon) {
        this((float)lat, (float)lon);
    }

    public String toString() {
        return "LatLonPoint[lat=" + this.lat_ + ",lon=" + this.lon_ + "]";
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            Assert.assertExp(false, "LatLonPoint: internal error!");
            return null;
        }
    }

    public void setLatitude(float lat) {
        this.lat_ = LatLonPoint.normalize_latitude(lat);
        this.radlat_ = ProjMath.degToRad(this.lat_);
    }

    public void setLongitude(float lon) {
        this.lon_ = LatLonPoint.wrap_longitude(lon);
        this.radlon_ = ProjMath.degToRad(this.lon_);
    }

    public void setLatLon(float lat, float lon) {
        this.lat_ = LatLonPoint.normalize_latitude(lat);
        this.lon_ = LatLonPoint.wrap_longitude(lon);
        this.radlat_ = ProjMath.degToRad(this.lat_);
        this.radlon_ = ProjMath.degToRad(this.lon_);
    }

    public void setLatLon(double lat, double lon) {
        this.setLatLon((float)lat, (float)lon);
    }

    public void setLatLon(float lat, float lon, boolean isRadian) {
        if (isRadian) {
            this.radlat_ = lat;
            this.radlon_ = lon;
            this.lat_ = LatLonPoint.normalize_latitude(ProjMath.radToDeg(this.radlat_));
            this.lon_ = LatLonPoint.wrap_longitude(ProjMath.radToDeg(this.radlon_));
        } else {
            this.setLatLon(lat, lon);
        }
    }

    public void setLatLon(LatLonPoint llpt) {
        this.lat_ = llpt.lat_;
        this.lon_ = llpt.lon_;
        this.radlat_ = llpt.radlat_;
        this.radlon_ = llpt.radlon_;
    }

    public float getLatitude() {
        return this.lat_;
    }

    public float getLongitude() {
        return this.lon_;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LatLonPoint) {
            LatLonPoint pt = (LatLonPoint)obj;
            return MoreMath.approximately_equal(this.lat_, pt.lat_, 1.0E-5f) && MoreMath.approximately_equal(this.lon_, pt.lon_, 1.0E-5f);
        }
        return false;
    }

    public int hashCode() {
        return ProjMath.hashLatLon(this.lat_, this.lon_);
    }

    public void write(DataOutputStream s) throws IOException {
        s.writeFloat(this.lat_);
        s.writeFloat(this.lon_);
    }

    public void read(DataInputStream s) throws IOException {
        this.setLatLon(s.readFloat(), s.readFloat());
    }

    public void read(DataInputStream s, boolean inRadians) throws IOException {
        if (inRadians) {
            this.setLatLon(s.readFloat(), s.readFloat(), inRadians);
        } else {
            this.read(s);
        }
    }

    public static final float normalize_latitude(float lat) {
        if (lat > 90.0f) {
            lat = 90.0f;
        }
        if (lat < -90.0f) {
            lat = -90.0f;
        }
        return lat;
    }

    public static final float wrap_longitude(float lon) {
        if (lon < -180.0f || lon > 180.0f) {
            lon += 180.0f;
            lon = (lon %= 360.0f) < 0.0f ? 180.0f + lon : -180.0f + lon;
        }
        return lon;
    }

    public static boolean isInvalidLatitude(float lat) {
        return lat > 90.0f || lat < -90.0f;
    }

    public static boolean isInvalidLongitude(float lon) {
        return lon < -180.0f || lon > 180.0f;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.lat_ = LatLonPoint.normalize_latitude(this.lat_);
        this.lon_ = LatLonPoint.wrap_longitude(this.lon_);
        this.radlat_ = ProjMath.degToRad(this.lat_);
        this.radlon_ = ProjMath.degToRad(this.lon_);
    }

    public LatLonPoint getPoint(float dist, float az) {
        return GreatCircle.spherical_between(this.radlat_, this.radlon_, dist, az);
    }

    public float distance(LatLonPoint toPoint) {
        return GreatCircle.spherical_distance(this.radlat_, this.radlon_, toPoint.radlat_, toPoint.radlon_);
    }

    public float azimuth(LatLonPoint toPoint) {
        return GreatCircle.spherical_azimuth(this.radlat_, this.radlon_, toPoint.radlat_, toPoint.radlon_);
    }
}

