/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.util;

import java.io.IOException;
import java.io.InputStream;

public class BranchableInputStream
extends InputStream {
    static final int DEFAULT_BASE_CHUNK_SIZE = 1024;
    static final int MAX_BYTES_PER_READ = 1024;
    int nextChunkSize;
    InputStream impl;
    LinkedChunk lastChunk = null;
    int dataLen = 0;
    int pos;
    boolean eof = false;

    public BranchableInputStream(InputStream in) {
        this(in, 1024);
    }

    public BranchableInputStream(InputStream in, int initialBufferSize) {
        this.impl = in;
        this.lastChunk = new LinkedChunk(0, 0);
        this.nextChunkSize = initialBufferSize;
    }

    public int read() throws IOException {
        int curpos = this.pos;
        if (this.readUntil(curpos)) {
            return this.lastChunk.get(curpos);
        }
        return -1;
    }

    public void close() throws IOException {
        this.eof = true;
        this.impl.close();
    }

    public int peek() throws IOException {
        int curpos = this.pos;
        int c = this.read();
        this.pos = curpos;
        return c;
    }

    public InputStream branch() {
        return new InputStreamBranch(this.lastChunk, this.pos);
    }

    boolean readUntil(int pos) throws IOException {
        if (!this.eof) {
            while (pos >= this.dataLen && !this.eof) {
                int bytesRead;
                if (this.lastChunk.full()) {
                    this.lastChunk.setNext(new LinkedChunk(this.lastChunk.lastIndex() + 1, this.nextChunkSize));
                    this.lastChunk = this.lastChunk.next();
                    this.nextChunkSize *= 2;
                }
                if ((bytesRead = this.lastChunk.readFrom(this.impl, 1024)) < 0) {
                    this.eof = true;
                    continue;
                }
                this.dataLen += bytesRead;
            }
        }
        if (pos < this.dataLen) {
            this.pos = Math.max(this.pos, pos + 1);
            return true;
        }
        return false;
    }

    class LinkedChunk {
        int offset;
        int len;
        byte[] buf;
        LinkedChunk next = null;

        LinkedChunk(int offset, int size) {
            this.offset = offset;
            this.buf = new byte[size];
            this.len = 0;
        }

        int readFrom(InputStream in, int maxBytes) throws IOException {
            int bytesRead = in.read(this.buf, this.len, Math.min(this.remaining(), maxBytes));
            if (bytesRead > 0) {
                this.len += bytesRead;
            }
            return bytesRead;
        }

        int get(int index) {
            if (index < this.offset || index - this.offset >= this.len) {
                return -1;
            }
            return this.buf[index - this.offset] & 0xFF;
        }

        int lastIndex() {
            return this.offset + this.buf.length - 1;
        }

        boolean full() {
            return this.len == this.buf.length;
        }

        int remaining() {
            return this.buf.length - this.len;
        }

        LinkedChunk next() {
            return this.next;
        }

        void setNext(LinkedChunk next) {
            this.next = next;
        }
    }

    class InputStreamBranch
    extends InputStream {
        LinkedChunk chunk;
        int pos;

        InputStreamBranch(LinkedChunk chunk, int pos) {
            this.chunk = chunk;
            this.pos = pos;
        }

        public int read() throws IOException {
            if (this.chunk == null || !BranchableInputStream.this.readUntil(this.pos)) {
                return -1;
            }
            while (this.pos > this.chunk.lastIndex()) {
                this.chunk = this.chunk.next;
            }
            return this.chunk.get(this.pos++);
        }

        public void close() {
            this.chunk = null;
        }
    }
}

