/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.request;

import com.basho.riak.client.util.ClientUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.httpclient.util.DateUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestMeta {
    private Map<String, String> queryParams = new LinkedHashMap<String, String>();
    private Map<String, String> headers = new HashMap<String, String>();

    public static RequestMeta readParams(int r) {
        RequestMeta meta = new RequestMeta();
        meta.setQueryParam("r", Integer.toString(r));
        return meta;
    }

    public static RequestMeta writeParams(Integer w, Integer dw) {
        RequestMeta meta = new RequestMeta();
        if (w != null) {
            meta.setQueryParam("w", Integer.toString(w));
        }
        if (dw != null) {
            meta.setQueryParam("dw", Integer.toString(dw));
        }
        return meta;
    }

    public RequestMeta setHeader(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    public String getHeader(String key) {
        return this.headers.get(key);
    }

    public boolean hasHeader(String key) {
        return this.headers.containsKey(key);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getQueryParam(String param) {
        return this.queryParams.get(param);
    }

    public RequestMeta setQueryParam(String param, String value) {
        this.queryParams.put(param, value);
        return this;
    }

    public String getQueryParams() {
        StringBuilder qp = new StringBuilder();
        for (String param : this.queryParams.keySet()) {
            if (this.queryParams.get(param) == null) continue;
            if (qp.length() > 0) {
                qp.append("&");
            }
            qp.append(param).append("=").append(this.queryParams.get(param));
        }
        return qp.toString();
    }

    public String getClientId() {
        return this.getHeader("x-riak-clientid");
    }

    public RequestMeta setClientId(String clientId) {
        return this.setHeader("x-riak-clientid", clientId);
    }

    public String getIfModifiedSince() {
        return this.getHeader("if-modified-since");
    }

    public RequestMeta setIfModifiedSince(String lastmod) {
        return this.setHeader("if-modified-since", lastmod);
    }

    public RequestMeta setIfModifiedSince(Date lastmod) {
        return this.setHeader("if-modified-since", DateUtil.formatDate((Date)lastmod));
    }

    public String getIfUnmodifiedSince() {
        return this.getHeader("if-unmodified-since");
    }

    public RequestMeta setIfUnmodifiedSince(String lastmod) {
        return this.setHeader("if-unmodified-since", lastmod);
    }

    public RequestMeta setIfUnmodifiedSince(Date lastmod) {
        return this.setHeader("if-unmodified-since", DateUtil.formatDate((Date)lastmod));
    }

    public String getIfMatch() {
        return this.getHeader("if-match");
    }

    public RequestMeta setIfMatch(String etags) {
        return this.setHeader("if-match", etags);
    }

    public RequestMeta setIfMatch(String[] etags) {
        return this.setHeader("if-match", ClientUtils.join(etags, ","));
    }

    public String getIfNoneMatch() {
        return this.getHeader("if-none-match");
    }

    public RequestMeta setIfNoneMatch(String etags) {
        return this.setHeader("if-none-match", etags);
    }

    public RequestMeta setIfNoneMatch(String[] etags) {
        return this.setHeader("if-none-match", ClientUtils.join(etags, ","));
    }

    public String getAccept() {
        return this.getHeader("accept");
    }

    public RequestMeta setAccept(String contentTypes) {
        return this.setHeader("accept", contentTypes);
    }
}

