/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.implementation;

import com.azure.resourcemanager.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.azure.resourcemanager.storage.StorageManager;
import com.azure.resourcemanager.storage.fluent.BlobServicesClient;
import com.azure.resourcemanager.storage.fluent.StorageManagementClient;
import com.azure.resourcemanager.storage.fluent.models.BlobServicePropertiesInner;
import com.azure.resourcemanager.storage.implementation.IdParsingUtils;
import com.azure.resourcemanager.storage.models.BlobServiceProperties;
import com.azure.resourcemanager.storage.models.CorsRule;
import com.azure.resourcemanager.storage.models.CorsRules;
import com.azure.resourcemanager.storage.models.DeleteRetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import reactor.core.publisher.Mono;

class BlobServicePropertiesImpl
extends CreatableUpdatableImpl<BlobServiceProperties, BlobServicePropertiesInner, BlobServicePropertiesImpl>
implements BlobServiceProperties,
BlobServiceProperties.Definition,
BlobServiceProperties.Update {
    private final StorageManager manager;
    private String resourceGroupName;
    private String accountName;

    BlobServicePropertiesImpl(String name, StorageManager manager) {
        super(name, (Object)new BlobServicePropertiesInner());
        this.manager = manager;
        this.accountName = name;
    }

    BlobServicePropertiesImpl(BlobServicePropertiesInner inner, StorageManager manager) {
        super(inner.name(), (Object)inner);
        this.manager = manager;
        this.accountName = inner.name();
        this.resourceGroupName = IdParsingUtils.getValueFromIdByName(inner.id(), "resourceGroups");
        this.accountName = IdParsingUtils.getValueFromIdByName(inner.id(), "storageAccounts");
    }

    public StorageManager manager() {
        return this.manager;
    }

    public Mono<BlobServiceProperties> createResourceAsync() {
        BlobServicesClient client = ((StorageManagementClient)this.manager().serviceClient()).getBlobServices();
        return client.setServicePropertiesAsync(this.resourceGroupName, this.accountName, (BlobServicePropertiesInner)((Object)this.innerModel())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    public Mono<BlobServiceProperties> updateResourceAsync() {
        BlobServicesClient client = ((StorageManagementClient)this.manager().serviceClient()).getBlobServices();
        return client.setServicePropertiesAsync(this.resourceGroupName, this.accountName, (BlobServicePropertiesInner)((Object)this.innerModel())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    protected Mono<BlobServicePropertiesInner> getInnerAsync() {
        BlobServicesClient client = ((StorageManagementClient)this.manager().serviceClient()).getBlobServices();
        return client.getServicePropertiesAsync(this.resourceGroupName, this.accountName);
    }

    public boolean isInCreateMode() {
        return ((BlobServicePropertiesInner)((Object)this.innerModel())).id() == null;
    }

    @Override
    public CorsRules cors() {
        return ((BlobServicePropertiesInner)((Object)this.innerModel())).cors();
    }

    @Override
    public String defaultServiceVersion() {
        return ((BlobServicePropertiesInner)((Object)this.innerModel())).defaultServiceVersion();
    }

    @Override
    public DeleteRetentionPolicy deleteRetentionPolicy() {
        return ((BlobServicePropertiesInner)((Object)this.innerModel())).deleteRetentionPolicy();
    }

    @Override
    public DeleteRetentionPolicy containerDeleteRetentionPolicy() {
        return ((BlobServicePropertiesInner)((Object)this.innerModel())).containerDeleteRetentionPolicy();
    }

    @Override
    public String id() {
        return ((BlobServicePropertiesInner)((Object)this.innerModel())).id();
    }

    @Override
    public String name() {
        return ((BlobServicePropertiesInner)((Object)this.innerModel())).name();
    }

    @Override
    public String type() {
        return ((BlobServicePropertiesInner)((Object)this.innerModel())).type();
    }

    @Override
    public Boolean isBlobVersioningEnabled() {
        return ((BlobServicePropertiesInner)((Object)this.innerModel())).isVersioningEnabled();
    }

    @Override
    public BlobServicePropertiesImpl withExistingStorageAccount(String resourceGroupName, String accountName) {
        this.resourceGroupName = resourceGroupName;
        this.accountName = accountName;
        return this;
    }

    @Override
    public BlobServicePropertiesImpl withCORSRules(List<CorsRule> corsRules) {
        ((BlobServicePropertiesInner)((Object)this.innerModel())).withCors(new CorsRules().withCorsRules(corsRules));
        return this;
    }

    @Override
    public BlobServicePropertiesImpl withCORSRule(CorsRule corsRule) {
        CorsRules corsRules = ((BlobServicePropertiesInner)((Object)this.innerModel())).cors();
        if (corsRules == null) {
            ArrayList<CorsRule> firstCorsRule = new ArrayList<CorsRule>();
            firstCorsRule.add(corsRule);
            ((BlobServicePropertiesInner)((Object)this.innerModel())).withCors(new CorsRules().withCorsRules(firstCorsRule));
        } else {
            List<CorsRule> currentCorsRules = corsRules.corsRules();
            currentCorsRules.add(corsRule);
            ((BlobServicePropertiesInner)((Object)this.innerModel())).withCors(corsRules.withCorsRules(currentCorsRules));
        }
        return this;
    }

    @Override
    public BlobServicePropertiesImpl withDefaultServiceVersion(String defaultServiceVersion) {
        ((BlobServicePropertiesInner)((Object)this.innerModel())).withDefaultServiceVersion(defaultServiceVersion);
        return this;
    }

    @Override
    public BlobServicePropertiesImpl withDeleteRetentionPolicy(DeleteRetentionPolicy deleteRetentionPolicy) {
        ((BlobServicePropertiesInner)((Object)this.innerModel())).withDeleteRetentionPolicy(deleteRetentionPolicy);
        return this;
    }

    @Override
    public BlobServicePropertiesImpl withDeleteRetentionPolicyEnabled(int numDaysEnabled) {
        ((BlobServicePropertiesInner)((Object)this.innerModel())).withDeleteRetentionPolicy(new DeleteRetentionPolicy().withEnabled(true).withDays(numDaysEnabled));
        return this;
    }

    @Override
    public BlobServicePropertiesImpl withDeleteRetentionPolicyDisabled() {
        ((BlobServicePropertiesInner)((Object)this.innerModel())).withDeleteRetentionPolicy(new DeleteRetentionPolicy().withEnabled(false));
        return this;
    }

    @Override
    public BlobServicePropertiesImpl withBlobVersioningEnabled() {
        ((BlobServicePropertiesInner)((Object)this.innerModel())).withIsVersioningEnabled(true);
        return this;
    }

    @Override
    public BlobServicePropertiesImpl withBlobVersioningDisabled() {
        ((BlobServicePropertiesInner)((Object)this.innerModel())).withIsVersioningEnabled(false);
        return this;
    }

    @Override
    public BlobServicePropertiesImpl withContainerDeleteRetentionPolicy(DeleteRetentionPolicy deleteRetentionPolicy) {
        ((BlobServicePropertiesInner)((Object)this.innerModel())).withContainerDeleteRetentionPolicy(deleteRetentionPolicy);
        return this;
    }

    @Override
    public BlobServicePropertiesImpl withContainerDeleteRetentionPolicyEnabled(int numDaysEnabled) {
        ((BlobServicePropertiesInner)((Object)this.innerModel())).withContainerDeleteRetentionPolicy(new DeleteRetentionPolicy().withEnabled(true).withDays(numDaysEnabled));
        return this;
    }

    @Override
    public BlobServicePropertiesImpl withContainerDeleteRetentionPolicyDisabled() {
        ((BlobServicePropertiesInner)((Object)this.innerModel())).withContainerDeleteRetentionPolicy(new DeleteRetentionPolicy().withEnabled(false));
        return this;
    }
}

