/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.keyvault.models.VaultProperties;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class VaultCreateOrUpdateParameters {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(VaultCreateOrUpdateParameters.class);
    @JsonProperty(value="location", required=true)
    private String location;
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> tags;
    @JsonProperty(value="properties", required=true)
    private VaultProperties properties;

    public String location() {
        return this.location;
    }

    public VaultCreateOrUpdateParameters withLocation(String location) {
        this.location = location;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public VaultCreateOrUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public VaultProperties properties() {
        return this.properties;
    }

    public VaultCreateOrUpdateParameters withProperties(VaultProperties properties) {
        this.properties = properties;
        return this;
    }

    public void validate() {
        if (this.location() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property location in model VaultCreateOrUpdateParameters"));
        }
        if (this.properties() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property properties in model VaultCreateOrUpdateParameters"));
        }
        this.properties().validate();
    }
}

