// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.blob.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * An Azure Storage container.
 */
@Fluent
public final class BlobContainerItem implements XmlSerializable<BlobContainerItem> {
    /*
     * The Name property.
     */
    private String name;

    /*
     * The Deleted property.
     */
    private Boolean deleted;

    /*
     * The Version property.
     */
    private String version;

    /*
     * Properties of a container
     */
    private BlobContainerItemProperties properties;

    /*
     * Dictionary of <string>
     */
    private Map<String, String> metadata;

    /**
     * Creates an instance of BlobContainerItem class.
     */
    public BlobContainerItem() {
    }

    /**
     * Get the name property: The Name property.
     * 
     * @return the name value.
     */
    public String getName() {
        return this.name;
    }

    /**
     * Set the name property: The Name property.
     * 
     * @param name the name value to set.
     * @return the BlobContainerItem object itself.
     */
    public BlobContainerItem setName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the deleted property: The Deleted property.
     * 
     * @return the deleted value.
     */
    public Boolean isDeleted() {
        return this.deleted;
    }

    /**
     * Set the deleted property: The Deleted property.
     * 
     * @param deleted the deleted value to set.
     * @return the BlobContainerItem object itself.
     */
    public BlobContainerItem setDeleted(Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    /**
     * Get the version property: The Version property.
     * 
     * @return the version value.
     */
    public String getVersion() {
        return this.version;
    }

    /**
     * Set the version property: The Version property.
     * 
     * @param version the version value to set.
     * @return the BlobContainerItem object itself.
     */
    public BlobContainerItem setVersion(String version) {
        this.version = version;
        return this;
    }

    /**
     * Get the properties property: Properties of a container.
     * 
     * @return the properties value.
     */
    public BlobContainerItemProperties getProperties() {
        return this.properties;
    }

    /**
     * Set the properties property: Properties of a container.
     * 
     * @param properties the properties value to set.
     * @return the BlobContainerItem object itself.
     */
    public BlobContainerItem setProperties(BlobContainerItemProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the metadata property: Dictionary of &lt;string&gt;.
     * 
     * @return the metadata value.
     */
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    /**
     * Set the metadata property: Dictionary of &lt;string&gt;.
     * 
     * @param metadata the metadata value to set.
     * @return the BlobContainerItem object itself.
     */
    public BlobContainerItem setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "Container" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Name", this.name);
        xmlWriter.writeBooleanElement("Deleted", this.deleted);
        xmlWriter.writeStringElement("Version", this.version);
        xmlWriter.writeXml(this.properties, "Properties");
        if (this.metadata != null) {
            xmlWriter.writeStartElement("Metadata");
            for (Map.Entry<String, String> entry : this.metadata.entrySet()) {
                xmlWriter.writeStringElement(entry.getKey(), entry.getValue());
            }
            xmlWriter.writeEndElement();
        }
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of BlobContainerItem from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of BlobContainerItem if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the BlobContainerItem.
     */
    public static BlobContainerItem fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of BlobContainerItem from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of BlobContainerItem if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the BlobContainerItem.
     */
    public static BlobContainerItem fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "Container" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            BlobContainerItem deserializedBlobContainerItem = new BlobContainerItem();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("Name".equals(elementName.getLocalPart())) {
                    deserializedBlobContainerItem.name = reader.getStringElement();
                } else if ("Deleted".equals(elementName.getLocalPart())) {
                    deserializedBlobContainerItem.deleted = reader.getNullableElement(Boolean::parseBoolean);
                } else if ("Version".equals(elementName.getLocalPart())) {
                    deserializedBlobContainerItem.version = reader.getStringElement();
                } else if ("Properties".equals(elementName.getLocalPart())) {
                    deserializedBlobContainerItem.properties
                        = BlobContainerItemProperties.fromXml(reader, "Properties");
                } else if ("Metadata".equals(elementName.getLocalPart())) {
                    while (reader.nextElement() != XmlToken.END_ELEMENT) {
                        if (deserializedBlobContainerItem.metadata == null) {
                            deserializedBlobContainerItem.metadata = new LinkedHashMap<>();
                        }
                        deserializedBlobContainerItem.metadata.put(reader.getElementName().getLocalPart(),
                            reader.getStringElement());
                    }
                } else {
                    reader.skipElement();
                }
            }

            return deserializedBlobContainerItem;
        });
    }
}
