// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.blob.implementation.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for BlobExpiryOptions. */
public final class BlobExpiryOptions extends ExpandableStringEnum<BlobExpiryOptions> {
    /** Static value NeverExpire for BlobExpiryOptions. */
    public static final BlobExpiryOptions NEVER_EXPIRE = fromString("NeverExpire");

    /** Static value RelativeToCreation for BlobExpiryOptions. */
    public static final BlobExpiryOptions RELATIVE_TO_CREATION = fromString("RelativeToCreation");

    /** Static value RelativeToNow for BlobExpiryOptions. */
    public static final BlobExpiryOptions RELATIVE_TO_NOW = fromString("RelativeToNow");

    /** Static value Absolute for BlobExpiryOptions. */
    public static final BlobExpiryOptions ABSOLUTE = fromString("Absolute");

    /**
     * Creates or finds a BlobExpiryOptions from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding BlobExpiryOptions.
     */
    @JsonCreator
    public static BlobExpiryOptions fromString(String name) {
        return fromString(name, BlobExpiryOptions.class);
    }

    /**
     * Gets known BlobExpiryOptions values.
     *
     * @return known BlobExpiryOptions values.
     */
    public static Collection<BlobExpiryOptions> values() {
        return values(BlobExpiryOptions.class);
    }
}
