/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.appconfiguration.implementation;

import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.policy.HttpPipelineSyncPolicy;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.UrlBuilder;
import com.azure.core.util.logging.ClientLogger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class QueryParamPolicy
extends HttpPipelineSyncPolicy {
    private static final ClientLogger LOGGER = new ClientLogger(QueryParamPolicy.class);

    protected void beforeSendingRequest(HttpPipelineCallContext context) {
        HttpRequest httpRequest = context.getHttpRequest();
        try {
            UrlBuilder builder = UrlBuilder.parse((URL)httpRequest.getUrl());
            String queryString = builder.getQueryString();
            builder.clearQuery();
            TreeMap orderedQuery = new TreeMap(String::compareTo);
            CoreUtils.parseQueryParameters((String)queryString).forEachRemaining(kvp -> {
                String lowercaseKey = ((String)kvp.getKey()).toLowerCase();
                orderedQuery.compute(lowercaseKey, (ignored, values) -> {
                    if (values == null) {
                        values = new ArrayList<String>();
                    }
                    values.add((String)kvp.getValue());
                    return values;
                });
            });
            for (Map.Entry ordered : orderedQuery.entrySet()) {
                ((List)ordered.getValue()).sort(String::compareTo);
                for (String val : (List)ordered.getValue()) {
                    builder.addQueryParameter((String)ordered.getKey(), val);
                }
            }
            httpRequest.setUrl(builder.toUrl().toString());
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            LOGGER.warning("Failed to set normalized URL due to invalid format. Request will proceed with original URL. URL: {}, Error: {}", new Object[]{httpRequest.getUrl(), e.getMessage(), e});
        }
    }
}

