/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.appconfiguration.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollOperationDetails;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingContext;
import com.azure.core.util.polling.SyncPoller;
import com.azure.data.appconfiguration.implementation.AzureAppConfigurationImpl;
import com.azure.data.appconfiguration.implementation.models.CreateSnapshotHeaders;
import com.azure.data.appconfiguration.implementation.models.OperationDetails;
import com.azure.data.appconfiguration.implementation.models.State;
import com.azure.data.appconfiguration.models.ConfigurationSnapshot;
import java.time.Duration;
import java.util.HashMap;
import java.util.function.Function;
import reactor.core.publisher.Mono;

public class CreateSnapshotUtilClient {
    private static final ClientLogger LOGGER = new ClientLogger(CreateSnapshotUtilClient.class);
    private static final Duration DEFAULT_POLL_INTERVAL = Duration.ofSeconds(30L);
    private final AzureAppConfigurationImpl service;

    public CreateSnapshotUtilClient(AzureAppConfigurationImpl service) {
        this.service = service;
    }

    public PollerFlux<PollOperationDetails, ConfigurationSnapshot> beginCreateSnapshot(String name, ConfigurationSnapshot snapshot) {
        try {
            return new PollerFlux(DEFAULT_POLL_INTERVAL, this.activationOperation((Mono<PollOperationDetails>)this.service.createSnapshotWithResponseAsync(name, snapshot, Context.NONE).map(response -> {
                HashMap<String, String> pollResponse = new HashMap<String, String>();
                pollResponse.put("id", ((CreateSnapshotHeaders)response.getDeserializedHeaders()).getOperationLocation());
                return (PollOperationDetails)BinaryData.fromObject(pollResponse).toObject(PollOperationDetails.class);
            })), this.pollingOperation(operationId -> this.service.getOperationDetailsWithResponseAsync(name, Context.NONE)), (pollingContext, activationResponse) -> Mono.error((Throwable)new RuntimeException("Cancellation is not supported.")), this.fetchingOperation(operationId -> this.service.getSnapshotWithResponseAsync(name, null, null, null, Context.NONE).flatMap(res -> Mono.justOrEmpty((Object)((ConfigurationSnapshot)res.getValue())))));
        }
        catch (Exception e) {
            return PollerFlux.error((Exception)e);
        }
    }

    public SyncPoller<PollOperationDetails, ConfigurationSnapshot> beginCreateSnapshot(String name, ConfigurationSnapshot snapshot, Context context) {
        try {
            Context finalContext = CreateSnapshotUtilClient.getNotNullContext(context);
            return SyncPoller.createPoller((Duration)DEFAULT_POLL_INTERVAL, cxt -> new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)this.activationOperationSync(name, snapshot, finalContext).apply((PollingContext<PollOperationDetails>)cxt)), this.pollingOperationSync(operationId -> this.service.getOperationDetailsWithResponse(name, finalContext)), (pollingContext, activationResponse) -> {
                throw LOGGER.logExceptionAsError(new RuntimeException("Cancellation is not supported."));
            }, this.fetchingOperationSync(operationId -> (ConfigurationSnapshot)this.service.getSnapshotWithResponse(name, null, null, null, finalContext).getValue()));
        }
        catch (Exception e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
    }

    private Function<PollingContext<PollOperationDetails>, Mono<PollOperationDetails>> activationOperation(Mono<PollOperationDetails> operationResult) {
        return pollingContext -> {
            try {
                return operationResult;
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<PollOperationDetails>, PollOperationDetails> activationOperationSync(String name, ConfigurationSnapshot snapshot, Context context) {
        return pollingContext -> {
            try {
                Context finalContext = CreateSnapshotUtilClient.getNotNullContext(context);
                ResponseBase<CreateSnapshotHeaders, ConfigurationSnapshot> snapshotWithResponse = this.service.createSnapshotWithResponse(name, snapshot, finalContext);
                HashMap<String, String> pollResponse = new HashMap<String, String>();
                pollResponse.put("id", ((CreateSnapshotHeaders)snapshotWithResponse.getDeserializedHeaders()).getOperationLocation());
                return (PollOperationDetails)BinaryData.fromObject(pollResponse).toObject(PollOperationDetails.class);
            }
            catch (RuntimeException ex) {
                throw LOGGER.logExceptionAsError(ex);
            }
        };
    }

    private Function<PollingContext<PollOperationDetails>, Mono<PollResponse<PollOperationDetails>>> pollingOperation(Function<String, Mono<Response<OperationDetails>>> pollingFunction) {
        return pollingContext -> {
            try {
                PollResponse pollResponse = pollingContext.getLatestResponse();
                String operationId = ((PollOperationDetails)pollResponse.getValue()).getOperationId();
                return ((Mono)pollingFunction.apply(operationId)).flatMap(modelResponse -> Mono.just(this.processResponse((Response<OperationDetails>)modelResponse, (PollResponse<PollOperationDetails>)pollResponse)));
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<PollOperationDetails>, PollResponse<PollOperationDetails>> pollingOperationSync(Function<String, Response<OperationDetails>> pollingFunction) {
        return pollingContext -> {
            try {
                PollResponse pollResponse = pollingContext.getLatestResponse();
                return this.processResponse((Response<OperationDetails>)((Response)pollingFunction.apply(((PollOperationDetails)pollResponse.getValue()).getOperationId())), (PollResponse<PollOperationDetails>)pollResponse);
            }
            catch (RuntimeException ex) {
                throw LOGGER.logExceptionAsError(ex);
            }
        };
    }

    private Function<PollingContext<PollOperationDetails>, Mono<ConfigurationSnapshot>> fetchingOperation(Function<String, Mono<ConfigurationSnapshot>> fetchingFunction) {
        return pollingContext -> {
            try {
                String operationId = ((PollOperationDetails)pollingContext.getLatestResponse().getValue()).getOperationId();
                return (Mono)fetchingFunction.apply(operationId);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<PollOperationDetails>, ConfigurationSnapshot> fetchingOperationSync(Function<String, ConfigurationSnapshot> fetchingFunction) {
        return pollingContext -> {
            try {
                String operationId = ((PollOperationDetails)pollingContext.getLatestResponse().getValue()).getOperationId();
                return (ConfigurationSnapshot)fetchingFunction.apply(operationId);
            }
            catch (RuntimeException ex) {
                throw LOGGER.logExceptionAsError(ex);
            }
        };
    }

    private PollResponse<PollOperationDetails> processResponse(Response<OperationDetails> response, PollResponse<PollOperationDetails> operationResultPollResponse) {
        State state = ((OperationDetails)response.getValue()).getStatus();
        LongRunningOperationStatus status = State.NOT_STARTED.equals((Object)state) || State.RUNNING.equals((Object)state) ? LongRunningOperationStatus.IN_PROGRESS : (State.SUCCEEDED.equals((Object)state) ? LongRunningOperationStatus.SUCCESSFULLY_COMPLETED : LongRunningOperationStatus.fromString((String)((OperationDetails)response.getValue()).toString(), (boolean)true));
        return new PollResponse(status, (Object)((PollOperationDetails)operationResultPollResponse.getValue()));
    }

    private static Context getNotNullContext(Context context) {
        return context == null ? Context.NONE : context;
    }
}

