/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation;

import com.azure.core.implementation.AccessibleByteArrayOutputStream;
import com.azure.core.implementation.ReflectionUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.logging.LogLevel;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.xml.stream.XMLStreamException;

public final class ReflectionSerializable {
    private static final ClientLogger LOGGER = new ClientLogger(ReflectionSerializable.class);
    private static final Class<?> JSON_SERIALIZABLE;
    private static final Class<?> JSON_READER;
    private static final IOExceptionCallable<Closeable> JSON_READER_CREATOR;
    private static final IOExceptionCallable<Closeable> JSON_WRITER_CREATOR;
    private static final IOExceptionCallable<Object> JSON_WRITER_WRITE_JSON_SERIALIZABLE;
    private static final IOExceptionCallable<Object> JSON_WRITER_FLUSH;
    static final boolean JSON_SERIALIZABLE_SUPPORTED;
    private static final Map<Class<?>, MethodHandle> FROM_JSON_CACHE;
    private static final Class<?> XML_SERIALIZABLE;
    private static final Class<?> XML_READER;
    private static final XmlStreamExceptionCallable<AutoCloseable> XML_READER_CREATOR;
    private static final XmlStreamExceptionCallable<AutoCloseable> XML_WRITER_CREATOR;
    private static final XmlStreamExceptionCallable<Object> XML_WRITER_WRITE_XML_START_DOCUMENT;
    private static final XmlStreamExceptionCallable<Object> XML_WRITER_WRITE_XML_SERIALIZABLE;
    private static final XmlStreamExceptionCallable<Object> XML_WRITER_FLUSH;
    static final boolean XML_SERIALIZABLE_SUPPORTED;
    private static final Map<Class<?>, MethodHandle> FROM_XML_CACHE;

    public static boolean supportsJsonSerializable(Class<?> bodyContentClass) {
        return JSON_SERIALIZABLE_SUPPORTED && JSON_SERIALIZABLE.isAssignableFrom(bodyContentClass);
    }

    public static ByteBuffer serializeJsonSerializableToByteBuffer(Object jsonSerializable) throws IOException {
        return ReflectionSerializable.serializeJsonSerializableWithReturn(jsonSerializable, AccessibleByteArrayOutputStream::toByteBuffer);
    }

    public static byte[] serializeJsonSerializableToBytes(Object jsonSerializable) throws IOException {
        return ReflectionSerializable.serializeJsonSerializableWithReturn(jsonSerializable, AccessibleByteArrayOutputStream::toByteArray);
    }

    public static String serializeJsonSerializableToString(Object jsonSerializable) throws IOException {
        return ReflectionSerializable.serializeJsonSerializableWithReturn(jsonSerializable, aos -> aos.toString(StandardCharsets.UTF_8));
    }

    private static <T> T serializeJsonSerializableWithReturn(Object jsonSerializable, Function<AccessibleByteArrayOutputStream, T> returner) throws IOException {
        try (AccessibleByteArrayOutputStream outputStream = new AccessibleByteArrayOutputStream();){
            T t;
            block11: {
                Closeable jsonWriter = JSON_WRITER_CREATOR.call(outputStream);
                try {
                    JSON_WRITER_WRITE_JSON_SERIALIZABLE.call(jsonWriter, jsonSerializable);
                    JSON_WRITER_FLUSH.call(jsonWriter);
                    t = returner.apply(outputStream);
                    if (jsonWriter == null) break block11;
                }
                catch (Throwable throwable) {
                    if (jsonWriter != null) {
                        try {
                            jsonWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                jsonWriter.close();
            }
            return t;
        }
    }

    public static void serializeJsonSerializableIntoOutputStream(Object jsonSerializable, OutputStream outputStream) throws IOException {
        try (Closeable jsonWriter = JSON_WRITER_CREATOR.call(outputStream);){
            JSON_WRITER_WRITE_JSON_SERIALIZABLE.call(jsonWriter, jsonSerializable);
            JSON_WRITER_FLUSH.call(jsonWriter);
        }
    }

    public static Object deserializeAsJsonSerializable(Class<?> jsonSerializable, byte[] json) throws IOException {
        Object object;
        block12: {
            if (!JSON_SERIALIZABLE_SUPPORTED) {
                return null;
            }
            if (FROM_JSON_CACHE.size() >= 10000) {
                FROM_JSON_CACHE.clear();
            }
            MethodHandle readJson = FROM_JSON_CACHE.computeIfAbsent(jsonSerializable, clazz -> {
                try {
                    MethodHandles.Lookup lookup = ReflectionUtils.getLookupToUse(clazz);
                    return lookup.unreflect(jsonSerializable.getDeclaredMethod("fromJson", JSON_READER));
                }
                catch (Exception e) {
                    throw LOGGER.logExceptionAsError(new IllegalStateException(e));
                }
            });
            Closeable jsonReader = JSON_READER_CREATOR.call(new Object[]{json});
            try {
                object = readJson.invoke(jsonReader);
                if (jsonReader == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonReader != null) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    if (e instanceof Exception) {
                        throw new IOException(e);
                    }
                    throw (Error)e;
                }
            }
            jsonReader.close();
        }
        return object;
    }

    public static boolean supportsXmlSerializable(Class<?> bodyContentClass) {
        return XML_SERIALIZABLE_SUPPORTED && XML_SERIALIZABLE.isAssignableFrom(bodyContentClass);
    }

    public static ByteBuffer serializeXmlSerializableToByteBuffer(Object xmlSerializable) throws IOException {
        return ReflectionSerializable.serializeXmlSerializableWithReturn(xmlSerializable, AccessibleByteArrayOutputStream::toByteBuffer);
    }

    public static byte[] serializeXmlSerializableToBytes(Object xmlSerializable) throws IOException {
        return ReflectionSerializable.serializeXmlSerializableWithReturn(xmlSerializable, AccessibleByteArrayOutputStream::toByteArray);
    }

    public static String serializeXmlSerializableToString(Object xmlSerializable) throws IOException {
        return ReflectionSerializable.serializeXmlSerializableWithReturn(xmlSerializable, aos -> aos.toString(StandardCharsets.UTF_8));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static <T> T serializeXmlSerializableWithReturn(Object xmlSerializable, Function<AccessibleByteArrayOutputStream, T> returner) throws IOException {
        try (AccessibleByteArrayOutputStream outputStream = new AccessibleByteArrayOutputStream();){
            AccessibleByteArrayOutputStream accessibleByteArrayOutputStream;
            block14: {
                AutoCloseable xmlWriter = XML_WRITER_CREATOR.call(outputStream);
                try {
                    XML_WRITER_WRITE_XML_START_DOCUMENT.call(xmlWriter);
                    XML_WRITER_WRITE_XML_SERIALIZABLE.call(xmlWriter, xmlSerializable);
                    XML_WRITER_FLUSH.call(xmlWriter);
                    accessibleByteArrayOutputStream = returner.apply(outputStream);
                    if (xmlWriter == null) break block14;
                }
                catch (Throwable throwable) {
                    if (xmlWriter != null) {
                        try {
                            xmlWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                xmlWriter.close();
            }
            return (T)accessibleByteArrayOutputStream;
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    public static void serializeXmlSerializableIntoOutputStream(Object xmlSerializable, OutputStream outputStream) throws IOException {
        try (AutoCloseable xmlWriter = XML_WRITER_CREATOR.call(outputStream);){
            XML_WRITER_WRITE_XML_START_DOCUMENT.call(xmlWriter);
            XML_WRITER_WRITE_XML_SERIALIZABLE.call(xmlWriter, xmlSerializable);
            XML_WRITER_FLUSH.call(xmlWriter);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    public static Object deserializeAsXmlSerializable(Class<?> xmlSerializable, byte[] xml) throws IOException {
        Object object;
        block12: {
            if (!XML_SERIALIZABLE_SUPPORTED) {
                return null;
            }
            if (FROM_XML_CACHE.size() >= 10000) {
                FROM_XML_CACHE.clear();
            }
            MethodHandle readXml = FROM_XML_CACHE.computeIfAbsent(xmlSerializable, clazz -> {
                try {
                    MethodHandles.Lookup lookup = ReflectionUtils.getLookupToUse(clazz);
                    return lookup.unreflect(xmlSerializable.getMethod("fromXml", XML_READER));
                }
                catch (Exception e) {
                    throw LOGGER.logExceptionAsError(new IllegalStateException(e));
                }
            });
            AutoCloseable xmlReader = XML_READER_CREATOR.call(new Object[]{xml});
            try {
                object = readXml.invoke(xmlReader);
                if (xmlReader == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (xmlReader != null) {
                        try {
                            xmlReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    if (e instanceof Exception) {
                        throw new IOException(e);
                    }
                    throw (Error)e;
                }
            }
            xmlReader.close();
        }
        return object;
    }

    private static <T> IOExceptionCallable<T> createJsonCallable(Class<T> returnType, MethodHandle methodHandle) {
        return parameters -> {
            try {
                return returnType.cast(methodHandle.invokeWithArguments(parameters));
            }
            catch (Throwable throwable) {
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                throw new IOException(throwable);
            }
        };
    }

    private static <T> XmlStreamExceptionCallable<T> createXmlCallable(Class<T> returnType, MethodHandle methodHandle) {
        return parameters -> {
            try {
                return returnType.cast(methodHandle.invokeWithArguments(parameters));
            }
            catch (Throwable throwable) {
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                if (throwable instanceof XMLStreamException) {
                    throw (XMLStreamException)throwable;
                }
                throw new XMLStreamException(throwable);
            }
        };
    }

    private ReflectionSerializable() {
    }

    static {
        Class<?> jsonSerializable = null;
        Class<?> jsonReader = null;
        IOExceptionCallable<Closeable> jsonReaderCreator = null;
        IOExceptionCallable<Closeable> jsonWriterCreator = null;
        IOExceptionCallable<Object> jsonWriterWriteJsonSerializable = null;
        IOExceptionCallable<Object> jsonWriterFlush = null;
        boolean jsonSerializableSupported = false;
        try {
            jsonSerializable = Class.forName("com.azure.json.JsonSerializable");
            jsonReader = Class.forName("com.azure.json.JsonReader");
            Class<?> jsonProviders = Class.forName("com.azure.json.JsonProviders");
            MethodHandles.Lookup lookup = ReflectionUtils.getLookupToUse(jsonProviders);
            MethodHandle handle = lookup.unreflect(jsonProviders.getDeclaredMethod("createReader", byte[].class));
            jsonReaderCreator = ReflectionSerializable.createJsonCallable(Closeable.class, handle);
            handle = lookup.unreflect(jsonProviders.getDeclaredMethod("createWriter", OutputStream.class));
            jsonWriterCreator = ReflectionSerializable.createJsonCallable(Closeable.class, handle);
            Class<?> jsonWriter = Class.forName("com.azure.json.JsonWriter");
            handle = lookup.unreflect(jsonWriter.getDeclaredMethod("writeJson", jsonSerializable));
            jsonWriterWriteJsonSerializable = ReflectionSerializable.createJsonCallable(Object.class, handle);
            handle = lookup.unreflect(jsonWriter.getDeclaredMethod("flush", new Class[0]));
            jsonWriterFlush = ReflectionSerializable.createJsonCallable(Object.class, handle);
            jsonSerializableSupported = true;
        }
        catch (Throwable e) {
            if (e instanceof LinkageError || e instanceof Exception) {
                LOGGER.log(LogLevel.VERBOSE, () -> "JsonSerializable serialization and deserialization isn't supported. If it is required add a dependency of 'com.azure:azure-json', or another dependencies which include 'com.azure:azure-json' as a transitive dependency. If your application runs as expected this informational message can be ignored.");
            }
            throw (Error)e;
        }
        JSON_SERIALIZABLE = jsonSerializable;
        JSON_READER = jsonReader;
        JSON_READER_CREATOR = jsonReaderCreator;
        JSON_WRITER_CREATOR = jsonWriterCreator;
        JSON_WRITER_WRITE_JSON_SERIALIZABLE = jsonWriterWriteJsonSerializable;
        JSON_WRITER_FLUSH = jsonWriterFlush;
        JSON_SERIALIZABLE_SUPPORTED = jsonSerializableSupported;
        FROM_JSON_CACHE = JSON_SERIALIZABLE_SUPPORTED ? new ConcurrentHashMap() : null;
        Class<?> xmlSerializable = null;
        Class<?> xmlReader = null;
        XmlStreamExceptionCallable<AutoCloseable> xmlReaderCreator = null;
        XmlStreamExceptionCallable<AutoCloseable> xmlWriterCreator = null;
        XmlStreamExceptionCallable<Object> xmlWriterWriteStartDocument = null;
        XmlStreamExceptionCallable<Object> xmlWriterWriteXmlSerializable = null;
        XmlStreamExceptionCallable<Object> xmlWriterFlush = null;
        boolean xmlSerializableSupported = false;
        try {
            xmlSerializable = Class.forName("com.azure.xml.XmlSerializable");
            xmlReader = Class.forName("com.azure.xml.XmlReader");
            Class<?> xmlProviders = Class.forName("com.azure.xml.XmlProviders");
            MethodHandles.Lookup lookup = ReflectionUtils.getLookupToUse(xmlProviders);
            MethodHandle handle = lookup.unreflect(xmlProviders.getDeclaredMethod("createReader", byte[].class));
            xmlReaderCreator = ReflectionSerializable.createXmlCallable(AutoCloseable.class, handle);
            handle = lookup.unreflect(xmlProviders.getDeclaredMethod("createWriter", OutputStream.class));
            xmlWriterCreator = ReflectionSerializable.createXmlCallable(AutoCloseable.class, handle);
            Class<?> xmlWriter = Class.forName("com.azure.xml.XmlWriter");
            handle = lookup.unreflect(xmlWriter.getDeclaredMethod("writeStartDocument", new Class[0]));
            xmlWriterWriteStartDocument = ReflectionSerializable.createXmlCallable(Object.class, handle);
            handle = lookup.unreflect(xmlWriter.getDeclaredMethod("writeXml", xmlSerializable));
            xmlWriterWriteXmlSerializable = ReflectionSerializable.createXmlCallable(Object.class, handle);
            handle = lookup.unreflect(xmlWriter.getDeclaredMethod("flush", new Class[0]));
            xmlWriterFlush = ReflectionSerializable.createXmlCallable(Object.class, handle);
            xmlSerializableSupported = true;
        }
        catch (Throwable e) {
            if (e instanceof LinkageError || e instanceof Exception) {
                LOGGER.log(LogLevel.VERBOSE, () -> "XmlSerializable serialization and deserialization isn't supported. If it is required add a dependency of 'com.azure:azure-xml', or another dependencies which include 'com.azure:azure-xml' as a transitive dependency. If your application runs as expected this informational message can be ignored.");
            }
            throw (Error)e;
        }
        XML_SERIALIZABLE = xmlSerializable;
        XML_READER = xmlReader;
        XML_READER_CREATOR = xmlReaderCreator;
        XML_WRITER_CREATOR = xmlWriterCreator;
        XML_WRITER_WRITE_XML_START_DOCUMENT = xmlWriterWriteStartDocument;
        XML_WRITER_WRITE_XML_SERIALIZABLE = xmlWriterWriteXmlSerializable;
        XML_WRITER_FLUSH = xmlWriterFlush;
        XML_SERIALIZABLE_SUPPORTED = xmlSerializableSupported;
        FROM_XML_CACHE = XML_SERIALIZABLE_SUPPORTED ? new ConcurrentHashMap() : null;
    }

    private static interface IOExceptionCallable<T> {
        public T call(Object ... var1) throws IOException;
    }

    private static interface XmlStreamExceptionCallable<T> {
        public T call(Object ... var1) throws XMLStreamException;
    }
}

