/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.http.policy;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpPipelineNextSyncPolicy;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.tracing.SpanKind;
import com.azure.core.util.tracing.StartSpanOptions;
import com.azure.core.util.tracing.Tracer;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.core.publisher.Signal;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public class InstrumentationPolicy
implements HttpPipelinePolicy {
    private static final String HTTP_USER_AGENT = "http.user_agent";
    private static final String HTTP_METHOD = "http.method";
    private static final String HTTP_URL = "http.url";
    private static final String HTTP_STATUS_CODE = "http.status_code";
    private static final String SERVICE_REQUEST_ID_ATTRIBUTE = "serviceRequestId";
    private static final String CLIENT_REQUEST_ID_ATTRIBUTE = "requestId";
    private static final String REACTOR_HTTP_TRACE_CONTEXT_KEY = "instrumentation-context-key";
    private static final HttpHeaderName SERVICE_REQUEST_ID_HEADER = HttpHeaderName.fromString("x-ms-request-id");
    private static final HttpHeaderName CLIENT_REQUEST_ID_HEADER = HttpHeaderName.fromString("x-ms-client-request-id");
    private static final String LEGACY_OTEL_POLICY_NAME = "io.opentelemetry.javaagent.instrumentation.azurecore.v1_19.shaded.com.azure.core.tracing.opentelemetry.OpenTelemetryHttpPolicy";
    private static final ClientLogger LOGGER = new ClientLogger(InstrumentationPolicy.class);
    private Tracer tracer;
    private ScalarPropagatingMono propagatingMono;
    private static boolean foundLegacyOTelPolicy;

    public void initialize(Tracer tracer) {
        this.tracer = tracer;
        this.propagatingMono = new ScalarPropagatingMono(tracer);
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        if (!this.isTracingEnabled(context)) {
            return next.process();
        }
        return this.propagatingMono.flatMap(ignored -> next.process()).doOnEach(this::handleResponse).contextWrite((ContextView)Context.of((Object)REACTOR_HTTP_TRACE_CONTEXT_KEY, (Object)this.startSpan(context)));
    }

    /*
     * Loose catch block
     */
    @Override
    public HttpResponse processSync(HttpPipelineCallContext context, HttpPipelineNextSyncPolicy next) {
        HttpResponse httpResponse;
        AutoCloseable scope;
        HttpResponse response;
        Exception exception;
        com.azure.core.util.Context span;
        block12: {
            if (!this.isTracingEnabled(context)) {
                return next.processSync();
            }
            span = this.startSpan(context);
            exception = null;
            response = null;
            scope = this.tracer.makeSpanCurrent(span);
            httpResponse = response = next.processSync();
            if (scope == null) break block12;
            scope.close();
        }
        this.endSpan(response, exception, span);
        return httpResponse;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (RuntimeException ex) {
                        exception = ex;
                        throw ex;
                    }
                    catch (Exception ex) {
                        exception = ex;
                        throw LOGGER.logExceptionAsWarning(new RuntimeException(ex));
                    }
                }
                catch (Throwable throwable3) {
                    this.endSpan(response, exception, span);
                    throw throwable3;
                }
            }
        }
    }

    private com.azure.core.util.Context startSpan(HttpPipelineCallContext azContext) {
        HttpRequest request = azContext.getHttpRequest();
        String methodName = request.getHttpMethod().toString();
        StartSpanOptions spanOptions = new StartSpanOptions(SpanKind.CLIENT).setAttribute(HTTP_METHOD, methodName).setAttribute(HTTP_URL, request.getUrl().toString());
        com.azure.core.util.Context span = this.tracer.start("HTTP " + methodName, spanOptions, azContext.getContext());
        this.addPostSamplingAttributes(span, request);
        this.tracer.injectContext((k, v) -> request.getHeaders().set((String)k, (String)v), span);
        return span;
    }

    private void addPostSamplingAttributes(com.azure.core.util.Context span, HttpRequest request) {
        String requestId;
        String userAgent = request.getHeaders().getValue("User-Agent");
        if (!CoreUtils.isNullOrEmpty(userAgent)) {
            this.tracer.setAttribute(HTTP_USER_AGENT, userAgent, span);
        }
        if (!CoreUtils.isNullOrEmpty(requestId = request.getHeaders().getValue(CLIENT_REQUEST_ID_HEADER))) {
            this.tracer.setAttribute(CLIENT_REQUEST_ID_ATTRIBUTE, requestId, span);
        }
    }

    private void handleResponse(Signal<? extends HttpResponse> signal) {
        if (signal.isOnComplete() || signal.isOnSubscribe()) {
            return;
        }
        com.azure.core.util.Context span = (com.azure.core.util.Context)signal.getContextView().getOrDefault((Object)REACTOR_HTTP_TRACE_CONTEXT_KEY, null);
        this.endSpan((HttpResponse)signal.get(), signal.getThrowable(), span);
    }

    private void endSpan(HttpResponse response, Throwable error, com.azure.core.util.Context span) {
        if (response != null) {
            int statusCode = response.getStatusCode();
            this.tracer.setAttribute(HTTP_STATUS_CODE, statusCode, span);
            String requestId = response.getHeaderValue(SERVICE_REQUEST_ID_HEADER);
            if (requestId != null) {
                this.tracer.setAttribute(SERVICE_REQUEST_ID_ATTRIBUTE, requestId, span);
            }
            this.tracer.end(statusCode >= 400 ? "error" : null, null, span);
        }
        this.tracer.end(null, error, span);
    }

    private boolean isTracingEnabled(HttpPipelineCallContext context) {
        return this.tracer != null && this.tracer.isEnabled() && !foundLegacyOTelPolicy && (Boolean)context.getData("disable-tracing").orElse(false) == false;
    }

    static {
        try {
            Class.forName(LEGACY_OTEL_POLICY_NAME, true, HttpPipelinePolicy.class.getClassLoader());
            foundLegacyOTelPolicy = true;
        }
        catch (ClassNotFoundException e) {
            foundLegacyOTelPolicy = false;
        }
    }

    static final class ScalarPropagatingMono
    extends Mono<Object> {
        private final Object value = new Object();
        private final Tracer tracer;

        private ScalarPropagatingMono(Tracer tracer) {
            this.tracer = tracer;
        }

        public void subscribe(CoreSubscriber<? super Object> actual) {
            com.azure.core.util.Context traceContext = (com.azure.core.util.Context)actual.currentContext().getOrDefault((Object)InstrumentationPolicy.REACTOR_HTTP_TRACE_CONTEXT_KEY, null);
            if (this.tracer.isEnabled() && traceContext != null) {
                try (AutoCloseable scope = this.tracer.makeSpanCurrent(traceContext);){
                    actual.onSubscribe(Operators.scalarSubscription(actual, (Object)this.value));
                }
                catch (Exception e) {
                    LOGGER.verbose("Error closing scope", e);
                }
            } else {
                actual.onSubscribe(Operators.scalarSubscription(actual, (Object)this.value));
            }
        }
    }
}

