/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public final class CoreUtils {
    private static final ClientLogger LOGGER = new ClientLogger(CoreUtils.class);
    private static final String COMMA = ",";
    private static final Charset UTF_32BE = Charset.forName("UTF-32BE");
    private static final Charset UTF_32LE = Charset.forName("UTF-32LE");
    private static final byte ZERO = 0;
    private static final byte BB = -69;
    private static final byte BF = -65;
    private static final byte EF = -17;
    private static final byte FE = -2;
    private static final byte FF = -1;
    private static final Pattern CHARSET_PATTERN = Pattern.compile("charset=([\\S]+)\\b", 2);

    private CoreUtils() {
    }

    public static byte[] clone(byte[] source) {
        if (source == null) {
            return null;
        }
        byte[] copy = new byte[source.length];
        System.arraycopy(source, 0, copy, 0, source.length);
        return copy;
    }

    public static int[] clone(int[] source) {
        if (source == null) {
            return null;
        }
        int[] copy = new int[source.length];
        System.arraycopy(source, 0, copy, 0, source.length);
        return copy;
    }

    public static <T> T[] clone(T[] source) {
        if (source == null) {
            return null;
        }
        return Arrays.copyOf(source, source.length);
    }

    public static boolean isNullOrEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNullOrEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNullOrEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNullOrEmpty(CharSequence charSequence) {
        return charSequence == null || charSequence.length() == 0;
    }

    public static <T> String arrayToString(T[] array, Function<T, String> mapper) {
        if (CoreUtils.isNullOrEmpty(array)) {
            return null;
        }
        return Arrays.stream(array).map(mapper).collect(Collectors.joining(COMMA));
    }

    public static <T> T findFirstOfType(Object[] args, Class<T> clazz) {
        if (CoreUtils.isNullOrEmpty(args)) {
            return null;
        }
        for (Object arg : args) {
            if (!clazz.isInstance(arg)) continue;
            return clazz.cast(arg);
        }
        return null;
    }

    @Deprecated
    public static <T> Publisher<T> extractAndFetch(PagedResponse<T> page, Context context, BiFunction<String, Context, Publisher<T>> content) {
        String nextPageLink = (String)page.getContinuationToken();
        if (nextPageLink == null) {
            return Flux.fromIterable(page.getElements());
        }
        return Flux.fromIterable(page.getElements()).concatWith(content.apply(nextPageLink, context));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> getProperties(String propertiesFileName) {
        try (InputStream inputStream = CoreUtils.class.getClassLoader().getResourceAsStream(propertiesFileName);){
            if (inputStream == null) return Collections.emptyMap();
            Properties properties = new Properties();
            properties.load(inputStream);
            Map<String, String> map = Collections.unmodifiableMap(properties.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (String)entry.getValue())));
            return map;
        }
        catch (IOException ex) {
            LOGGER.warning("Failed to get properties from " + propertiesFileName, ex);
        }
        return Collections.emptyMap();
    }

    public static String bomAwareToString(byte[] bytes, String contentType) {
        if (bytes == null) {
            return null;
        }
        if (bytes.length >= 3 && bytes[0] == -17 && bytes[1] == -69 && bytes[2] == -65) {
            return new String(bytes, 3, bytes.length - 3, StandardCharsets.UTF_8);
        }
        if (bytes.length >= 4 && bytes[0] == 0 && bytes[1] == 0 && bytes[2] == -2 && bytes[3] == -1) {
            return new String(bytes, 4, bytes.length - 4, UTF_32BE);
        }
        if (bytes.length >= 4 && bytes[0] == -1 && bytes[1] == -2 && bytes[2] == 0 && bytes[3] == 0) {
            return new String(bytes, 4, bytes.length - 4, UTF_32LE);
        }
        if (bytes.length >= 2 && bytes[0] == -2 && bytes[1] == -1) {
            return new String(bytes, 2, bytes.length - 2, StandardCharsets.UTF_16BE);
        }
        if (bytes.length >= 2 && bytes[0] == -1 && bytes[1] == -2) {
            return new String(bytes, 2, bytes.length - 2, StandardCharsets.UTF_16LE);
        }
        if (!CoreUtils.isNullOrEmpty(contentType)) {
            try {
                Matcher charsetMatcher = CHARSET_PATTERN.matcher(contentType);
                if (charsetMatcher.find()) {
                    return new String(bytes, Charset.forName(charsetMatcher.group(1)));
                }
                return new String(bytes, StandardCharsets.UTF_8);
            }
            catch (IllegalCharsetNameException | UnsupportedCharsetException ex) {
                return new String(bytes, StandardCharsets.UTF_8);
            }
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static String getApplicationId(ClientOptions clientOptions, HttpLogOptions logOptions) {
        if (clientOptions != null && !CoreUtils.isNullOrEmpty(clientOptions.getApplicationId())) {
            return clientOptions.getApplicationId();
        }
        if (logOptions != null && !CoreUtils.isNullOrEmpty(logOptions.getApplicationId())) {
            return logOptions.getApplicationId();
        }
        return null;
    }

    public static HttpHeaders createHttpHeadersFromClientOptions(ClientOptions clientOptions) {
        if (clientOptions == null) {
            return null;
        }
        ArrayList<HttpHeader> httpHeaderList = new ArrayList<HttpHeader>();
        clientOptions.getHeaders().forEach(header -> httpHeaderList.add(new HttpHeader(header.getName(), header.getValue())));
        return httpHeaderList.isEmpty() ? null : new HttpHeaders(httpHeaderList);
    }

    public static Duration getDefaultTimeoutFromEnvironment(Configuration configuration, String timeoutPropertyName, Duration defaultTimeout, ClientLogger logger) {
        String environmentTimeout = configuration.get(timeoutPropertyName);
        if (CoreUtils.isNullOrEmpty(environmentTimeout)) {
            return defaultTimeout;
        }
        try {
            long timeoutMillis = Long.parseLong(environmentTimeout);
            if (timeoutMillis < 0L) {
                logger.atVerbose().addKeyValue(timeoutPropertyName, timeoutMillis).log("Negative timeout values are not allowed. Using 'Duration.ZERO' to indicate no timeout..");
                return Duration.ZERO;
            }
            return Duration.ofMillis(timeoutMillis);
        }
        catch (NumberFormatException ex) {
            logger.atWarning().addKeyValue(timeoutPropertyName, environmentTimeout).addKeyValue("defaultTimeout", defaultTimeout).log("Timeout is not valid number. Using default value.", ex);
            return defaultTimeout;
        }
    }

    public static Context mergeContexts(Context into, Context from) {
        Objects.requireNonNull(into, "'into' cannot be null.");
        Objects.requireNonNull(from, "'from' cannot be null.");
        Context[] contextChain = from.getContextChain();
        Context returnContext = into;
        for (Context toAdd : contextChain) {
            if (toAdd == null) continue;
            returnContext = returnContext.addData(toAdd.getKey(), toAdd.getValue());
        }
        return returnContext;
    }

    public static String stringJoin(String delimiter, List<String> values) {
        Objects.requireNonNull(delimiter, "'delimiter' cannot be null.");
        Objects.requireNonNull(values, "'values' cannot be null.");
        int count = values.size();
        switch (count) {
            case 0: {
                return "";
            }
            case 1: {
                return values.get(0);
            }
            case 2: {
                return values.get(0) + delimiter + values.get(1);
            }
            case 3: {
                return values.get(0) + delimiter + values.get(1) + delimiter + values.get(2);
            }
            case 4: {
                return values.get(0) + delimiter + values.get(1) + delimiter + values.get(2) + delimiter + values.get(3);
            }
            case 5: {
                return values.get(0) + delimiter + values.get(1) + delimiter + values.get(2) + delimiter + values.get(3) + delimiter + values.get(4);
            }
            case 6: {
                return values.get(0) + delimiter + values.get(1) + delimiter + values.get(2) + delimiter + values.get(3) + delimiter + values.get(4) + delimiter + values.get(5);
            }
            case 7: {
                return values.get(0) + delimiter + values.get(1) + delimiter + values.get(2) + delimiter + values.get(3) + delimiter + values.get(4) + delimiter + values.get(5) + delimiter + values.get(6);
            }
            case 8: {
                return values.get(0) + delimiter + values.get(1) + delimiter + values.get(2) + delimiter + values.get(3) + delimiter + values.get(4) + delimiter + values.get(5) + delimiter + values.get(6) + delimiter + values.get(7);
            }
            case 9: {
                return values.get(0) + delimiter + values.get(1) + delimiter + values.get(2) + delimiter + values.get(3) + delimiter + values.get(4) + delimiter + values.get(5) + delimiter + values.get(6) + delimiter + values.get(7) + delimiter + values.get(8);
            }
            case 10: {
                return values.get(0) + delimiter + values.get(1) + delimiter + values.get(2) + delimiter + values.get(3) + delimiter + values.get(4) + delimiter + values.get(5) + delimiter + values.get(6) + delimiter + values.get(7) + delimiter + values.get(8) + delimiter + values.get(9);
            }
        }
        return String.join((CharSequence)delimiter, values);
    }
}

