/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.http.ProxyOptions;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.Header;
import com.azure.core.util.logging.ClientLogger;
import java.time.Duration;

public final class HttpClientOptions
extends ClientOptions {
    private static final Duration MINIMUM_TIMEOUT = Duration.ofMillis(1L);
    private static final Duration DEFAULT_CONNECT_TIMEOUT;
    private static final Duration DEFAULT_WRITE_TIMEOUT;
    private static final Duration DEFAULT_RESPONSE_TIMEOUT;
    private static final Duration DEFAULT_READ_TIMEOUT;
    private static final Duration DEFAULT_CONNECTION_IDLE_TIMEOUT;
    private static final Duration NO_TIMEOUT;
    private static final ClientLogger LOGGER;
    private ProxyOptions proxyOptions;
    private Configuration configuration;
    private Duration connectTimeout;
    private Duration writeTimeout;
    private Duration responseTimeout;
    private Duration readTimeout;
    private Integer maximumConnectionPoolSize;
    private Duration connectionIdleTimeout;

    @Override
    public HttpClientOptions setApplicationId(String applicationId) {
        super.setApplicationId(applicationId);
        return this;
    }

    @Override
    public HttpClientOptions setHeaders(Iterable<Header> headers) {
        super.setHeaders(headers);
        return this;
    }

    public HttpClientOptions setProxyOptions(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
        return this;
    }

    public ProxyOptions getProxyOptions() {
        return this.proxyOptions;
    }

    public HttpClientOptions setConfiguration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public HttpClientOptions setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public Duration getConnectTimeout() {
        return HttpClientOptions.getTimeout(this.connectTimeout, DEFAULT_CONNECT_TIMEOUT);
    }

    public HttpClientOptions setWriteTimeout(Duration writeTimeout) {
        this.writeTimeout = writeTimeout;
        return this;
    }

    public Duration getWriteTimeout() {
        return HttpClientOptions.getTimeout(this.writeTimeout, DEFAULT_WRITE_TIMEOUT);
    }

    public HttpClientOptions responseTimeout(Duration responseTimeout) {
        this.responseTimeout = responseTimeout;
        return this;
    }

    public HttpClientOptions setResponseTimeout(Duration responseTimeout) {
        this.responseTimeout = responseTimeout;
        return this;
    }

    public Duration getResponseTimeout() {
        return HttpClientOptions.getTimeout(this.responseTimeout, DEFAULT_RESPONSE_TIMEOUT);
    }

    public HttpClientOptions readTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public HttpClientOptions setReadTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public Duration getReadTimeout() {
        return HttpClientOptions.getTimeout(this.readTimeout, DEFAULT_READ_TIMEOUT);
    }

    public HttpClientOptions setMaximumConnectionPoolSize(Integer maximumConnectionPoolSize) {
        if (maximumConnectionPoolSize != null && maximumConnectionPoolSize <= 0) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'maximumConnectionPoolSize' cannot be less than 1."));
        }
        this.maximumConnectionPoolSize = maximumConnectionPoolSize;
        return this;
    }

    public Integer getMaximumConnectionPoolSize() {
        return this.maximumConnectionPoolSize;
    }

    public HttpClientOptions setConnectionIdleTimeout(Duration connectionIdleTimeout) {
        this.connectionIdleTimeout = connectionIdleTimeout;
        return this;
    }

    public Duration getConnectionIdleTimeout() {
        return HttpClientOptions.getTimeout(this.connectionIdleTimeout, DEFAULT_CONNECTION_IDLE_TIMEOUT);
    }

    private static Duration getTimeout(Duration configuredTimeout, Duration defaultTimeout) {
        if (configuredTimeout == null) {
            return defaultTimeout;
        }
        if (configuredTimeout.isZero() || configuredTimeout.isNegative()) {
            return NO_TIMEOUT;
        }
        return configuredTimeout.compareTo(MINIMUM_TIMEOUT) > 0 ? configuredTimeout : MINIMUM_TIMEOUT;
    }

    static {
        DEFAULT_CONNECTION_IDLE_TIMEOUT = Duration.ofSeconds(60L);
        NO_TIMEOUT = Duration.ZERO;
        LOGGER = new ClientLogger(HttpClientOptions.class);
        Configuration configuration = Configuration.getGlobalConfiguration();
        DEFAULT_CONNECT_TIMEOUT = CoreUtils.getDefaultTimeoutFromEnvironment(configuration, "AZURE_REQUEST_CONNECT_TIMEOUT", Duration.ofSeconds(10L), LOGGER);
        DEFAULT_WRITE_TIMEOUT = CoreUtils.getDefaultTimeoutFromEnvironment(configuration, "AZURE_REQUEST_WRITE_TIMEOUT", Duration.ofSeconds(60L), LOGGER);
        DEFAULT_RESPONSE_TIMEOUT = CoreUtils.getDefaultTimeoutFromEnvironment(configuration, "AZURE_REQUEST_RESPONSE_TIMEOUT", Duration.ofSeconds(60L), LOGGER);
        DEFAULT_READ_TIMEOUT = CoreUtils.getDefaultTimeoutFromEnvironment(configuration, "AZURE_REQUEST_READ_TIMEOUT", Duration.ofSeconds(60L), LOGGER);
    }
}

