/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.implementation.http.BufferedHttpResponse;
import com.azure.core.implementation.util.BinaryDataHelper;
import com.azure.core.implementation.util.FluxByteBufferContent;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.Objects;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class HttpResponse
implements Closeable {
    private final HttpRequest request;

    protected HttpResponse(HttpRequest request) {
        this.request = request;
    }

    public abstract int getStatusCode();

    public abstract String getHeaderValue(String var1);

    public abstract HttpHeaders getHeaders();

    public abstract Flux<ByteBuffer> getBody();

    public BinaryData getBodyAsBinaryData() {
        Flux<ByteBuffer> body = this.getBody();
        if (body != null) {
            return BinaryDataHelper.createBinaryData(new FluxByteBufferContent(body));
        }
        return null;
    }

    public abstract Mono<byte[]> getBodyAsByteArray();

    public abstract Mono<String> getBodyAsString();

    public abstract Mono<String> getBodyAsString(Charset var1);

    public Mono<InputStream> getBodyAsInputStream() {
        return this.getBodyAsByteArray().map(ByteArrayInputStream::new);
    }

    public final HttpRequest getRequest() {
        return this.request;
    }

    public HttpResponse buffer() {
        return new BufferedHttpResponse(this);
    }

    public Mono<Void> writeBodyToAsync(AsynchronousByteChannel channel) {
        Objects.requireNonNull(channel, "'channel' must not be null");
        Flux<ByteBuffer> body = this.getBody();
        if (body != null) {
            return FluxUtil.writeToAsynchronousByteChannel(body, channel);
        }
        return Mono.empty();
    }

    public void writeBodyTo(WritableByteChannel channel) throws IOException {
        Flux<ByteBuffer> body = this.getBody();
        if (body != null) {
            FluxUtil.writeToWritableByteChannel(body, channel).block();
        }
    }

    @Override
    public void close() {
    }
}

